/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal.export;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.TimedToken;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.Context;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.dataLayer.DataLayer;
import pipe.gui.petrinet.graphicElements.Arc;
import pipe.gui.petrinet.graphicElements.ArcPathPoint;
import pipe.gui.petrinet.graphicElements.Place;
import pipe.gui.petrinet.graphicElements.Transition;
import pipe.gui.petrinet.graphicElements.tapn.TimedInhibitorArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedInputArcComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedPlaceComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransitionComponent;
import pipe.gui.petrinet.graphicElements.tapn.TimedTransportArcComponent;

public class TikZExporter {
    private final DataLayer net;
    private final String fullpath;
    private final TikZOutputOption option;

    public TikZExporter(DataLayer net, String fullpath, TikZOutputOption option) {
        this.net = net;
        this.fullpath = fullpath;
        this.option = option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ExportToTikZ() {
        FileWriter outFile = null;
        PrintWriter out = null;
        try {
            outFile = new FileWriter(this.fullpath);
            out = new PrintWriter(outFile);
            if (this.option == TikZOutputOption.FULL_LATEX) {
                out.println("\\documentclass[a4paper]{article}");
                out.println("\\usepackage{tikz}");
                out.println("\\usetikzlibrary{petri,arrows,positioning}");
                out.println("\\usepackage{amstext}");
                out.println();
                out.println("\\begin{document}");
                out.println();
                out.println();
            }
            out.println("%% TikZ style options %%");
            out.print(this.exportTikZstyle());
            out.println();
            out.println("%% TikZ-figure elements %%");
            out.print(this.exportPlacesWithTokens(this.net.getPlaces()));
            out.print(this.exportTransitions(this.net.getTransitions()));
            out.print(this.exportArcs(this.net.getArcs()));
            out.println(this.exportGlobalVariables());
            out.println("\\end{tikzpicture}");
            if (this.option == TikZOutputOption.FULL_LATEX) {
                out.println("\\end{document}");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (outFile != null) {
                try {
                    outFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private StringBuffer exportArcs(Arc[] arcs) {
        StringBuffer out = new StringBuffer();
        for (Arc arc : arcs) {
            Object arcPoints = "";
            for (int i = 1; i < arc.getArcPath().getEndIndex(); ++i) {
                ArcPathPoint currentPoint = arc.getArcPath().getArcPathPoint(i);
                if (!currentPoint.getPointType()) {
                    arcPoints = (String)arcPoints + "to [bend right=0] (" + currentPoint.getX() + "," + currentPoint.getY() * -1 + ") ";
                    continue;
                }
                if (!currentPoint.getPointType()) continue;
                double xCtrl1 = Math.round(currentPoint.getControl1().getX());
                double yCtrl1 = Math.round(currentPoint.getControl1().getY() * -1.0);
                double xCtrl2 = Math.round(currentPoint.getControl2().getX());
                double yCtrl2 = Math.round(currentPoint.getControl2().getY() * -1.0);
                arcPoints = (String)arcPoints + " .. controls(" + xCtrl1 + "," + yCtrl1 + ")";
                arcPoints = (String)arcPoints + " and ";
                arcPoints = (String)arcPoints + "(" + xCtrl2 + "," + yCtrl2 + ") .. ";
                arcPoints = (String)arcPoints + "(" + currentPoint.getX() + "," + currentPoint.getY() * -1 + ") ";
            }
            String arrowType = this.getArcArrowType(arc);
            out.append("% Arc between " + arc.getSource().getName() + " and " + arc.getTarget().getName() + "\n");
            out.append("\\draw[");
            out.append(arrowType);
            out.append(",pos=0.5] (");
            out.append(arc.getSource().getId());
            out.append(") ");
            out.append((String)arcPoints);
            out.append("to node[bend right=0,auto,align=left]");
            out.append(" {");
            if (arrowType.equals("inhibArc")) {
                out.append(this.handleNameLabel(arc.getNameLabel().getText().replace("x", "\\times")));
            } else {
                out.append(this.handleNameLabel(arc.getNameLabel().getText()));
            }
            out.append("} ");
            out.append("(" + arc.getTarget().getId() + ");\n");
        }
        return out;
    }

    private String getArcArrowType(Arc arc) {
        String arrowType = "";
        arrowType = arc instanceof TimedInhibitorArcComponent ? "inhibArc" : (arc instanceof TimedTransportArcComponent ? "transportArc" : (arc instanceof TimedInputArcComponent ? "arc" : "arc"));
        return arrowType;
    }

    private StringBuffer exportTransitions(Transition[] transitions) {
        StringBuffer out = new StringBuffer();
        for (Transition trans : transitions) {
            Object angle = "";
            if (trans.getAngle() != 0) {
                angle = ",rotate=-" + trans.getAngle();
            }
            out.append("\\node[transition");
            out.append((String)angle);
            out.append(this.handlePlaceAndTransitionLabel(trans.getNameLabel().getText(), trans.getName(), trans.getAttributesVisible()));
            out.append("] at (");
            out.append(trans.getPositionX());
            out.append(',');
            out.append(trans.getPositionY() * -1);
            out.append(") (");
            out.append(trans.getId());
            out.append(") {};\n");
            if (((TimedTransitionComponent)trans).underlyingTransition().isShared()) {
                out.append("\\node[sharedtransition");
                out.append((String)angle);
                out.append("] at (");
                out.append(trans.getId());
                out.append(".center) { };\n");
            }
            if (((TimedTransitionComponent)trans).underlyingTransition().isUrgent()) {
                out.append("\\node[urgenttransition");
                out.append((String)angle);
                out.append("] at (");
                out.append(trans.getId());
                out.append(".center) { };\n");
            }
            if (!((TimedTransitionComponent)trans).underlyingTransition().isUncontrollable()) continue;
            out.append("\\node[uncontrollabletransition");
            out.append((String)angle);
            out.append("] at (");
            out.append(trans.getId());
            out.append(".center) { };\n");
        }
        return out;
    }

    private String handlePlaceAndTransitionLabel(String nameLabelText, String name, boolean isVisible) {
        if (!isVisible) {
            return "";
        }
        Object result = ", label={[align=left,label distance=0cm]90:";
        result = (String)result + "$\\mathrm{" + name.replace("_", "\\_") + "}$";
        result = (String)result + this.handleNameLabel(nameLabelText);
        result = (String)result + "}";
        return result;
    }

    private StringBuffer exportPlacesWithTokens(Place[] places) {
        StringBuffer out = new StringBuffer();
        for (Place place : places) {
            String invariant = "$" + this.getPlaceInvariantString(place) + "$";
            String tokensInPlace = this.getTokenListStringFor(place);
            out.append("\\node[place");
            out.append(this.handlePlaceAndTransitionLabel(place.getNameLabel().getText(), place.getName(), place.getAttributesVisible()));
            out.append("] at (");
            out.append(place.getPositionX());
            out.append(',');
            out.append(place.getPositionY() * -1);
            out.append(") (");
            out.append(place.getId());
            out.append(") {};\n");
            this.exportPlaceTokens(place, out, ((TimedPlaceComponent)place).underlyingPlace().tokens().size());
            if (!((TimedPlaceComponent)place).underlyingPlace().isShared()) continue;
            out.append("\\node[sharedplace ");
            out.append("] at (");
            out.append(place.getId());
            out.append(".center) { };\n");
        }
        return out;
    }

    private String handleNameLabel(String nameLabel) {
        Object nameLabelsString = "";
        String[] labelsInName = nameLabel.split("\n");
        for (int i = 0; i < labelsInName.length; ++i) {
            if (labelsInName[i].contains("[")) {
                nameLabelsString = (String)nameLabelsString + this.escapeSpacesInAndOrNot(this.replaceWithMathLatex(labelsInName[i]));
            } else if (!labelsInName[i].isEmpty()) {
                nameLabelsString = (String)nameLabelsString + this.escapeSpacesInAndOrNot(this.replaceWithMathLatex(labelsInName[i]));
            }
            if (i == labelsInName.length - 1) continue;
            nameLabelsString = (String)nameLabelsString + "\\\\";
        }
        return nameLabelsString;
    }

    private String escapeSpacesInAndOrNot(String str) {
        return str.replace(" and ", "\\ and\\ ").replace(" or", "\\ or\\ ").replace(" not", "\\ not\\ ");
    }

    private void exportPlaceTokens(Place place, StringBuffer out, int numOfTokens) {
        double tRadius = 1.0;
        double tLeftX = 7.0;
        double tRightX = 7.0;
        double tTopY = 7.0;
        double tBotY = 7.0;
        boolean isTimed = TAPAALGUI.getCurrentTab().getLens().isTimed();
        double placeXpos = place.getPositionX();
        double placeYpos = place.getPositionY() * -1;
        if (isTimed && numOfTokens > 0) {
            switch (numOfTokens) {
                case 2: {
                    out.append("\\node at (");
                    out.append(placeXpos);
                    out.append(",");
                    out.append(placeYpos + 4.0);
                    out.append(")");
                    out.append("{0.0};\n");
                    out.append("\\node at (");
                    out.append(placeXpos);
                    out.append(",");
                    out.append(placeYpos - 5.0);
                    out.append(")");
                    out.append("{0.0};\n");
                    return;
                }
                case 1: {
                    out.append("\\node at (");
                    out.append(placeXpos);
                    out.append(",");
                    out.append(placeYpos);
                    out.append(")");
                    out.append("{0.0};\n");
                    return;
                }
            }
            out.append("\\node at (");
            out.append(placeXpos);
            out.append(",");
            out.append(placeYpos);
            out.append(")");
            out.append("{$\\mathrm{");
            out.append("\\#" + numOfTokens + "}$};\n");
            return;
        }
        if (numOfTokens > 5 && !isTimed) {
            out.append("\\node at (");
            out.append(placeXpos);
            out.append(",");
            out.append(placeYpos);
            out.append(")");
            out.append("{$\\mathrm{");
            out.append("\\#" + numOfTokens + "}$};\n");
            return;
        }
        switch (numOfTokens) {
            case 5: {
                out.append("\\node at (");
                out.append(placeXpos);
                out.append(",");
                out.append(placeYpos);
                out.append(")");
                out.append("[circle,fill,inner sep=");
                out.append(1.0);
                out.append("pt]{};\n");
            }
            case 4: {
                out.append("\\node at (");
                out.append(placeXpos - 7.0);
                out.append(",");
                out.append(placeYpos + 7.0);
                out.append(")");
                out.append("[circle,fill,inner sep=");
                out.append(1.0);
                out.append("pt]{};\n");
            }
            case 3: {
                double yPos;
                double xPos;
                if (numOfTokens == 5 || numOfTokens == 4) {
                    xPos = placeXpos + 7.0;
                    yPos = placeYpos + 7.0;
                } else {
                    xPos = placeXpos - 7.0;
                    yPos = placeYpos + 7.0;
                }
                out.append("\\node at (");
                out.append(xPos);
                out.append(",");
                out.append(yPos);
                out.append(")");
                out.append("[circle,fill,inner sep=");
                out.append(1.0);
                out.append("pt]{};\n");
            }
            case 2: {
                double yPos;
                double xPos;
                if (numOfTokens == 5 || numOfTokens == 4) {
                    xPos = placeXpos - 7.0;
                    yPos = placeYpos - 7.0;
                } else if (numOfTokens == 3) {
                    xPos = placeXpos;
                    yPos = placeYpos;
                } else {
                    xPos = placeXpos - 7.0;
                    yPos = placeYpos;
                }
                out.append("\\node at (");
                out.append(xPos);
                out.append(",");
                out.append(yPos);
                out.append(")");
                out.append("[circle,fill,inner sep=");
                out.append(1.0);
                out.append("pt]{};\n");
            }
            case 1: {
                double yPos;
                double xPos;
                if (numOfTokens == 5 || numOfTokens == 4 || numOfTokens == 3) {
                    xPos = placeXpos + 7.0;
                    yPos = placeYpos - 7.0;
                } else if (numOfTokens == 2) {
                    xPos = placeXpos + 7.0;
                    yPos = placeYpos;
                } else {
                    xPos = placeXpos;
                    yPos = placeYpos;
                }
                out.append("\\node at (");
                out.append(xPos);
                out.append(",");
                out.append(yPos);
                out.append(")");
                out.append("[circle,fill,inner sep=");
                out.append(1.0);
                out.append("pt]{};\n");
            }
        }
    }

    private StringBuffer exportGlobalVariables() {
        StringBuffer out = new StringBuffer();
        Context context = new Context(TAPAALGUI.getCurrentTab());
        List<ColorType> listColorTypes = context.network().colorTypes();
        ArrayList<Constant> constantsList = new ArrayList<Constant>(context.network().constants());
        List<Variable> variableList = context.network().variables();
        if (!context.network().isColored()) {
            if (constantsList.isEmpty()) {
                return out;
            }
            out.append("%%Global box which contains global color types, variables and/or constants.\n");
            out.append("\\node [globalBox] (globalBox) at (current bounding box.north west) [anchor=south west] {");
            this.exportConstants(constantsList, out);
            out.append("};");
            return out;
        }
        if (listColorTypes.isEmpty() && constantsList.isEmpty() && variableList.isEmpty()) {
            return out;
        }
        out.append("%%Global box which contains global color types, variables and/or constants.\n");
        out.append("\\node [globalBox] (globalBox) at (current bounding box.north west) [anchor=south west] {");
        this.exportColorTypes(listColorTypes, out);
        if (listColorTypes.size() > 0 && (variableList.size() > 0 || constantsList.size() > 0)) {
            out.append("\\\\");
        }
        this.exportVariables(variableList, out);
        if (variableList.size() > 0 && !constantsList.isEmpty()) {
            out.append("\\\\");
        }
        this.exportConstants(constantsList, out);
        out.append("};");
        return out;
    }

    private void exportColorTypes(List<ColorType> listColorTypes, StringBuffer out) {
        Object stringColorList = "";
        for (int i = 0; i < listColorTypes.size(); ++i) {
            int x;
            if (i == 0) {
                out.append("Color Types:\\\\");
            }
            out.append("$\\mathit{" + listColorTypes.get(i).getName() + "}$ \\textbf{is} ");
            if (listColorTypes.get(i).isProductColorType()) {
                out.append("$\\mathit{<");
                for (x = 0; x < listColorTypes.get(i).getProductColorTypes().size(); ++x) {
                    stringColorList = (String)stringColorList + listColorTypes.get(i).getProductColorTypes().get(x).getName().replace("_", "\\_");
                    if (x == listColorTypes.get(i).getProductColorTypes().size() - 1) continue;
                    stringColorList = (String)stringColorList + ", ";
                }
                out.append((String)stringColorList + ">}$\\\\");
                stringColorList = "";
                continue;
            }
            if (listColorTypes.get(i).isIntegerRange()) {
                out.append("$\\mathit{");
                if (listColorTypes.get(i).size() > 1) {
                    int listSize = listColorTypes.get(i).size();
                    out.append("[" + listColorTypes.get(i).getColors().get(0).getColorName().replace("_", "\\_") + "," + listColorTypes.get(i).getColors().get(listSize - 1).getColorName().replace("_", "\\_") + "]");
                } else {
                    out.append("[" + listColorTypes.get(i).getFirstColor().getColorName().replace("_", "\\_") + "]");
                }
                out.append("}$\\\\");
                continue;
            }
            out.append("$\\mathit{[");
            for (x = 0; x < listColorTypes.get(i).getColors().size(); ++x) {
                stringColorList = (String)stringColorList + listColorTypes.get(i).getColors().get(x).getName().replace("_", "\\_");
                if (x == listColorTypes.get(i).getColors().size() - 1) continue;
                stringColorList = (String)stringColorList + ", ";
            }
            out.append((String)stringColorList + "]}$\\\\");
            stringColorList = "";
        }
    }

    private void exportVariables(List<Variable> variableList, StringBuffer out) {
        Object result = "";
        for (int i = 0; i < variableList.size(); ++i) {
            if (i == 0) {
                result = (String)result + "Variables:\\\\ ";
            }
            result = (String)result + "$\\mathit{" + variableList.get(i).getName().replace("_", "\\_") + " \\textbf{ in } " + variableList.get(i).getColorType().getName().replace("_", "\\_") + "}$";
            if (i == variableList.size() - 1) continue;
            result = (String)result + "\\\\";
        }
        out.append((String)result);
    }

    private void exportConstants(List<Constant> constantsList, StringBuffer out) {
        Object result = "";
        for (int i = 0; i < constantsList.size(); ++i) {
            if (i == 0) {
                result = (String)result + "Constants:\\\\";
            }
            result = (String)result + "$\\mathit{" + constantsList.get(i).toString().replace("_", "\\_") + "}$";
            if (i == constantsList.size() - 1) continue;
            result = (String)result + "\\\\";
        }
        out.append((String)result);
    }

    protected String getTokenListStringFor(Place place) {
        List<TimedToken> tokens = ((TimedPlaceComponent)place).underlyingPlace().tokens();
        Object tokensInPlace = "";
        if (tokens.size() > 0) {
            tokensInPlace = tokens.size() == 1 ? ", structured tokens={" + String.valueOf(tokens.get(0).age().setScale(1)) + "}," : this.exportMultipleTokens(tokens);
        }
        return tokensInPlace;
    }

    protected String getPlaceInvariantString(Place place) {
        Object invariant = "";
        if (!((TimedPlaceComponent)place).getInvariantAsString().contains("inf")) {
            invariant = this.replaceWithMathLatex(((TimedPlaceComponent)place).getInvariantAsString()) + "};\n";
        }
        return invariant;
    }

    private String exportMultipleTokens(List<TimedToken> tokens) {
        StringBuilder out = new StringBuilder();
        out.append(", structured tokens={\\#");
        out.append(tokens.size());
        out.append("},");
        out.append("pin=above:{\\{");
        for (int i = 0; i < tokens.size() - 1; ++i) {
            out.append(tokens.get(i).age().setScale(1));
            out.append(',');
        }
        out.append(tokens.get(tokens.size() - 1).age().setScale(1));
        out.append("\\}},");
        return out.toString();
    }

    private StringBuffer exportTikZstyle() {
        StringBuffer out = new StringBuffer();
        out.append("\\begin{tikzpicture}[font=\\scriptsize, xscale=0.45, yscale=0.45, x=1.33pt, y=1.33pt]\n");
        out.append("%% the figure can be scaled by changing xscale and yscale or the size of the x- and y-coordinates\n");
        out.append("%% positions of place/transition labels that are currently fixed to label=135 degrees\n");
        out.append("%% these can be adjusted by adjusting either the coordinates, the label distance or the label degree\n");
        out.append("%% that is placed right after the 'label-distance'. 90: is above (default), 180 is left, 270 is below etc.\n");
        out.append("%% The curving of arcs can be done by adjusting bend left/right=XX\n");
        out.append("%% labels may be slightly skewed compared to the Tapaal drawing due to rounding.\n");
        out.append("%% This can be adjusted by tuning the coordinates of the label, or the degree (see above)\n");
        out.append("%% The box containing global variables can also be moved by adjusting the anchor points / bounding box in the [globalBox] node at the end of the Tikz document\n");
        out.append("\\tikzstyle{arc}=[->,>=stealth,thick]\n");
        out.append("\\tikzstyle{transportArc}=[->,>=diamond,thick]\n");
        out.append("\\tikzstyle{inhibArc}=[->,>=o,thick]\n");
        out.append("\\tikzstyle{every place}=[minimum size=6mm,thick]\n");
        out.append("\\tikzstyle{every transition} = [fill=black,minimum width=2mm,minimum height=5mm]\n");
        out.append("\\tikzstyle{every token}=[fill=white,text=black]\n");
        out.append("\\tikzstyle{sharedplace}=[place,minimum size=7.5mm,dashed,thin]\n");
        out.append("\\tikzstyle{sharedtransition}=[transition, fill opacity=0, minimum width=3.5mm, minimum height=6.5mm,dashed]\n");
        out.append("\\tikzstyle{urgenttransition}=[place,fill=white,minimum size=2.0mm,thin]\n");
        out.append("\\tikzstyle{uncontrollabletransition}=[transition,fill=white,draw=black,very thick]\n");
        out.append("\\tikzstyle{globalBox} = [draw,thick,align=left]");
        return out;
    }

    protected String replaceWithMathLatex(String text) {
        String[] stringList = text.split(" ");
        Object result = "";
        for (int i = 0; i < stringList.length; ++i) {
            result = (String)result + "$\\mathit{" + this.replaceSpecialSymbols(stringList[i]) + "}$ ";
        }
        return result;
    }

    protected String replaceSpecialSymbols(String text) {
        return text.replace("inf", "\\infty").replace("<=", "\\leq").replace("*", "\\cdot").replace("\u2192", "\\rightarrow").replace("\u221e", "\\infty");
    }

    public static enum TikZOutputOption {
        FIGURE_ONLY,
        FULL_LATEX;

    }
}

