/*
 * Decompiled with CFR 0.152.
 */
package net.tapaal;

import dk.aau.cs.debug.Logger;
import dk.aau.cs.io.batchProcessing.BatchProcessingResultsExporter;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.MemoryMonitor;
import dk.aau.cs.util.VerificationCallback;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.batchProcessing.BatchProcessingVerificationResult;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.tapaal.gui.petrinet.dialog.BatchProcessingResultsTableModel;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.Verifier;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import pipe.gui.TAPAALGUI;
import pipe.gui.petrinet.PetriNetTab;

public class TAPAAL {
    public static final String TOOLNAME = "TAPAAL";
    public static final String VERSION = "4.0.3";
    public static final boolean IS_DEV = "DEV".equals("4.0.3");

    public static String getProgramName() {
        return "TAPAAL 4.0.3";
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("d", "debug", false, "enable debug output .");
        CommandLine commandline = null;
        try {
            commandline = parser.parse(options, args);
        }
        catch (ParseException exp) {
            System.err.println("There where an error parsing the specified arguments");
            System.err.println("Unexpected exception:" + exp.getMessage());
        }
        if (commandline.hasOption("debug")) {
            Logger.enableLogging(true);
        }
        if (IS_DEV) {
            Logger.enableLogging(true);
            Logger.log("Debug logging is enabled by default in DEV branch");
        }
        if (commandline.hasOption("batch")) {
            String[] files = commandline.getArgs();
            File batchFolder = new File(files[0]);
            TAPAAL.batchProcessing(batchFolder);
            return;
        }
        TAPAALGUI.init();
        String[] files = commandline.getArgs();
        Logger.log("Opening #files: " + files.length);
        for (String f : files) {
            File file = new File(f);
            if (file.exists()) {
                if (file.canRead()) {
                    try {
                        TAPAALGUI.getAppGuiController().openTab(PetriNetTab.createNewTabFromFile(file));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!file.exists()) continue;
                System.err.println("Can not read file " + String.valueOf(file));
                continue;
            }
            System.err.println("Can not find file " + String.valueOf(file));
        }
    }

    private static void batchProcessing(File batchFolder) throws Exception {
        TAPAALGUI.init();
        TAPAALGUI.getAppGui().setVisible(false);
        System.out.println("=============================================================");
        System.out.println("Batch Processing");
        System.out.println("=============================================================");
        System.out.println("Running in batch mode for " + batchFolder.getAbsolutePath());
        final BatchProcessingResultsTableModel results = new BatchProcessingResultsTableModel();
        for (final File f : batchFolder.listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".tapn") && !f.getName().toLowerCase().endsWith(".xml")) continue;
            System.out.println("Processing File: " + String.valueOf(f));
            PetriNetTab tab = PetriNetTab.createNewTabFromInputStream(new FileInputStream(f), f.getName());
            TimedArcPetriNetNetwork network = tab.network();
            List queries = StreamSupport.stream(tab.queries().spliterator(), false).collect(Collectors.toList());
            for (final TAPNQuery query : queries) {
                System.out.println("    | Running query: " + query.getName());
                if (query.getReductionOption() == ReductionOption.VerifyTAPN || query.getReductionOption() == ReductionOption.VerifyDTAPN || query.getReductionOption() == ReductionOption.VerifyPN) {
                    Verifier.runVerifyTAPNVerification(network, query, new VerificationCallback(){

                        @Override
                        public void run(VerificationResult<TAPNNetworkTrace> result) {
                            String resultString = result.getQueryResult().isQuerySatisfied() ? "Satisfied" : "Not Satisfied";
                            System.out.println("    | Result: " + resultString);
                            results.addResult(new BatchProcessingVerificationResult(f.toString(), query, resultString, result.verificationTime(), MemoryMonitor.getPeakMemory(), result.getRawOutput(), result.stats()));
                        }
                    }, tab.getGuiModels(), false, null);
                    continue;
                }
                System.out.println("    | Skipped");
            }
        }
        System.out.println("===========================================");
        System.out.println("===========================================");
        BatchProcessingResultsExporter exporter = new BatchProcessingResultsExporter();
        exporter.exportToCSV(results.getResults(), System.out);
        System.out.println("Done" + results.getRowCount());
    }

    public static File getInstallDir() {
        Object str = ClassLoader.getSystemResource("TAPAAL.class").getPath();
        int placeOfJarSeperator = ((String)str).lastIndexOf(33);
        if (placeOfJarSeperator != -1) {
            str = ((String)str).substring(0, placeOfJarSeperator);
            str = ((String)str).substring(0, ((String)str).lastIndexOf("/"));
        } else {
            str = ((String)str).replace("TAPAAL.class", "");
        }
        try {
            URL url;
            URI uri;
            if (!((String)str).contains("file:/")) {
                str = "file://" + (String)str;
            }
            if ((uri = (url = new URL((String)str)).toURI()).getAuthority() != null) {
                try {
                    uri = new URI(uri.toString().replace("file://", "file:////"));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("The specified URI contains an authority, but could not be normalized.", e);
                }
            }
            File f = new File(uri);
            str = f.getAbsolutePath();
            File installdir = new File((String)str);
            installdir = installdir.getParentFile();
            return installdir;
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

