/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.observations.expressions;

import dk.aau.cs.verification.observations.expressions.ObsExprPosition;
import dk.aau.cs.verification.observations.expressions.ObsExpression;
import dk.aau.cs.verification.observations.expressions.ObsPlaceHolder;

public abstract class ObsOperator
extends ObsExpression {
    protected ObsExpression left;
    protected ObsExpression right;
    private boolean hadParentheses = false;

    protected ObsOperator(ObsExpression left, ObsExpression right) {
        this.left = left;
        this.right = right;
    }

    protected ObsOperator() {
        this(new ObsPlaceHolder(), new ObsPlaceHolder());
    }

    public void insertLeftMost(ObsExpression expr) {
        expr.parent = this;
        if (this.left.isOperator()) {
            ((ObsOperator)this.left).insertLeftMost(expr);
        } else {
            this.left = expr;
        }
    }

    public void setLeft(ObsExpression left) {
        this.left = left;
    }

    public void setRight(ObsExpression right) {
        this.right = right;
    }

    public void replace(ObsExpression selectedExpr, ObsExpression newExpr) {
        if (this.left.equals(selectedExpr) || this.right.equals(selectedExpr)) {
            newExpr.parent = this;
            if (this.left.equals(selectedExpr)) {
                this.left = newExpr;
            } else if (this.right.equals(selectedExpr)) {
                this.right = newExpr;
            }
        } else {
            if (this.left.isOperator()) {
                ((ObsOperator)this.left).replace(selectedExpr, newExpr);
            }
            if (this.right.isOperator()) {
                ((ObsOperator)this.right).replace(selectedExpr, newExpr);
            }
        }
    }

    @Override
    public ObsExpression deepCopy() {
        try {
            ObsOperator copy = (ObsOperator)this.getClass().getConstructor(ObsExpression.class, ObsExpression.class).newInstance(this.left.deepCopy(), this.right.deepCopy());
            copy.setParent(this.parent);
            return copy;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy ObsOperator", e);
        }
    }

    public void hadParentheses(boolean hadParentheses) {
        this.hadParentheses = hadParentheses;
    }

    private boolean addParenthesis() {
        return this.parent != null && this.parent.getClass() != this.getClass() || this.hadParentheses;
    }

    @Override
    public ObsExprPosition getObjectPosition(int index) {
        int parenOffset;
        int leftLen = this.left.toString().length();
        int rightLen = this.right.toString().length();
        int totalLen = this.toString().length();
        int thisLen = totalLen - leftLen - rightLen;
        int n = parenOffset = this.addParenthesis() ? 1 : 0;
        if (index < leftLen + parenOffset) {
            return this.left.getObjectPosition(index - parenOffset).addOffset(parenOffset);
        }
        if (index >= leftLen + thisLen - parenOffset) {
            return this.right.getObjectPosition(index - leftLen - thisLen).addOffset(leftLen + thisLen - parenOffset);
        }
        return new ObsExprPosition(0, totalLen, this);
    }

    @Override
    public ObsExprPosition getObjectPosition(ObsExpression expr) {
        if (this.equals(expr)) {
            return new ObsExprPosition(0, this.toString().length(), this);
        }
        int parenOffset = this.addParenthesis() ? 1 : 0;
        int leftLen = this.left.toString().length();
        int thisLen = this.toString().length() - leftLen - this.right.toString().length();
        ObsExprPosition leftPos = this.left.getObjectPosition(expr);
        if (leftPos != null) {
            return leftPos.addOffset(parenOffset);
        }
        ObsExprPosition rightPos = this.right.getObjectPosition(expr);
        if (rightPos != null) {
            return rightPos.addOffset(leftLen + thisLen - parenOffset);
        }
        return null;
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    public ObsExpression getLeft() {
        return this.left;
    }

    public ObsExpression getRight() {
        return this.right;
    }

    public String toString() {
        String operator = this.getOperator();
        if (this.addParenthesis()) {
            return "(" + String.valueOf(this.left) + " " + operator + " " + String.valueOf(this.right) + ")";
        }
        return String.valueOf(this.left) + " " + operator + " " + String.valueOf(this.right);
    }

    protected abstract String getOperator();
}

