/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.util.Require;
import dk.aau.cs.verification.VerificationOptions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.MessengerImpl;

public class VerifyTAPNOptions
extends VerificationOptions {
    protected int tokensInModel;
    protected boolean kBoundPresentInRawVerificationOptions;
    protected boolean tracePresentInRawVerificationOptions;
    protected boolean unfold;
    private final boolean symmetry;
    private final boolean discreteInclusion;
    private final boolean tarOption;
    private InclusionPlaces inclusionPlaces;
    private boolean useRawVerification;
    private String rawVerificationOptions;
    private final boolean dontUseDeadPlaces = false;
    private static final Map<TAPNQuery.TraceOption, String> traceMap = VerifyTAPNOptions.createTraceOptionsMap();
    private static final Map<TAPNQuery.SearchOption, String> searchMap = VerifyTAPNOptions.createSearchOptionsMap();

    public VerifyTAPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean symmetry, boolean useStateequationCheck, boolean discreteInclusion, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, boolean useRawVerification, String rawVerificationOptions) {
        this(extraTokens, traceOption, search, symmetry, useStateequationCheck, discreteInclusion, new InclusionPlaces(), enableOverApproximation, enableUnderApproximation, approximationDenominator);
        this.rawVerificationOptions = rawVerificationOptions;
        this.useRawVerification = useRawVerification;
    }

    public VerifyTAPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean symmetry, boolean useStateequationCheck, boolean discreteInclusion, InclusionPlaces inclusionPlaces, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator) {
        this(extraTokens, traceOption, search, symmetry, useStateequationCheck, discreteInclusion, inclusionPlaces, enableOverApproximation, enableUnderApproximation, approximationDenominator, false);
    }

    public VerifyTAPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean symmetry, boolean useStateequationCheck, boolean discreteInclusion, InclusionPlaces inclusionPlaces, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, boolean tarOption, boolean isColor, boolean useRawVerification, String rawVerificationOptions) {
        this(extraTokens, traceOption, search, symmetry, useStateequationCheck, discreteInclusion, inclusionPlaces, enableOverApproximation, enableUnderApproximation, approximationDenominator, tarOption);
        this.useRawVerification = useRawVerification;
        this.rawVerificationOptions = rawVerificationOptions;
        this.unfold = isColor;
        if (isColor && this.trace() != TAPNQuery.TraceOption.NONE && !useRawVerification || enableOverApproximation || enableUnderApproximation) {
            try {
                unfoldedModelPath = File.createTempFile("unfolded-", ".pnml").getAbsolutePath();
                unfoldedQueriesPath = File.createTempFile("unfoldedQueries-", ".xml").getAbsolutePath();
            }
            catch (IOException e) {
                new MessengerImpl().displayErrorMessage(e.getMessage(), "Error");
            }
        }
    }

    public VerifyTAPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean symmetry, boolean useStateEquationCheck, boolean discreteInclusion, InclusionPlaces inclusionPlaces, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, boolean tarOption) {
        this.extraTokens = extraTokens;
        this.traceOption = traceOption;
        this.searchOption = search;
        this.symmetry = symmetry;
        this.discreteInclusion = discreteInclusion;
        this.useStateequationCheck = useStateEquationCheck;
        this.inclusionPlaces = inclusionPlaces;
        this.enabledOverApproximation = enableOverApproximation;
        this.enabledUnderApproximation = enableUnderApproximation;
        this.approximationDenominator = approximationDenominator;
        this.tarOption = tarOption;
    }

    public TAPNQuery.TraceOption trace() {
        return this.traceOption;
    }

    public boolean symmetry() {
        return this.symmetry;
    }

    public boolean discreteInclusion() {
        return this.discreteInclusion;
    }

    public void setTokensInModel(int tokens) {
        this.tokensInModel = tokens;
    }

    public String kBoundArg() {
        return "--k-bound " + this.kBound() + " ";
    }

    public int kBound() {
        return this.extraTokens + this.tokensInModel;
    }

    public String deadTokenArg() {
        return "";
    }

    protected String rawVerificationString(String rawVerificationOptions, String traceArg) {
        StringBuilder sb = new StringBuilder();
        this.kBoundPresentInRawVerificationOptions = rawVerificationOptions.contains("--k-bound") || rawVerificationOptions.contains("-k");
        boolean bl = this.tracePresentInRawVerificationOptions = rawVerificationOptions.contains("--trace") || rawVerificationOptions.contains("-t");
        if (this.enabledOverApproximation || this.enabledUnderApproximation) {
            if (this.kBoundPresentInRawVerificationOptions) {
                rawVerificationOptions = rawVerificationOptions.replaceAll("(--k-bound|-k) +\\d+", "$1 " + this.kBound());
            }
            if (this.tracePresentInRawVerificationOptions) {
                rawVerificationOptions = rawVerificationOptions.replaceAll("(--trace|-t) +\\d+", "$1 " + traceArg);
            }
        }
        if (!this.kBoundPresentInRawVerificationOptions) {
            sb.append(this.kBoundArg());
        }
        if (!this.tracePresentInRawVerificationOptions) {
            sb.append(traceArg);
        }
        return sb.append(rawVerificationOptions).toString();
    }

    public void setUnfold(boolean unfold) {
        this.unfold = unfold;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.useRawVerification && this.rawVerificationOptions != null) {
            return this.rawVerificationString(this.rawVerificationOptions, traceMap.get((Object)this.traceOption));
        }
        if (this.unfold && this.trace() != TAPNQuery.TraceOption.NONE) {
            result.append(" --write-unfolded-net ");
            result.append(unfoldedModelPath);
            result.append(" --write-unfolded-queries ");
            result.append(unfoldedQueriesPath);
            result.append(" --bindings ");
        }
        result.append(this.kBoundArg());
        result.append(this.deadTokenArg());
        result.append(traceMap.get((Object)this.traceOption));
        result.append(' ');
        result.append(searchMap.get((Object)this.searchOption));
        result.append(' ');
        result.append(this.symmetry ? "" : "--disable-symmetry");
        result.append(' ');
        result.append(this.discreteInclusion ? " --inclusion-check 1" : "");
        result.append((String)(this.discreteInclusion ? " --inclusion-places " + this.generateDiscretePlacesList() : ""));
        return result.toString();
    }

    private String generateDiscretePlacesList() {
        if (this.inclusionPlaces.inclusionOption() == InclusionPlaces.InclusionPlacesOption.AllPlaces) {
            return "*ALL*";
        }
        if (this.inclusionPlaces.inclusionPlaces().isEmpty()) {
            return "*NONE*";
        }
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (TimedPlace p : this.inclusionPlaces.inclusionPlaces()) {
            if (!first) {
                s.append(',');
            }
            s.append(p.name());
            if (!first) continue;
            first = false;
        }
        return s.toString();
    }

    public static Map<TAPNQuery.TraceOption, String> createTraceOptionsMap() {
        HashMap<TAPNQuery.TraceOption, String> map = new HashMap<TAPNQuery.TraceOption, String>();
        map.put(TAPNQuery.TraceOption.SOME, "--trace 1 ");
        map.put(TAPNQuery.TraceOption.FASTEST, "--trace 2 ");
        map.put(TAPNQuery.TraceOption.NONE, "");
        return map;
    }

    private static Map<TAPNQuery.SearchOption, String> createSearchOptionsMap() {
        HashMap<TAPNQuery.SearchOption, String> map = new HashMap<TAPNQuery.SearchOption, String>();
        map.put(TAPNQuery.SearchOption.BFS, "--search-strategy BFS");
        map.put(TAPNQuery.SearchOption.DFS, "--search-strategy DFS");
        map.put(TAPNQuery.SearchOption.RANDOM, "--search-strategy RDFS");
        map.put(TAPNQuery.SearchOption.HEURISTIC, "--search-strategy MAX-COVER");
        map.put(TAPNQuery.SearchOption.DEFAULT, "");
        return map;
    }

    public InclusionPlaces inclusionPlaces() {
        return this.inclusionPlaces;
    }

    public void setInclusionPlaces(InclusionPlaces inclusionPlaces) {
        Require.that(inclusionPlaces != null, "Inclusion places cannot be null");
        this.inclusionPlaces = inclusionPlaces;
    }

    public boolean kBoundPresentInRawVerification() {
        return this.kBoundPresentInRawVerificationOptions;
    }

    public boolean tracePresentInRawVerification() {
        return this.tracePresentInRawVerificationOptions;
    }
}

