/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.DotConstantExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.tapn.LocalTimedMarking;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.NameMapping;
import java.util.Vector;
import java.util.function.Function;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifyTAPNMarkingParser {
    public static LocalTimedMarking parseMarking(TimedArcPetriNet tapn, Element element) {
        LocalTimedMarking marking = new LocalTimedMarking();
        VerifyTAPNMarkingParser.parseTokensForPlaces(element, placeId -> tapn.getPlaceByName((String)placeId), tapn.parentNetwork()::getColorByName, tapn.parentNetwork()::getProductColorByConstituents, (place, token) -> marking.add(token), tapn.parentNetwork());
        return marking;
    }

    public static NetworkMarking parseComposedMarking(TimedArcPetriNetNetwork network, Element element, NameMapping nameMapping) {
        NetworkMarking marking = new NetworkMarking();
        VerifyTAPNMarkingParser.parseTokensForPlaces(element, place -> {
            Tuple<String, String> originalName = nameMapping.map((String)place);
            if (originalName.value1().isEmpty()) {
                return network.getSharedPlaceByName(originalName.value2());
            }
            return network.getTAPNByName(originalName.value1()).getPlaceByName(originalName.value2());
        }, network::getColorByName, network::getProductColorByConstituents, (place, token) -> {
            LocalTimedPlace localPlace;
            TimedArcPetriNet tapn;
            LocalTimedMarking localMarking;
            if (!place.isShared() && (localMarking = marking.getMarkingFor(tapn = (localPlace = (LocalTimedPlace)place).model())) == null) {
                marking.addMarking(tapn, new LocalTimedMarking());
            }
            marking.add(token);
        }, network);
        return marking;
    }

    private static void parseTokensForPlaces(Element element, Function<String, TimedPlace> placeResolver, Function<String, Color> colorResolver, Function<Vector<Color>, Color> productColorResolver, TokenConsumer tokenConsumer, TimedArcPetriNetNetwork network) {
        NodeList placeNodes = element.getElementsByTagName("place");
        for (int i = 0; i < placeNodes.getLength(); ++i) {
            Element placeElement = (Element)placeNodes.item(i);
            String placeId = placeElement.getAttribute("id");
            TimedPlace place = placeResolver.apply(placeId);
            Vector<ArcExpression> placeExpressions = new Vector<ArcExpression>();
            NodeList childNodes = placeElement.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node child = childNodes.item(j);
                if (child.getNodeType() != 1) continue;
                try {
                    ArcExpression arcExpr = VerifyTAPNMarkingParser.parseSimpleArcExpression(child, network);
                    placeExpressions.add(arcExpr);
                    VerifyTAPNMarkingParser.expandArcExpressionToTokens(arcExpr, place, tokenConsumer, productColorResolver);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error parsing arc expression for place " + placeId + ": " + e.getMessage());
                    e.printStackTrace();
                }
            }
            if (placeExpressions.isEmpty()) continue;
            ArcExpression combinedExpression = placeExpressions.size() == 1 ? (ArcExpression)placeExpressions.get(0) : new AddExpression(placeExpressions);
            place.setTokenExpression(combinedExpression);
        }
    }

    private static Node skipWS(Node node) {
        while (node != null && node.getNodeType() == 3 && node.getNodeValue().trim().isEmpty()) {
            node = node.getNextSibling();
        }
        return node;
    }

    private static ArcExpression parseSimpleArcExpression(Node node, TimedArcPetriNetNetwork network) throws Exception {
        String name = node.getNodeName();
        if (name.equals("add")) {
            Vector<ArcExpression> constituents = new Vector<ArcExpression>();
            Node child = VerifyTAPNMarkingParser.skipWS(node.getFirstChild());
            while (child != null) {
                ArcExpression subterm = VerifyTAPNMarkingParser.parseSimpleArcExpression(child, network);
                constituents.add(subterm);
                child = VerifyTAPNMarkingParser.skipWS(child.getNextSibling());
            }
            return new AddExpression(constituents);
        }
        if (name.equals("numberof")) {
            return VerifyTAPNMarkingParser.parseNumberOfExpression(node, network);
        }
        if (name.matches("subterm|structure")) {
            Node child = VerifyTAPNMarkingParser.skipWS(node.getFirstChild());
            return VerifyTAPNMarkingParser.parseSimpleArcExpression(child, network);
        }
        throw new Exception("Unexpected arc expression node: " + name);
    }

    private static NumberOfExpression parseNumberOfExpression(Node node, TimedArcPetriNetNetwork network) throws Exception {
        Node numberNode;
        Node child = VerifyTAPNMarkingParser.skipWS(node.getFirstChild());
        int number = 1;
        if (child != null && child.getNodeName().equals("subterm") && (numberNode = VerifyTAPNMarkingParser.skipWS(child.getFirstChild())) != null && numberNode.getNodeName().equals("numberconstant")) {
            String value = numberNode.getAttributes().getNamedItem("value").getNodeValue();
            number = Integer.parseInt(value);
            child = VerifyTAPNMarkingParser.skipWS(child.getNextSibling());
        }
        Vector<ColorExpression> colorExprs = new Vector<ColorExpression>();
        while (child != null) {
            ColorExpression colorExpr = VerifyTAPNMarkingParser.parseColorExpression(child, network);
            if (colorExpr != null) {
                colorExprs.add(colorExpr);
            }
            child = VerifyTAPNMarkingParser.skipWS(child.getNextSibling());
        }
        return new NumberOfExpression(number, colorExprs);
    }

    private static ColorExpression parseColorExpression(Node node, TimedArcPetriNetNetwork network) throws Exception {
        String name = node.getNodeName();
        if (name.equals("all")) {
            String sortId = node.getAttributes().getNamedItem("declaration").getNodeValue();
            ColorType colorType = network.getColorTypeByName(sortId);
            return new AllExpression(colorType);
        }
        if (name.equals("useroperator")) {
            String colorName = node.getAttributes().getNamedItem("declaration").getNodeValue();
            Color color = network.getColorByName(colorName);
            return new UserOperatorExpression(color);
        }
        if (name.equals("tuple")) {
            Vector<ColorExpression> components = new Vector<ColorExpression>();
            Node child = VerifyTAPNMarkingParser.skipWS(node.getFirstChild());
            while (child != null) {
                ColorExpression comp = VerifyTAPNMarkingParser.parseColorExpression(child, network);
                if (comp != null) {
                    components.add(comp);
                }
                child = VerifyTAPNMarkingParser.skipWS(child.getNextSibling());
            }
            return new TupleExpression(components);
        }
        if (name.equals("dotconstant")) {
            return new DotConstantExpression();
        }
        if (name.equals("finiteintrangeconstant")) {
            String value = node.getAttributes().getNamedItem("value").getNodeValue();
            Node rangeNode = VerifyTAPNMarkingParser.skipWS(node.getFirstChild());
            if (rangeNode != null && rangeNode.getNodeName().equals("finiteintrange")) {
                String start = rangeNode.getAttributes().getNamedItem("start").getNodeValue();
                String end = rangeNode.getAttributes().getNamedItem("end").getNodeValue();
                for (ColorType ct : network.colorTypes()) {
                    Color color;
                    if (!ct.isIntegerRange() || !ct.getFirstColor().getColorName().equals(start) || !ct.getColors().lastElement().getColorName().equals(end) || (color = ct.getColorByName(value)) == null) continue;
                    return new UserOperatorExpression(color);
                }
            }
        } else if (name.matches("subterm|structure")) {
            Node child = VerifyTAPNMarkingParser.skipWS(node.getFirstChild());
            return VerifyTAPNMarkingParser.parseColorExpression(child, network);
        }
        return null;
    }

    private static void expandArcExpressionToTokens(ArcExpression arcExpr, TimedPlace place, TokenConsumer tokenConsumer, Function<Vector<Color>, Color> productColorResolver) {
        block3: {
            block2: {
                if (!(arcExpr instanceof AddExpression)) break block2;
                AddExpression addExpr = (AddExpression)arcExpr;
                for (ArcExpression subExpr : addExpr.getAddExpression()) {
                    VerifyTAPNMarkingParser.expandArcExpressionToTokens(subExpr, place, tokenConsumer, productColorResolver);
                }
                break block3;
            }
            if (!(arcExpr instanceof NumberOfExpression)) break block3;
            NumberOfExpression numOfExpr = (NumberOfExpression)arcExpr;
            int count = numOfExpr.getNumber();
            Vector<ColorExpression> colorExprs = numOfExpr.getNumberOfExpression();
            for (ColorExpression colorExpr : colorExprs) {
                VerifyTAPNMarkingParser.expandColorExpressionToTokens(colorExpr, place, count, tokenConsumer, productColorResolver);
            }
        }
    }

    private static void expandColorExpressionToTokens(ColorExpression colorExpr, TimedPlace place, int count, TokenConsumer tokenConsumer, Function<Vector<Color>, Color> productColorResolver) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!(colorExpr instanceof AllExpression)) break block4;
                        AllExpression allExpr = (AllExpression)colorExpr;
                        ColorType colorType = allExpr.getColorType();
                        for (Color color : colorType.getColors()) {
                            for (int i = 0; i < count; ++i) {
                                TimedToken token = new TimedToken(place, color);
                                tokenConsumer.accept(place, token);
                            }
                        }
                        break block5;
                    }
                    if (!(colorExpr instanceof UserOperatorExpression)) break block6;
                    UserOperatorExpression userOpExpr = (UserOperatorExpression)colorExpr;
                    Color color = userOpExpr.getUserOperator();
                    for (int i = 0; i < count; ++i) {
                        TimedToken token = new TimedToken(place, color);
                        tokenConsumer.accept(place, token);
                    }
                    break block5;
                }
                if (!(colorExpr instanceof TupleExpression)) break block7;
                TupleExpression tupleExpr = (TupleExpression)colorExpr;
                VerifyTAPNMarkingParser.expandTupleExpressionToTokens(tupleExpr, place, count, tokenConsumer, productColorResolver);
                break block5;
            }
            if (!(colorExpr instanceof DotConstantExpression)) break block5;
            ColorType dotType = ColorType.COLORTYPE_DOT;
            Color dotColor = dotType.getColors().get(0);
            for (int i = 0; i < count; ++i) {
                TimedToken token = new TimedToken(place, dotColor);
                tokenConsumer.accept(place, token);
            }
        }
    }

    private static void expandTupleExpressionToTokens(TupleExpression tupleExpr, TimedPlace place, int count, TokenConsumer tokenConsumer, Function<Vector<Color>, Color> productColorResolver) {
        Vector<ColorExpression> components = tupleExpr.getColors();
        boolean hasAll = components.stream().anyMatch(c -> c instanceof AllExpression);
        if (hasAll) {
            VerifyTAPNMarkingParser.expandTupleWithAllExpression(components, place, count, tokenConsumer, new Vector<Color>(), 0, productColorResolver);
        } else {
            Vector<Color> colors = new Vector<Color>();
            for (ColorExpression compExpr : components) {
                if (!(compExpr instanceof UserOperatorExpression)) continue;
                colors.add(((UserOperatorExpression)compExpr).getUserOperator());
            }
            if (colors.size() == components.size()) {
                Color tupleColor = productColorResolver.apply(colors);
                for (int i = 0; i < count; ++i) {
                    TimedToken token = new TimedToken(place, tupleColor);
                    tokenConsumer.accept(place, token);
                }
            }
        }
    }

    private static void expandTupleWithAllExpression(Vector<ColorExpression> components, TimedPlace place, int count, TokenConsumer tokenConsumer, Vector<Color> currentColors, int index, Function<Vector<Color>, Color> productColorResolver) {
        if (index == components.size()) {
            Color tupleColor = productColorResolver.apply(currentColors);
            for (int i = 0; i < count; ++i) {
                TimedToken token = new TimedToken(place, tupleColor);
                tokenConsumer.accept(place, token);
            }
            return;
        }
        ColorExpression component = components.get(index);
        if (component instanceof AllExpression) {
            AllExpression allExpr = (AllExpression)component;
            for (Color color : allExpr.getColorType().getColors()) {
                Vector<Color> newColors = new Vector<Color>(currentColors);
                newColors.add(color);
                VerifyTAPNMarkingParser.expandTupleWithAllExpression(components, place, count, tokenConsumer, newColors, index + 1, productColorResolver);
            }
        } else if (component instanceof UserOperatorExpression) {
            Vector<Color> newColors = new Vector<Color>(currentColors);
            newColors.add(((UserOperatorExpression)component).getUserOperator());
            VerifyTAPNMarkingParser.expandTupleWithAllExpression(components, place, count, tokenConsumer, newColors, index + 1, productColorResolver);
        }
    }

    @FunctionalInterface
    private static interface TokenConsumer {
        public void accept(TimedPlace var1, TimedToken var2);
    }
}

