/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import com.sun.jna.Platform;
import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.TapnEngineXmlLoader;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.util.UnsupportedQueryException;
import dk.aau.cs.verification.EngineHelperFunctions;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.ProcessRunner;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.Stats;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.ExportedVerifyTAPNModel;
import dk.aau.cs.verification.VerifyTAPN.VerifyTACPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOutputParser;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNTraceParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import net.tapaal.Preferences;
import net.tapaal.TAPAAL;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.UnfoldNet;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class VerifyTAPN
implements ModelChecker {
    private static final String NEED_TO_LOCATE_VERIFYTAPN_MSG = "TAPAAL needs to know the location of the file verifytapn.\n\nVerifytapn is a part of the TAPAAL distribution and it is\nnormally located in the directory lib.";
    private static final String VERIFYTAPN_VERSION_PATTERN = "^VerifyTAPN (\\d+\\.\\d+\\.\\d+)$";
    private static String verifytapnpath = "";
    protected final FileFinder fileFinder;
    protected final Messenger messenger;
    protected ProcessRunner runner;

    public VerifyTAPN(FileFinder fileFinder, Messenger messenger) {
        this.fileFinder = fileFinder;
        this.messenger = messenger;
    }

    @Override
    public boolean supportsStats() {
        return true;
    }

    @Override
    public String[] getStatsExplanations() {
        String[] explanations = new String[]{"The number of found markings (each time a successor is calculated, this number is incremented)", "The number of markings taken out of the waiting list during the search.", "The number of markings found in the passed/waiting list at the end of verification."};
        return explanations;
    }

    @Override
    public String getPath() {
        return verifytapnpath;
    }

    @Override
    public String getVersion() {
        return EngineHelperFunctions.getVersion(new String[]{verifytapnpath, "-v"}, VERIFYTAPN_VERSION_PATTERN);
    }

    public String getVersion(String path) {
        return EngineHelperFunctions.getVersion(new String[]{path, "-v"}, VERIFYTAPN_VERSION_PATTERN);
    }

    @Override
    public boolean isCorrectVersion() {
        return this.isCorrectVersion(this.getPath());
    }

    public boolean isCorrectVersion(String path) {
        if (path == null || path.isBlank() || !new File(path).exists()) {
            return false;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            this.messenger.displayErrorMessage("The engine verifytapn is not executable.\nThe verifytapn path will be reset. Please try again, to manually set the verifytapn path.", "Verifytapn Error");
            return false;
        }
        String version = this.getVersion(path);
        if (version != null) {
            return EngineHelperFunctions.versionIsEqualOrGreater(version, "1.3.3");
        }
        return false;
    }

    private void resetVerifytapn() {
        verifytapnpath = null;
        Preferences.getInstance().setVerifytapnLocation(null);
    }

    @Override
    public void kill() {
        if (this.runner != null) {
            this.runner.kill();
        }
    }

    @Override
    public void setPath(String path) throws IllegalArgumentException {
        if (this.isCorrectVersion(path)) {
            verifytapnpath = path;
            Preferences.getInstance().setVerifytapnLocation(path);
        } else {
            this.messenger.displayErrorMessage("The specified version of the file verifytapn is too old.", "Verifytapn Error");
        }
    }

    @Override
    public boolean setup() {
        if (this.isNotSetup()) {
            this.messenger.displayInfoMessage(NEED_TO_LOCATE_VERIFYTAPN_MSG, "Locate verifytapn");
            try {
                File file = this.fileFinder.ShowFileBrowserDialog("Verifytapn", "", System.getProperty("user.home"));
                if (file != null) {
                    if (file.getName().matches("^verifytapn.*(?:\\.exe)?$")) {
                        this.setPath(file.getAbsolutePath());
                    } else {
                        this.messenger.displayErrorMessage("The selected executable does not seem to be verifytapn.");
                    }
                }
            }
            catch (Exception e) {
                this.messenger.displayErrorMessage("There were errors performing the requested action:\n" + e.getMessage(), "Error");
            }
        }
        return !this.isNotSetup();
    }

    private boolean isNotSetup() {
        return verifytapnpath == null || verifytapnpath.equals("") || !new File(verifytapnpath).exists();
    }

    public static boolean trySetup() {
        String[] paths;
        VerifyTAPN v;
        String verifytapn = System.getenv("verifytapn");
        if (verifytapn != null && !verifytapn.isEmpty() && new File(verifytapn).exists()) {
            verifytapnpath = verifytapn;
            v = new VerifyTAPN(new FileFinder(), new MessengerImpl());
            if (v.isCorrectVersion()) {
                return true;
            }
            verifytapn = null;
            verifytapnpath = null;
        }
        if ((verifytapn = Preferences.getInstance().getVerifytapnLocation()) != null && !verifytapn.isEmpty()) {
            verifytapnpath = verifytapn;
            v = new VerifyTAPN(new FileFinder(), new MessengerImpl());
            if (v.isCorrectVersion()) {
                return true;
            }
            verifytapn = null;
            verifytapnpath = null;
        }
        File installdir = TAPAAL.getInstallDir();
        for (String s : paths = new String[]{"/bin/verifytapn", "/bin/verifytapn64", "/bin/verifytapn.exe", "/bin/verifytapn64.exe"}) {
            File verifytapnfile = new File(String.valueOf(installdir) + s);
            if (!verifytapnfile.exists()) continue;
            verifytapnpath = verifytapnfile.getAbsolutePath();
            VerifyTAPN v2 = new VerifyTAPN(new FileFinder(), new MessengerImpl());
            if (v2.isCorrectVersion()) {
                return true;
            }
            verifytapn = null;
            verifytapnpath = null;
        }
        return false;
    }

    @Override
    public VerificationResult<TimedArcPetriNetTrace> verify(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, DataLayer guiModel, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        ExportedVerifyTAPNModel exportedModel;
        if (!this.supportsModel(model.value1(), options)) {
            throw new UnsupportedModelException("Verifytapn does not support the given model.");
        }
        if (!this.supportsQuery(model.value1(), query, options)) {
            throw new UnsupportedQueryException("Verifytapn does not support the given query.");
        }
        if (options instanceof VerifyTAPNOptions && ((VerifyTAPNOptions)options).discreteInclusion()) {
            this.mapDiscreteInclusionPlacesToNewNames(options, model);
        }
        TimedArcPetriNet net = model.value1();
        if (lens != null && lens.isColored() || net.parentNetwork() != null && net.parentNetwork().isColored()) {
            VerifyTACPNExporter exporter = new VerifyTACPNExporter();
            exportedModel = exporter.export(net, query, lens, model.value2(), guiModel, dataLayerQuery);
        } else {
            VerifyTAPNExporter exporter = new VerifyTAPNExporter();
            exportedModel = exporter.export(net, query, lens, model.value2(), guiModel, dataLayerQuery);
        }
        if (exportedModel == null) {
            this.messenger.displayErrorMessage("There was an error exporting the model");
            return null;
        }
        return this.verify(options, model, exportedModel, query, dataLayerQuery, lens);
    }

    @Override
    public VerificationResult<TimedArcPetriNetTrace> verifyManually(String options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        TimedArcPetriNet net = model.value1();
        VerifyTAPNExporter exporter = lens != null && lens.isColored() || net.parentNetwork() != null && net.parentNetwork().isColored() ? new VerifyTACPNExporter() : new VerifyTAPNExporter();
        ExportedVerifyTAPNModel exportedModel = exporter.export(model.value1(), query, lens, model.value2(), null, dataLayerQuery);
        if (exportedModel == null) {
            this.messenger.displayErrorMessage("There was an error exporting the model");
        }
        return this.verifyManually(options, model, exportedModel, query);
    }

    private VerificationResult<TimedArcPetriNetTrace> verifyManually(String options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query) {
        if (exportedModel == null) {
            return null;
        }
        this.runner = new ProcessRunner(verifytapnpath, this.createArgumentString(exportedModel.modelFile(), exportedModel.queryFile(), options));
        this.runner.run();
        if (this.runner.error()) {
            return null;
        }
        String errorOutput = this.readOutput(this.runner.errorOutput());
        String standardOutput = this.readOutput(this.runner.standardOutput());
        Tuple<QueryResult, Stats> queryResult = this.parseQueryResult(standardOutput, model.value1().marking().size() + query.getExtraTokens(), query.getExtraTokens(), query);
        if (queryResult == null || queryResult.value1() == null) {
            return new VerificationResult<TimedArcPetriNetTrace>(errorOutput + System.getProperty("line.separator") + standardOutput, this.runner.getRunningTime());
        }
        return new VerificationResult<Object>(queryResult.value1(), null, null, this.runner.getRunningTime(), queryResult.value2(), false, standardOutput + "\n\n" + errorOutput, model, null);
    }

    protected void mapDiscreteInclusionPlacesToNewNames(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model) {
        if (options instanceof VerifyTAPNOptions) {
            VerifyTAPNOptions verificationOptions = (VerifyTAPNOptions)options;
            if (verificationOptions.inclusionPlaces().inclusionOption() == InclusionPlaces.InclusionPlacesOption.AllPlaces) {
                return;
            }
            ArrayList<TimedPlace> inclusionPlaces = new ArrayList<TimedPlace>();
            for (TimedPlace p : verificationOptions.inclusionPlaces().inclusionPlaces()) {
                if (p instanceof LocalTimedPlace) {
                    LocalTimedPlace local = (LocalTimedPlace)p;
                    if (!local.model().isActive()) continue;
                    inclusionPlaces.add(model.value1().getPlaceByName(model.value2().map(local.model().name(), local.name())));
                    continue;
                }
                inclusionPlaces.add(model.value1().getPlaceByName(model.value2().map("", p.name())));
            }
            ((VerifyTAPNOptions)options).setInclusionPlaces(new InclusionPlaces(InclusionPlaces.InclusionPlacesOption.UserSpecified, inclusionPlaces));
        }
    }

    protected VerificationResult<TimedArcPetriNetTrace> verify(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) {
        boolean showTrace;
        TimedArcPetriNet net;
        if (options instanceof VerifyTAPNOptions) {
            ((VerifyTAPNOptions)options).setTokensInModel(model.value1().getNumberOfTokensInNet());
        }
        this.runner = new ProcessRunner(verifytapnpath, this.createArgumentString(exportedModel.modelFile(), exportedModel.queryFile(), options));
        this.runner.run();
        if (this.runner.error()) {
            return null;
        }
        PetriNetTab newTab = null;
        String errorOutput = this.readOutput(this.runner.errorOutput());
        String standardOutput = this.readOutput(this.runner.standardOutput());
        Tuple<QueryResult, Stats> queryResult = this.parseQueryResult(standardOutput, (net = model.value1()).marking().size() + query.getExtraTokens(), query.getExtraTokens(), query);
        if (queryResult == null || queryResult.value1() == null) {
            return new VerificationResult<TimedArcPetriNetTrace>(errorOutput + System.getProperty("line.separator") + standardOutput, this.runner.getRunningTime());
        }
        TimedArcPetriNetTrace tapnTrace = null;
        boolean isColored = lens != null && lens.isColored() || net.parentNetwork() != null && net.parentNetwork().isColored();
        boolean bl = showTrace = query.getProperty() instanceof TCTLEFNode && queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLAGNode && !queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLEGNode && queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLAFNode && !queryResult.value1().isQuerySatisfied();
        if (options.traceOption() != TAPNQuery.TraceOption.NONE && isColored && showTrace) {
            TapnEngineXmlLoader tapnLoader = new TapnEngineXmlLoader();
            File fileOut = new File(options.unfoldedModelPath());
            File queriesOut = new File(options.unfoldedQueriesPath());
            try {
                LoadedModel loadedModel = tapnLoader.load(fileOut);
                TAPNComposer newComposer = new TAPNComposer(new MessengerImpl(), true);
                model = newComposer.transformModel(loadedModel.network());
                if (queryResult != null && queryResult.value1() != null) {
                    tapnTrace = this.parseTrace(!errorOutput.contains("Trace:") ? errorOutput : errorOutput.split("Trace:")[1], options, model, exportedModel, query, queryResult.value1());
                }
                if (tapnTrace != null) {
                    newTab = new PetriNetTab(loadedModel.network(), loadedModel.templates(), loadedModel.queries(), new TAPNLens(lens.isTimed(), lens.isGame(), false, lens.isStochastic()));
                    for (net.tapaal.gui.petrinet.verification.TAPNQuery loadedQuery : UnfoldNet.getQueries(queriesOut, loadedModel.network(), query.getCategory())) {
                        newTab.setInitialName(loadedQuery.getName() + " - unfolded");
                        loadedQuery.copyOptions(dataLayerQuery);
                        newTab.addQuery(loadedQuery);
                    }
                }
            }
            catch (Exception | ThreadDeath e) {
                e.printStackTrace();
                return null;
            }
        }
        if (tapnTrace == null) {
            tapnTrace = this.parseTrace(!errorOutput.contains("Trace:") ? errorOutput : errorOutput.split("Trace:")[1], options, model, exportedModel, query, queryResult.value1());
        }
        return new VerificationResult<Object>(queryResult.value1(), tapnTrace, null, this.runner.getRunningTime(), queryResult.value2(), false, standardOutput + "\n\n" + errorOutput, model, newTab);
    }

    private TimedArcPetriNetTrace parseTrace(String output, VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, QueryResult queryResult) {
        if (options instanceof VerifyTAPNOptions && ((VerifyTAPNOptions)options).trace() == TAPNQuery.TraceOption.NONE) {
            return null;
        }
        VerifyTAPNTraceParser traceParser = new VerifyTAPNTraceParser(model.value1());
        TimedArcPetriNetTrace trace = traceParser.parseTrace(new BufferedReader(new StringReader(output)));
        if (trace == null && options instanceof VerifyTAPNOptions && ((VerifyTAPNOptions)options).trace() != TAPNQuery.TraceOption.NONE && (query.getProperty() instanceof TCTLEFNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAGNode && queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLEGNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAFNode && queryResult.isQuerySatisfied())) {
            return null;
        }
        return trace;
    }

    private String createArgumentString(String modelFile, String queryFile, VerificationOptions options) {
        return this.createArgumentString(modelFile, queryFile, options.toString());
    }

    private String createArgumentString(String modelFile, String queryFile, String options) {
        if (Platform.isWindows()) {
            return options + " \"" + modelFile + "\" \"" + queryFile + "\"";
        }
        return options + " " + modelFile + " " + queryFile;
    }

    private String readOutput(BufferedReader reader) {
        try {
            if (!reader.ready()) {
                return "";
            }
        }
        catch (IOException e1) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    private Tuple<QueryResult, Stats> parseQueryResult(String output, int totalTokens, int extraTokens, TAPNQuery query) {
        VerifyTAPNOutputParser outputParser = new VerifyTAPNOutputParser(totalTokens, extraTokens, query);
        return outputParser.parseOutput(output);
    }

    @Override
    public boolean supportsModel(TimedArcPetriNet model, VerificationOptions options) {
        return !model.hasWeights() && !model.hasUrgentTransitions();
    }

    @Override
    public boolean supportsQuery(TimedArcPetriNet model, TAPNQuery query, VerificationOptions options) {
        return !(query.getProperty() instanceof TCTLEGNode) && !(query.getProperty() instanceof TCTLAFNode) && !query.hasDeadlock();
    }

    public static void reset() {
        verifytapnpath = "";
        Preferences.getInstance().setVerifytapnLocation(null);
        VerifyTAPN.trySetup();
    }

    public String getHelpOptions() {
        this.runner = new ProcessRunner(verifytapnpath, "--help", this);
        this.runner.run();
        if (!this.runner.error()) {
            return this.readOutput(this.runner.standardOutput());
        }
        return null;
    }

    public String toString() {
        return "verifytapn";
    }

    @Override
    public boolean useDiscreteSemantics() {
        return false;
    }
}

