/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.BoundednessAnalysisResult;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.ReductionStats;
import dk.aau.cs.verification.Stats;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOutputParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerifyPNOutputParser
extends VerifyTAPNOutputParser {
    private static final String Query_IS_NOT_SATISFIED_STRING = "Query is NOT satisfied";
    private static final String Query_IS_SATISFIED_STRING = "Query is satisfied";
    private static final String Query_IS_MAYBE_SATISFIED_STRING = "Query is MAYBE satisfied";
    private static final Pattern discoveredPattern = Pattern.compile("\\s*discovered states:\\s*(\\d+)\\s*");
    private static final Pattern exploredPattern = Pattern.compile("\\s*explored states:\\s*(\\d+)\\s*");
    private static final Pattern maxUsedTokensPattern = Pattern.compile("\\s*max tokens:\\s*(\\d+)\\s*");
    private static final Pattern transitionStatsPattern = Pattern.compile("<([^:\\s]+):(\\d+)>");
    private static final Pattern transitionStatsPatternUnknown = Pattern.compile("<([^:\\s]+):\\?>");
    private static final Pattern placeBoundPattern = Pattern.compile("<([^;\\s]+);(\\d+)>");
    private static final Pattern placeBoundPatternUnknown = Pattern.compile("<([^;\\s]+);\\?>");
    private static final Pattern reductionsUsedPattern = Pattern.compile("\\s*Net reduction is enabled.\\s*");
    private static final Pattern removedTransitionsPattern = Pattern.compile("\\s*Removed transitions:\\s*(\\d+)\\s*");
    private static final Pattern removedPlacesPattern = Pattern.compile("\\s*Removed places:\\s*(\\d+)\\s*");

    public VerifyPNOutputParser(int totalTokens, int extraTokens, TAPNQuery queryType) {
        super(totalTokens, extraTokens, queryType);
    }

    @Override
    public Tuple<QueryResult, Stats> parseOutput(String output) {
        int discovered = 0;
        int explored = 0;
        int maxUsedTokens = 0;
        int removedTransitions = 0;
        int removedPlaces = 0;
        boolean reductionUsed = false;
        boolean result = false;
        boolean foundResult = false;
        boolean isInconclusive = false;
        String[] lines = output.split(System.getProperty("line.separator"));
        try {
            Matcher matcher = transitionStatsPattern.matcher(output);
            while (matcher.find()) {
                this.transitionStats.add(new Tuple<String, Integer>(matcher.group(1), Integer.parseInt(matcher.group(2))));
            }
            matcher = transitionStatsPatternUnknown.matcher(output);
            while (matcher.find()) {
                this.transitionStats.add(new Tuple<String, Integer>(matcher.group(1), -1));
            }
            matcher = placeBoundPattern.matcher(output);
            while (matcher.find()) {
                this.placeBoundStats.add(new Tuple<String, Integer>(matcher.group(1), Integer.parseInt(matcher.group(2))));
            }
            matcher = placeBoundPatternUnknown.matcher(output);
            while (matcher.find()) {
                this.placeBoundStats.add(new Tuple<String, Integer>(matcher.group(1), -1));
            }
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.contains(Query_IS_SATISFIED_STRING)) {
                    result = true;
                    foundResult = true;
                    isInconclusive = false;
                    continue;
                }
                if (line.contains(Query_IS_MAYBE_SATISFIED_STRING)) {
                    result = true;
                    foundResult = true;
                    isInconclusive = true;
                    continue;
                }
                if (line.contains(Query_IS_NOT_SATISFIED_STRING)) {
                    result = false;
                    foundResult = true;
                    isInconclusive = false;
                    continue;
                }
                this.parseSolvedMethod(line);
                matcher = discoveredPattern.matcher(line);
                if (matcher.find()) {
                    discovered = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = exploredPattern.matcher(line)).find()) {
                    explored = Integer.parseInt(matcher.group(1));
                }
                if ((matcher = maxUsedTokensPattern.matcher(line)).find()) {
                    String operator;
                    maxUsedTokens = Integer.parseInt(matcher.group(1));
                    String string = operator = matcher.group(1) == null ? "" : matcher.group(1);
                    if (operator.equals(">")) {
                        ++maxUsedTokens;
                    }
                }
                if ((matcher = reductionsUsedPattern.matcher(line)).find()) {
                    reductionUsed = true;
                }
                if ((matcher = removedTransitionsPattern.matcher(line)).find()) {
                    removedTransitions = Integer.parseInt(matcher.group(1));
                }
                if (!(matcher = removedPlacesPattern.matcher(line)).find()) continue;
                removedPlaces = Integer.parseInt(matcher.group(1));
            }
            if (!foundResult) {
                return null;
            }
            BoundednessAnalysisResult boundedAnalysis = new BoundednessAnalysisResult(this.totalTokens, maxUsedTokens, this.extraTokens);
            ReductionStats reductionStats = reductionUsed ? new ReductionStats(removedTransitions, removedPlaces) : null;
            QueryResult qr = new QueryResult(result, boundedAnalysis, this.query, false);
            qr.setApproximationInconclusive(isInconclusive);
            qr.setSolvedUsingQuerySimplification(this.solvedUsingQuerySimplification);
            qr.setSolvedUsingTraceAbstractRefinement(this.solvedUsingTraceAbstractRefinement);
            qr.setSolvedUsingSiphonTrap(this.solvedUsingSiphonTrap);
            return new Tuple<QueryResult, Stats>(qr, new Stats((long)discovered, (long)explored, (long)explored, this.transitionStats, this.placeBoundStats, reductionStats));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

