/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import com.sun.jna.Platform;
import dk.aau.cs.verification.VerifyTAPN.ModelReduction;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.MessengerImpl;

public class VerifyPNOptions
extends VerifyTAPNOptions {
    private static final Map<TAPNQuery.TraceOption, String> traceMap = Map.of(TAPNQuery.TraceOption.SOME, " --trace ", TAPNQuery.TraceOption.NONE, "");
    private static final Map<TAPNQuery.SearchOption, String> searchMap = Map.of(TAPNQuery.SearchOption.HEURISTIC, " --search-strategy BestFS", TAPNQuery.SearchOption.RANDOMHEURISTIC, " --search-strategy RPFS", TAPNQuery.SearchOption.BFS, "--search-strategy BFS", TAPNQuery.SearchOption.DFS, " --search-strategy DFS", TAPNQuery.SearchOption.RANDOM, " --search-strategy RDFS", TAPNQuery.SearchOption.OVERAPPROXIMATE, " --search-strategy OverApprox");
    private final ModelReduction modelReduction;
    private final TAPNQuery.QueryCategory queryCategory;
    private final TAPNQuery.AlgorithmOption algorithmOption;
    private final boolean useSiphontrap;
    private final TAPNQuery.QueryReductionTime queryReductionTime;
    private final boolean useStubbornReduction;
    private final boolean unfold;
    private final boolean colored;
    private final boolean useTarOption;
    private final boolean partition;
    private final boolean colorFixpoint;
    private final boolean symmetricVars;
    private final boolean useTarjan;
    private final boolean useColoredReduction;
    private boolean useRawVerification;
    private String rawVerificationOptions;

    public VerifyPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean useOverApproximation, ModelReduction modelReduction, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, TAPNQuery.QueryCategory queryCategory, TAPNQuery.AlgorithmOption algorithmOption, boolean siphontrap, TAPNQuery.QueryReductionTime queryReduction, boolean stubbornReduction, String pathToReducedNet, boolean useTarOption, boolean useTarjan, boolean colored, boolean unfold, boolean partition, boolean colorFixpoint, boolean useSymmetricVars, boolean useColoredReduction, boolean useExplicitSearch, boolean useRawVerification, String rawVerificationOptions) {
        super(extraTokens, traceOption, search, true, useOverApproximation, false, new InclusionPlaces(), enableOverApproximation, enableUnderApproximation, approximationDenominator, useTarOption);
        this.modelReduction = modelReduction;
        this.queryCategory = queryCategory;
        this.algorithmOption = algorithmOption;
        this.useSiphontrap = siphontrap;
        this.queryReductionTime = queryReduction;
        this.useStubbornReduction = stubbornReduction;
        this.unfold = unfold;
        this.colored = colored;
        this.partition = partition;
        this.colorFixpoint = colorFixpoint;
        this.useTarOption = useTarOption;
        this.useTarjan = useTarjan;
        this.reducedModelPath = pathToReducedNet;
        this.symmetricVars = useSymmetricVars;
        this.useColoredReduction = useColoredReduction;
        this.useExplicitSearch = useExplicitSearch;
        this.useRawVerification = useRawVerification;
        this.rawVerificationOptions = rawVerificationOptions;
        if (useExplicitSearch) {
            unfoldedModelPath = null;
            unfoldedQueriesPath = null;
        } else if (unfold && !useRawVerification) {
            try {
                if (Platform.isWindows()) {
                    unfoldedModelPath = "\"" + File.createTempFile("unfolded-", ".pnml").getAbsolutePath() + "\"";
                    unfoldedQueriesPath = "\"" + File.createTempFile("unfoldedQueries-", ".xml").getAbsolutePath() + "\"";
                } else {
                    unfoldedModelPath = File.createTempFile("unfolded-", ".pnml").getAbsolutePath();
                    unfoldedQueriesPath = File.createTempFile("unfoldedQueries-", ".xml").getAbsolutePath();
                }
            }
            catch (IOException e) {
                new MessengerImpl().displayErrorMessage(e.getMessage(), "Error");
            }
        }
    }

    public VerifyPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean useOverApproximation, ModelReduction modelReduction, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, TAPNQuery.QueryCategory queryCategory, TAPNQuery.AlgorithmOption algorithmOption, boolean siphontrap, TAPNQuery.QueryReductionTime queryReduction, boolean stubbornReduction, String pathToReducedNet, boolean useTarOption, boolean useTarjan, boolean colored, boolean unfold, boolean partition, boolean colorFixpoint, boolean useSymmetricVars, boolean useExplicitSearch) {
        this(extraTokens, traceOption, search, useOverApproximation, modelReduction, enableOverApproximation, enableUnderApproximation, approximationDenominator, queryCategory, algorithmOption, siphontrap, queryReduction, stubbornReduction, pathToReducedNet, useTarOption, useTarjan, colored, false, partition, colorFixpoint, useSymmetricVars, false, useExplicitSearch, false, null);
    }

    public VerifyPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean useOverApproximation, ModelReduction modelReduction, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, TAPNQuery.QueryCategory queryCategory, TAPNQuery.AlgorithmOption algorithmOption, boolean siphontrap, TAPNQuery.QueryReductionTime queryReduction, boolean stubbornReduction, String pathToReducedNet, boolean useTarOption, boolean useTarjan, boolean colored, boolean unfold, boolean partition, boolean colorFixpoint, boolean useSymmetricVars, boolean useRawVerification, String rawVerificationOptions) {
        this(extraTokens, traceOption, search, useOverApproximation, modelReduction, enableOverApproximation, enableUnderApproximation, approximationDenominator, queryCategory, algorithmOption, siphontrap, queryReduction, stubbornReduction, pathToReducedNet, useTarOption, useTarjan, colored, false, partition, colorFixpoint, useSymmetricVars, false, false, useRawVerification, rawVerificationOptions);
    }

    public VerifyPNOptions(int extraTokens, TAPNQuery.TraceOption traceOption, TAPNQuery.SearchOption search, boolean useOverApproximation, ModelReduction modelReduction, boolean enableOverApproximation, boolean enableUnderApproximation, int approximationDenominator, TAPNQuery.QueryCategory queryCategory, TAPNQuery.AlgorithmOption algorithmOption, boolean siphontrap, TAPNQuery.QueryReductionTime queryReduction, boolean stubbornReduction, String pathToReducedNet, boolean useTarOption, boolean useTarjan, boolean colored, boolean partition, boolean colorFixpoint, boolean useSymmetricVars, boolean useExplicitSearch) {
        this(extraTokens, traceOption, search, useOverApproximation, modelReduction, enableOverApproximation, enableUnderApproximation, approximationDenominator, queryCategory, algorithmOption, siphontrap, queryReduction, stubbornReduction, pathToReducedNet, useTarOption, useTarjan, colored, false, partition, colorFixpoint, useSymmetricVars, useExplicitSearch);
    }

    @Override
    public String toString() {
        String searchSwitch;
        StringBuilder result = new StringBuilder();
        if (this.useRawVerification && this.rawVerificationOptions != null) {
            return this.rawVerificationString(this.rawVerificationOptions, traceMap.get((Object)this.traceOption));
        }
        result.append(this.kBoundArg());
        String traceSwitch = traceMap.get((Object)this.traceOption);
        if (traceSwitch != null) {
            result.append(traceSwitch + " ");
        }
        if ((searchSwitch = searchMap.get((Object)this.searchOption)) != null) {
            result.append(searchSwitch + " ");
        }
        switch (this.getModelReduction()) {
            case AGGRESSIVE: {
                result.append(" --reduction 1 ");
                if (this.reducedModelPath == null || this.reducedModelPath.isEmpty()) break;
                result.append(" --write-reduced " + this.reducedModelPath);
                break;
            }
            case NO_REDUCTION: {
                result.append(" --reduction 0 ");
                break;
            }
            case BOUNDPRESERVING: {
                result.append(" --reduction 2 ");
                if (this.reducedModelPath == null || this.reducedModelPath.isEmpty()) break;
                result.append(" --write-reduced " + this.reducedModelPath);
                break;
            }
        }
        if (this.unfold) {
            result.append(" --write-unfolded-net ");
            result.append(unfoldedModelPath);
            result.append(" --write-unfolded-queries ");
            result.append(unfoldedQueriesPath);
            result.append(" --bindings ");
        }
        if (this.queryCategory == TAPNQuery.QueryCategory.CTL) {
            result.append(" --ctl-algorithm " + (this.getAlgorithmOption() == TAPNQuery.AlgorithmOption.CERTAIN_ZERO ? "czero" : "local"));
            result.append(" --xml-queries 1");
        } else if (this.queryCategory == TAPNQuery.QueryCategory.LTL || this.queryCategory == TAPNQuery.QueryCategory.HyperLTL) {
            result.append(" --ltl-algorithm");
            if (!this.useTarjan) {
                result.append(" ndfs");
            }
            result.append(" --xml-queries 1");
        }
        if (this.useSiphontrap) {
            result.append(" --siphon-trap 10 ");
        }
        if (this.queryReductionTime == TAPNQuery.QueryReductionTime.NoTime) {
            result.append(" --query-reduction 0 ");
        } else if (this.queryReductionTime == TAPNQuery.QueryReductionTime.ShortestTime) {
            result.append(" --query-reduction 1 ");
        }
        if (!this.useStubbornReduction) {
            result.append(" --disable-partial-order ");
        }
        if (this.useTarOption) {
            result.append(" --trace-abstraction ");
        }
        if (this.colored) {
            if (!this.partition) {
                result.append(" --disable-partitioning ");
            }
            if (!this.colorFixpoint) {
                result.append(" --disable-cfp ");
            }
            if (!this.symmetricVars) {
                result.append(" --disable-symmetry-vars ");
            }
            if (this.useExplicitSearch) {
                result.append(" -C ");
            }
        }
        if (!this.useColoredReduction && this.colored && !this.useExplicitSearch) {
            result.append(" --col-reduction 0 ");
        }
        return result.toString();
    }

    public ModelReduction getModelReduction() {
        return this.modelReduction;
    }

    public TAPNQuery.AlgorithmOption getAlgorithmOption() {
        return this.algorithmOption;
    }

    @Override
    public boolean useExplicitSearch() {
        return this.useExplicitSearch;
    }
}

