/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import com.sun.jna.Platform;
import dk.aau.cs.debug.Logger;
import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.VerifyTAPN.VerifyPN;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNMarkingParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.tapaal.gui.petrinet.verification.Verifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class VerifyPNInteractiveHandle {
    private Process verifypnProcess;
    private BufferedWriter writer;
    private BufferedReader reader;
    private BufferedReader errorReader;
    private TimedArcPetriNetNetwork network;
    private TAPNComposer composer;
    private NameMapping nameMapping;
    private boolean isShutdownHookRegistered;

    public VerifyPNInteractiveHandle(TimedArcPetriNetNetwork network, TAPNComposer composer, NameMapping nameMapping) {
        this.network = network;
        this.composer = composer;
        this.nameMapping = nameMapping;
    }

    public boolean startInteractiveMode(String modelPath) {
        try {
            VerifyPN verifyPn = Verifier.getVerifyPN();
            if (Platform.isWindows()) {
                modelPath = "\"" + (String)modelPath + "\"";
            }
            verifyPn.setup();
            List<String> initCommand = List.of(verifyPn.getPath(), modelPath, "-C", "--interactive-mode");
            ProcessBuilder pb = new ProcessBuilder(initCommand);
            this.verifypnProcess = pb.start();
            if (this.shouldLog()) {
                Logger.log("Running: " + String.join((CharSequence)" ", initCommand));
            }
            Thread.sleep(100L);
            if (!this.verifypnProcess.isAlive()) {
                return false;
            }
            this.writer = new BufferedWriter(new OutputStreamWriter(this.verifypnProcess.getOutputStream()));
            this.reader = new BufferedReader(new InputStreamReader(this.verifypnProcess.getInputStream()));
            this.errorReader = new BufferedReader(new InputStreamReader(this.verifypnProcess.getErrorStream()));
            this.registerShutdownHook();
            return true;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean shouldLog() {
        return Boolean.getBoolean("debug.interactive");
    }

    public Map<TimedTransition, List<Map<Variable, Color>>> sendMarking(NetworkMarking marking) {
        try {
            if (this.shouldLog()) {
                Logger.log("--- Sending marking to VerifyPN ---");
                Logger.log(marking.toXmlStr(this.composer));
                Logger.log("-----------------------------------");
            }
            String xmlResponse = this.sendMessage(marking.toXmlStr(this.composer), "valid-bindings");
            if (this.shouldLog()) {
                Logger.log("--- Received response from VerifyPN ---");
                Logger.log(xmlResponse);
                Logger.log("---------------------------------------");
            }
            return this.parseTransitionWithBindings(xmlResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public NetworkMarking sendTransition(TimedTransition transition, Map<Variable, Color> bindings) {
        try {
            if (this.shouldLog()) {
                Logger.log("--- Sending transition to VerifyPN ---");
                Logger.log(transition.toBindingXmlStr(bindings, this.composer));
                Logger.log("--------------------------------------");
            }
            String xmlResponse = this.sendMessage(transition.toBindingXmlStr(bindings, this.composer), "marking");
            if (this.shouldLog()) {
                Logger.log("--- Received response from VerifyPN ---");
                Logger.log(xmlResponse);
                Logger.log("---------------------------------------");
            }
            return this.parseMarking(xmlResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String sendMessage(String message, String responseTag) throws Exception {
        String line;
        while (this.reader.ready()) {
            this.reader.readLine();
        }
        this.writer.write(message);
        int numNewlines = 3;
        for (int i = 0; i < 3; ++i) {
            this.writer.newLine();
        }
        this.writer.flush();
        StringBuilder response = new StringBuilder();
        boolean insideTag = false;
        boolean foundEndTag = false;
        while ((line = this.reader.readLine()) != null) {
            String trimmedLine = line.trim();
            if (trimmedLine.equals("<" + responseTag + ">")) {
                insideTag = true;
                response.append(line).append("\n");
                continue;
            }
            if (trimmedLine.equals("</" + responseTag + ">")) {
                response.append(line).append("\n");
                foundEndTag = true;
                break;
            }
            if (!insideTag) continue;
            response.append(line).append("\n");
        }
        if (!foundEndTag) {
            throw new IOException("Did not receive complete response from engine. Response so far: " + response.toString());
        }
        return response.toString().trim();
    }

    private NetworkMarking parseMarking(String xmlResponse) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xmlResponse)));
        Element markingElement = (Element)document.getElementsByTagName("marking").item(0);
        return VerifyTAPNMarkingParser.parseComposedMarking(this.network, markingElement, this.nameMapping);
    }

    private Map<TimedTransition, List<Map<Variable, Color>>> parseTransitionWithBindings(String xmlResponse) throws Exception {
        HashMap<TimedTransition, List<Map<Variable, Color>>> transitionBindings = new HashMap<TimedTransition, List<Map<Variable, Color>>>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(xmlResponse)));
        NodeList transitionNodes = document.getElementsByTagName("transition");
        for (int i = 0; i < transitionNodes.getLength(); ++i) {
            Element transitionElement = (Element)transitionNodes.item(i);
            String transitionId = transitionElement.getAttribute("id");
            Tuple<String, String> originalName = this.nameMapping.map(transitionId);
            TimedTransition transition = !originalName.value1().isEmpty() ? this.network.getTAPNByName(originalName.value1()).getTransitionByName(originalName.value2()) : this.network.getSharedTransitionByName(originalName.value2()).transitions().iterator().next();
            if (transition == null) {
                throw new IllegalArgumentException("Transition with ID " + transitionId + " not found in composer.");
            }
            ArrayList validBindings = new ArrayList();
            NodeList bindingNodes = transitionElement.getElementsByTagName("binding");
            for (int j = 0; j < bindingNodes.getLength(); ++j) {
                Element bindingElement = (Element)bindingNodes.item(j);
                HashMap<Variable, Color> singleBinding = new HashMap<Variable, Color>();
                NodeList variableNodes = bindingElement.getElementsByTagName("variable");
                for (int k = 0; k < variableNodes.getLength(); ++k) {
                    Element variableElement = (Element)variableNodes.item(k);
                    String variableId = variableElement.getAttribute("id");
                    Element colorElement = (Element)variableElement.getElementsByTagName("color").item(0);
                    String colorName = colorElement.getTextContent();
                    Variable variable = this.network.getVariableById(variableId);
                    Color color = this.network.getColorByName(colorName);
                    if (variable == null) {
                        throw new IllegalArgumentException("Variable with ID " + variableId + " not found in network.");
                    }
                    if (color == null) {
                        throw new IllegalArgumentException("Color with name " + colorName + " not found in network.");
                    }
                    singleBinding.put(variable, color);
                }
                if (singleBinding.isEmpty()) continue;
                validBindings.add(singleBinding);
            }
            transitionBindings.put(transition, validBindings);
        }
        return transitionBindings;
    }

    private void registerShutdownHook() {
        if (!this.isShutdownHookRegistered) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.stopInteractiveMode()));
            this.isShutdownHookRegistered = true;
        }
    }

    public void stopInteractiveMode() {
        block8: {
            try {
                if (this.writer != null) {
                    this.writer.close();
                    this.writer = null;
                }
                if (this.reader != null) {
                    this.reader.close();
                    this.reader = null;
                }
                if (this.errorReader != null) {
                    this.errorReader.close();
                    this.errorReader = null;
                }
                if (this.verifypnProcess == null) break block8;
                this.verifypnProcess.destroy();
                try {
                    this.verifypnProcess.waitFor(3L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.verifypnProcess.isAlive()) {
                    this.verifypnProcess.destroyForcibly();
                }
                this.verifypnProcess = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

