/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.BoundednessAnalysisResult;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.Stats;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOutputParser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VerifyPNCTLOutputParser
extends VerifyTAPNOutputParser {
    private static final String Query_IS_NOT_SATISFIED_STRING = "Query is NOT satisfied";
    private static final String Query_IS_SATISFIED_STRING = "Query is satisfied";
    private static final Pattern configurationsPattern = Pattern.compile("\\s*Configurations\\s*:\\s*(\\d+)\\s*");
    private static final Pattern markingsPattern = Pattern.compile("\\s*Markings\\s*:\\s*(\\d+)\\s*");
    private static final Pattern edgesPattern = Pattern.compile("\\t+Edges\\s*:\\s*(\\d+)\\s*");
    private static final Pattern processedEdgesPattern = Pattern.compile("\\s*Processed Edges\\s*:\\s*(\\d+)\\s*");
    private static final Pattern processedNEdgesPattern = Pattern.compile("\\s*Processed N. Edges\\s*:\\s*(\\d+)\\s*");
    private static final Pattern exploredConfigurationsPattern = Pattern.compile("\\s*Explored Configs\\s*:\\s*(\\d+)\\s*");
    private static final Pattern maxUsedTokensPattern = Pattern.compile("\\s*max tokens:\\s*(:)?\\s*(\\d+)\\s*");

    public VerifyPNCTLOutputParser(int totalTokens, int extraTokens, TAPNQuery queryType) {
        super(totalTokens, extraTokens, queryType);
    }

    @Override
    public Tuple<QueryResult, Stats> parseOutput(String output) {
        long configurtations = 0L;
        long markings = 0L;
        long edges = 0L;
        long processedEdges = 0L;
        long processedNEdges = 0L;
        long exploredConfigurations = 0L;
        int maxUsedTokens = 0;
        boolean result = false;
        boolean foundResult = false;
        String[] lines = output.split(System.getProperty("line.separator"));
        try {
            for (int i = 0; i < lines.length; ++i) {
                String operator;
                String line = lines[i];
                if (line.contains(Query_IS_SATISFIED_STRING)) {
                    result = true;
                    foundResult = true;
                    continue;
                }
                if (line.contains(Query_IS_NOT_SATISFIED_STRING)) {
                    result = false;
                    foundResult = true;
                    continue;
                }
                this.parseSolvedMethod(line);
                Matcher matcher = configurationsPattern.matcher(line);
                if (matcher.find()) {
                    configurtations = Long.parseLong(matcher.group(1));
                }
                if ((matcher = markingsPattern.matcher(line)).find()) {
                    markings = Long.parseLong(matcher.group(1));
                }
                if ((matcher = edgesPattern.matcher(line)).find()) {
                    edges = Long.parseLong(matcher.group(1));
                }
                if ((matcher = processedEdgesPattern.matcher(line)).find()) {
                    processedEdges = Long.parseLong(matcher.group(1));
                }
                if ((matcher = processedNEdgesPattern.matcher(line)).find()) {
                    processedNEdges = Long.parseLong(matcher.group(1));
                }
                if ((matcher = exploredConfigurationsPattern.matcher(line)).find()) {
                    exploredConfigurations = Long.parseLong(matcher.group(1));
                }
                if (!(matcher = maxUsedTokensPattern.matcher(line)).find()) continue;
                maxUsedTokens = Integer.parseInt(matcher.group(2));
                String string = operator = matcher.group(2) == null ? "" : matcher.group(2);
                if (!operator.equals(">")) continue;
                ++maxUsedTokens;
            }
            if (!foundResult) {
                return null;
            }
            BoundednessAnalysisResult boundedAnalysis = new BoundednessAnalysisResult(this.totalTokens, maxUsedTokens, this.extraTokens);
            QueryResult qr = new QueryResult(result, boundedAnalysis, this.query, false);
            qr.setSolvedUsingQuerySimplification(this.solvedUsingQuerySimplification);
            qr.setSolvedUsingTraceAbstractRefinement(this.solvedUsingTraceAbstractRefinement);
            qr.setSolvedUsingSiphonTrap(this.solvedUsingSiphonTrap);
            return new Tuple<QueryResult, Stats>(qr, new Stats(configurtations, markings, edges, processedEdges, processedNEdges, exploredConfigurations));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

