/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import com.sun.jna.Platform;
import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.LTLANode;
import dk.aau.cs.TCTL.LTLENode;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.PNMLoader;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.util.FormatException;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.util.UnsupportedQueryException;
import dk.aau.cs.verification.EngineHelperFunctions;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.ProcessRunner;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.Stats;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.ExportedVerifyTAPNModel;
import dk.aau.cs.verification.VerifyTAPN.VerifyCPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNCTLOutputParser;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyPNOutputParser;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOutputParser;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNTraceParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import net.tapaal.Preferences;
import net.tapaal.TAPAAL;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.UnfoldNet;
import org.jetbrains.annotations.Nullable;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class VerifyPN
implements ModelChecker {
    private static final String NEED_TO_LOCATE_verifypn_MSG = "TAPAAL needs to know the location of the file verifypn.\n\nVerifypn is a part of the TAPAAL distribution and it is\nnormally located in the directory lib.";
    public static final String VERIFYPN_EXE_PATTERN = "^verifypn.*(?:\\.exe)?$";
    private static final String VERIFYPN_VERSION_PATTERN = "^VerifyPN.*(\\d+\\.\\d+\\.\\d+).*$";
    protected static String verifypnpath = "";
    private final FileFinder fileFinder;
    private final Messenger messenger;
    private ProcessRunner runner;
    private boolean ctlOutput = false;

    public VerifyPN(FileFinder fileFinder, Messenger messenger) {
        this.fileFinder = fileFinder;
        this.messenger = messenger;
    }

    @Override
    public boolean supportsStats() {
        return true;
    }

    @Override
    public String[] getStatsExplanations() {
        String[] explanations = new String[3];
        if (this.ctlOutput) {
            explanations[0] = "The number of configurations explored during the on-the-fly generation of the dependency graph for the given net and query before a conclusive answer was reached.";
            explanations[1] = "The number of markings explored during the on-the-fly generation of the dependency graph for the given net and query before a conclusive answer was reached.";
            explanations[2] = "The number of hyper-edges explored during the on-the-fly generation of the dependency graph for the given net and query before a conclusive answer was reached.";
        } else {
            explanations[0] = "The number of found markings (each time a successor is calculated, this number is incremented)";
            explanations[1] = "The number of markings taken out of the waiting list during the search.";
            explanations[2] = "The number of markings found in the passed/waiting list at the end of verification.";
        }
        return explanations;
    }

    @Override
    public String getPath() {
        return verifypnpath;
    }

    @Override
    public String getVersion() {
        return EngineHelperFunctions.getVersion(new String[]{verifypnpath, "-v"}, VERIFYPN_VERSION_PATTERN);
    }

    public String getVersion(String path) {
        return EngineHelperFunctions.getVersion(new String[]{path, "-v"}, VERIFYPN_VERSION_PATTERN);
    }

    @Override
    public boolean isCorrectVersion() {
        return this.isCorrectVersion(this.getPath());
    }

    public boolean isCorrectVersion(String path) {
        if (path == null || path.isBlank() || !new File(path).exists()) {
            return false;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            this.messenger.displayErrorMessage("The engine verifypn is not executable.\nThe verifypn path will be reset. Please try again, to manually set the verifypn path.", "VerifyPN Error");
            return false;
        }
        String version = this.getVersion(path);
        if (version != null) {
            return EngineHelperFunctions.versionIsEqualOrGreater(version, "4.4.2");
        }
        return false;
    }

    private void resetVerifypn() {
        verifypnpath = null;
        Preferences.getInstance().setVerifypnLocation(null);
    }

    @Override
    public void kill() {
        if (this.runner != null) {
            this.runner.kill();
        }
    }

    @Override
    public void setPath(String path) throws IllegalArgumentException {
        if (this.isCorrectVersion(path)) {
            verifypnpath = path;
            Preferences.getInstance().setVerifypnLocation(path);
        } else {
            this.messenger.displayErrorMessage("The specified version of the file verifypn is too old, or not recognized as verifypn", "Verifypn Error");
        }
    }

    @Override
    public boolean setup() {
        if (this.isNotSetup()) {
            this.messenger.displayInfoMessage(NEED_TO_LOCATE_verifypn_MSG, "Locate verifypn");
            try {
                File file = this.fileFinder.ShowFileBrowserDialog("Verifypn", "", System.getProperty("user.home"));
                if (file != null) {
                    if (file.getName().matches(VERIFYPN_EXE_PATTERN)) {
                        this.setPath(file.getAbsolutePath());
                    } else {
                        this.messenger.displayErrorMessage("The selected executable does not seem to be verifypn.");
                    }
                }
            }
            catch (Exception e) {
                this.messenger.displayErrorMessage("There were errors performing the requested action:\n" + e.getMessage(), "Error");
            }
        }
        return !this.isNotSetup();
    }

    private boolean isNotSetup() {
        return verifypnpath == null || verifypnpath.equals("") || !new File(verifypnpath).exists();
    }

    public static boolean trySetup() {
        String[] paths;
        VerifyPN v;
        String verifypn = null;
        verifypn = System.getenv("verifypn");
        if (verifypn != null && !verifypn.isEmpty() && new File(verifypn).exists()) {
            verifypnpath = verifypn;
            v = new VerifyPN(new FileFinder(), new MessengerImpl());
            if (v.isCorrectVersion()) {
                return true;
            }
            verifypn = null;
            verifypnpath = null;
        }
        if ((verifypn = Preferences.getInstance().getVerifypnLocation()) != null && !verifypn.isEmpty()) {
            verifypnpath = verifypn;
            v = new VerifyPN(new FileFinder(), new MessengerImpl());
            if (v.isCorrectVersion()) {
                return true;
            }
            verifypn = null;
            verifypnpath = null;
        }
        File installdir = TAPAAL.getInstallDir();
        for (String s : paths = new String[]{"/bin/verifypn", "/bin/verifypn64", "/bin/verifypn.exe", "/bin/verifypn64.exe"}) {
            File verifypnfile = new File(String.valueOf(installdir) + s);
            if (!verifypnfile.exists()) continue;
            verifypnpath = verifypnfile.getAbsolutePath();
            VerifyPN v2 = new VerifyPN(new FileFinder(), new MessengerImpl());
            if (v2.isCorrectVersion()) {
                return true;
            }
            verifypn = null;
            verifypnpath = null;
        }
        return false;
    }

    @Override
    public VerificationResult<TimedArcPetriNetTrace> verifyManually(String options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        VerifyTAPNExporter exporter = lens != null && lens.isColored() || model.value1().parentNetwork().isColored() ? new VerifyCPNExporter() : new VerifyPNExporter();
        ExportedVerifyTAPNModel exportedModel = exporter.export(model.value1(), query, lens, model.value2(), null, dataLayerQuery);
        if (exportedModel == null) {
            this.messenger.displayErrorMessage("There was an error exporting the model");
        }
        return this.verifyManually(options, model, exportedModel, query);
    }

    private VerificationResult<TimedArcPetriNetTrace> verifyManually(String options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query) {
        if (exportedModel == null) {
            return null;
        }
        this.runner = new ProcessRunner(verifypnpath, this.createArgumentString(exportedModel.modelFile(), exportedModel.queryFile(), options));
        this.runner.run();
        if (this.runner.error()) {
            return null;
        }
        String errorOutput = this.readOutput(this.runner.errorOutput());
        String standardOutput = this.readOutput(this.runner.standardOutput());
        Tuple<QueryResult, Stats> queryResult = this.parseQueryResult(standardOutput, model.value1().marking().size() + query.getExtraTokens(), query.getExtraTokens(), query);
        if (queryResult == null || queryResult.value1() == null) {
            return new VerificationResult<TimedArcPetriNetTrace>(errorOutput + System.getProperty("line.separator") + standardOutput, this.runner.getRunningTime());
        }
        this.ctlOutput = queryResult.value1().isCTL;
        return new VerificationResult<Object>(queryResult.value1(), null, null, this.runner.getRunningTime(), queryResult.value2(), false, standardOutput + "\n\n" + errorOutput, model, null);
    }

    @Override
    public VerificationResult<TimedArcPetriNetTrace> verify(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, DataLayer guiModel, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        VerifyTAPNExporter exporter;
        ExportedVerifyTAPNModel exportedModel;
        if (!this.supportsModel(model.value1(), options)) {
            throw new UnsupportedModelException("Verifypn does not support the given model.");
        }
        if (!this.supportsQuery(model.value1(), query, options)) {
            throw new UnsupportedQueryException("Verifypn does not support the given query.");
        }
        if (((VerifyTAPNOptions)options).discreteInclusion()) {
            this.mapDiscreteInclusionPlacesToNewNames(options, model);
        }
        if ((exportedModel = (exporter = lens != null && lens.isColored() || model.value1().parentNetwork().isColored() ? new VerifyCPNExporter() : new VerifyPNExporter()).export(model.value1(), query, lens, model.value2(), guiModel, dataLayerQuery)) == null) {
            this.messenger.displayErrorMessage("There was an error exporting the model");
        }
        return this.verify(options, model, exportedModel, query, dataLayerQuery, lens);
    }

    private void mapDiscreteInclusionPlacesToNewNames(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model) {
        VerifyTAPNOptions verificationOptions = (VerifyTAPNOptions)options;
        if (verificationOptions.inclusionPlaces().inclusionOption() == InclusionPlaces.InclusionPlacesOption.AllPlaces) {
            return;
        }
        ArrayList<TimedPlace> inclusionPlaces = new ArrayList<TimedPlace>();
        for (TimedPlace p : verificationOptions.inclusionPlaces().inclusionPlaces()) {
            if (p instanceof LocalTimedPlace) {
                LocalTimedPlace local = (LocalTimedPlace)p;
                if (!local.model().isActive()) continue;
                inclusionPlaces.add(model.value1().getPlaceByName(model.value2().map(local.model().name(), local.name())));
                continue;
            }
            inclusionPlaces.add(model.value1().getPlaceByName(model.value2().map("", p.name())));
        }
        ((VerifyTAPNOptions)options).setInclusionPlaces(new InclusionPlaces(InclusionPlaces.InclusionPlacesOption.UserSpecified, inclusionPlaces));
    }

    private VerificationResult<TimedArcPetriNetTrace> verify(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws IOException {
        boolean showTrace;
        ((VerifyTAPNOptions)options).setTokensInModel(model.value1().getNumberOfTokensInNet());
        this.runner = new ProcessRunner(verifypnpath, this.createArgumentString(exportedModel.modelFile(), exportedModel.queryFile(), options));
        this.runner.run();
        if (this.runner.error()) {
            return null;
        }
        PetriNetTab newTab = null;
        TimedArcPetriNetTrace tapnTrace = null;
        String errorOutput = this.readOutput(this.runner.errorOutput());
        String standardOutput = this.readOutput(this.runner.standardOutput());
        Tuple<QueryResult, Stats> queryResult = this.parseQueryResult(standardOutput, model.value1().getNumberOfTokensInNet() + query.getExtraTokens(), query.getExtraTokens(), query);
        if (queryResult == null || queryResult.value1() == null) {
            return new VerificationResult<TimedArcPetriNetTrace>(errorOutput + System.getProperty("line.separator") + standardOutput, this.runner.getRunningTime());
        }
        boolean isColored = lens != null && lens.isColored() || model.value1().parentNetwork().isColored();
        boolean bl = showTrace = query.getProperty() instanceof TCTLEFNode && queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLAGNode && !queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLEGNode && queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLAFNode && !queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof LTLENode && queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof LTLANode && !queryResult.value1().isQuerySatisfied();
        if (options.traceOption() != TAPNQuery.TraceOption.NONE && isColored && showTrace && options.unfoldedModelPath() != null) {
            PNMLoader tapnLoader = new PNMLoader();
            File fileOut = new File(options.unfoldedModelPath());
            File queriesOut = new File(options.unfoldedQueriesPath());
            try {
                LoadedModel loadedModel = tapnLoader.load(fileOut);
                TAPNComposer newComposer = new TAPNComposer(new MessengerImpl(), true);
                model = newComposer.transformModel(loadedModel.network());
                if (queryResult.value1() != null) {
                    tapnTrace = this.trace(errorOutput, standardOutput, options, model, exportedModel, query, queryResult);
                }
                if (tapnTrace != null) {
                    newTab = new PetriNetTab(loadedModel.network(), loadedModel.templates(), loadedModel.queries(), new TAPNLens(lens.isTimed(), lens.isGame(), false, lens.isStochastic()));
                    for (net.tapaal.gui.petrinet.verification.TAPNQuery loadedQuery : UnfoldNet.getQueries(queriesOut, loadedModel.network(), query.getCategory())) {
                        newTab.setInitialName(loadedQuery.getName() + " - unfolded");
                        loadedQuery.copyOptions(dataLayerQuery);
                        newTab.addQuery(loadedQuery);
                    }
                }
            }
            catch (FormatException e) {
                this.messenger.displayErrorMessage(e.getMessage());
                e.printStackTrace();
                return null;
            }
            catch (NullPointerException | ThreadDeath n) {
                return null;
            }
        }
        this.ctlOutput = queryResult.value1().isCTL;
        if (query.getCategory() == TAPNQuery.QueryCategory.HyperLTL && options.traceOption() != TAPNQuery.TraceOption.NONE) {
            Map<String, TimedArcPetriNetTrace> parsedTraceMap = this.traceMap(errorOutput, standardOutput, options, model, exportedModel, query, queryResult);
            VerificationResult<Map<String, TimedArcPetriNetTrace>> result = new VerificationResult<Map<String, TimedArcPetriNetTrace>>(queryResult.value1(), parsedTraceMap, this.runner.getRunningTime(), queryResult.value2(), false, standardOutput + "\n\n" + errorOutput, model, newTab);
            return result;
        }
        if (tapnTrace == null) {
            tapnTrace = this.trace(errorOutput, standardOutput, options, model, exportedModel, query, queryResult);
        }
        VerificationResult<TimedArcPetriNetTrace> result = new VerificationResult<TimedArcPetriNetTrace>(queryResult.value1(), tapnTrace, this.runner.getRunningTime(), queryResult.value2(), false, standardOutput + "\n\n" + errorOutput, model, newTab);
        return result;
    }

    @Nullable
    private TimedArcPetriNetTrace trace(String errorOutput, String standardOutput, VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, Tuple<QueryResult, Stats> queryResult) {
        TimedArcPetriNetTrace tapnTrace;
        if (!errorOutput.toLowerCase().contains("trace") && !standardOutput.contains("<trace>")) {
            return null;
        }
        if (!errorOutput.contains("Trace") && standardOutput.contains("<trace>")) {
            Object trace = "Trace:\n";
            trace = (String)trace + standardOutput.split("(?=<trace>)")[1];
            trace = ((String)trace).split("(?<=</trace>)")[0];
            tapnTrace = this.parseTrace((String)trace, options, model, exportedModel, query, queryResult.value1());
        } else if (errorOutput.contains("<trace>")) {
            String[] split = errorOutput.split("(?=<trace>)");
            if (split.length > 1) {
                Object trace = "Trace\n";
                trace = (String)trace + split[1];
                trace = ((String)trace).split("(?<=</trace>)")[0];
                tapnTrace = this.parseTrace((String)trace, options, model, exportedModel, query, queryResult.value1());
            } else {
                Object trace = "Trace\n";
                trace = (String)trace + errorOutput;
                tapnTrace = this.parseTrace((String)trace, options, model, exportedModel, query, queryResult.value1());
            }
        } else {
            tapnTrace = this.parseTrace(errorOutput, options, model, exportedModel, query, queryResult.value1());
        }
        return tapnTrace;
    }

    @Nullable
    private Map<String, TimedArcPetriNetTrace> traceMap(String errorOutput, String standardOutput, VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, Tuple<QueryResult, Stats> queryResult) {
        Map<String, TimedArcPetriNetTrace> tapnTracesMap;
        if (!errorOutput.contains("Trace") && standardOutput.contains("<trace>")) {
            Object trace = "Trace:\n";
            trace = (String)trace + standardOutput.split("(?=<trace>)")[1];
            trace = ((String)trace).split("(?<=</trace>)")[0];
            tapnTracesMap = this.parseMultipleTraces((String)trace, options, model, exportedModel, query, queryResult.value1());
        } else if (errorOutput.contains("<trace>")) {
            String[] split = errorOutput.split("(?=<trace>)");
            if (split.length > 1) {
                Object trace = "Trace\n";
                trace = (String)trace + split[1];
                trace = ((String)trace).split("(?<=</trace>)")[0];
                tapnTracesMap = this.parseMultipleTraces((String)trace, options, model, exportedModel, query, queryResult.value1());
            } else {
                tapnTracesMap = this.parseMultipleTraces(errorOutput, options, model, exportedModel, query, queryResult.value1());
            }
        } else {
            tapnTracesMap = this.parseMultipleTraces(errorOutput, options, model, exportedModel, query, queryResult.value1());
        }
        return tapnTracesMap;
    }

    private TimedArcPetriNetTrace parseTrace(String output, VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, QueryResult queryResult) {
        if (((VerifyTAPNOptions)options).trace() == TAPNQuery.TraceOption.NONE) {
            return null;
        }
        if (query.getProperty() instanceof TCTLEFNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAGNode && queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLEGNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAFNode && queryResult.isQuerySatisfied()) {
            return null;
        }
        VerifyTAPNTraceParser traceParser = new VerifyTAPNTraceParser(model.value1(), options.useExplicitSearch());
        return traceParser.parseTrace(new BufferedReader(new StringReader(output)));
    }

    private Map<String, TimedArcPetriNetTrace> parseMultipleTraces(String output, VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, QueryResult queryResult) {
        if (((VerifyTAPNOptions)options).trace() == TAPNQuery.TraceOption.NONE) {
            return null;
        }
        if (query.getProperty() instanceof TCTLEFNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAGNode && queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLEGNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAFNode && queryResult.isQuerySatisfied()) {
            return null;
        }
        VerifyTAPNTraceParser traceParser = new VerifyTAPNTraceParser(model.value1(), options.useExplicitSearch());
        if (query.getCategory() == TAPNQuery.QueryCategory.HyperLTL) {
            return traceParser.parseTraces(new BufferedReader(new StringReader(output)));
        }
        return null;
    }

    private String createArgumentString(String modelFile, String queryFile, VerificationOptions options) {
        return this.createArgumentString(modelFile, queryFile, options.toString());
    }

    private String createArgumentString(String modelFile, String queryFile, String options) {
        if (Platform.isWindows()) {
            return options + " \"" + modelFile + "\" \"" + queryFile + "\"";
        }
        return options + " " + modelFile + " " + queryFile;
    }

    private String readOutput(BufferedReader reader) {
        try {
            if (!reader.ready()) {
                return "";
            }
        }
        catch (IOException e1) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    private Tuple<QueryResult, Stats> parseQueryResult(String output, int totalTokens, int extraTokens, TAPNQuery query) {
        Tuple<QueryResult, Stats> result;
        if (output.contains("Processed N. Edges:")) {
            VerifyPNCTLOutputParser outputParser = new VerifyPNCTLOutputParser(totalTokens, extraTokens, query);
            result = outputParser.parseOutput(output);
            result.value1().isCTL = true;
        } else {
            VerifyPNOutputParser outputParser = new VerifyPNOutputParser(totalTokens, extraTokens, query);
            result = ((VerifyTAPNOutputParser)outputParser).parseOutput(output);
        }
        return result;
    }

    @Override
    public boolean supportsModel(TimedArcPetriNet model, VerificationOptions options) {
        return model.isUntimed() || options.searchOption() == TAPNQuery.SearchOption.OVERAPPROXIMATE;
    }

    @Override
    public boolean supportsQuery(TimedArcPetriNet model, TAPNQuery query, VerificationOptions options) {
        if (query.getCategory() == TAPNQuery.QueryCategory.CTL || query.getCategory() == TAPNQuery.QueryCategory.LTL || query.getCategory() == TAPNQuery.QueryCategory.HyperLTL) {
            return true;
        }
        return !(query.getProperty() instanceof TCTLEGNode) && !(query.getProperty() instanceof TCTLAFNode);
    }

    public static void reset() {
        verifypnpath = "";
        Preferences.getInstance().setVerifypnLocation(null);
        VerifyPN.trySetup();
    }

    public String getHelpOptions() {
        this.runner = new ProcessRunner(verifypnpath, "--help", this);
        this.runner.run();
        if (!this.runner.error()) {
            return this.readOutput(this.runner.standardOutput());
        }
        return null;
    }

    public String toString() {
        return "verifypn";
    }

    @Override
    public boolean useDiscreteSemantics() {
        return false;
    }
}

