/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.VerifyTAPN;

import com.sun.jna.Platform;
import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.io.LoadedModel;
import dk.aau.cs.io.TapnEngineXmlLoader;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.util.UnsupportedQueryException;
import dk.aau.cs.verification.EngineHelperFunctions;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.ProcessRunner;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.Stats;
import dk.aau.cs.verification.TAPNComposer;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerificationResult;
import dk.aau.cs.verification.VerifyTAPN.ExportedVerifyTAPNModel;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyDTAPNOutputParser;
import dk.aau.cs.verification.VerifyTAPN.VerifyTACPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNExporter;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNOptions;
import dk.aau.cs.verification.VerifyTAPN.VerifyTAPNTraceParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import net.tapaal.Preferences;
import net.tapaal.TAPAAL;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.InclusionPlaces;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import net.tapaal.gui.petrinet.verification.UnfoldNet;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.petrinet.PetriNetTab;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class VerifyDTAPN
implements ModelChecker {
    private static final String NEED_TO_LOCATE_VERIFYDTAPN_MSG = "TAPAAL needs to know the location of the file verifydtapn.\n\nVerifydtapn is a part of the TAPAAL distribution and it is\nnormally located in the directory lib.";
    private static final String VERIFYDTAPN_VERSION_PATTERN = "^VerifyDTAPN (\\d+\\.\\d+\\.\\d+)$";
    protected static String verifydtapnpath = "";
    protected final FileFinder fileFinder;
    protected final Messenger messenger;
    protected ProcessRunner runner;
    private boolean isSMC = false;

    public VerifyDTAPN(FileFinder fileFinder, Messenger messenger) {
        this.fileFinder = fileFinder;
        this.messenger = messenger;
    }

    @Override
    public boolean supportsStats() {
        return true;
    }

    @Override
    public String[] getStatsExplanations() {
        String[] explanations = !this.isSMC ? new String[]{"The number of found markings (each time a successor is calculated, this number is incremented)", "The number of markings taken out of the waiting list during the search.", "The number of markings found in the passed/waiting list at the end of verification."} : new String[]{"The number of random runs executed during statistical verification", "The number of random runs satisfying the tested propriety", "The average total time delayed for executed random runs", "The average number of transitions firing for executed random runs"};
        return explanations;
    }

    @Override
    public String getPath() {
        return verifydtapnpath;
    }

    @Override
    public String getVersion() {
        return EngineHelperFunctions.getVersion(new String[]{verifydtapnpath, "-v"}, VERIFYDTAPN_VERSION_PATTERN);
    }

    public String getVersion(String path) {
        return EngineHelperFunctions.getVersion(new String[]{path, "-v"}, VERIFYDTAPN_VERSION_PATTERN);
    }

    @Override
    public boolean isCorrectVersion() {
        return this.isCorrectVersion(this.getPath());
    }

    public boolean isCorrectVersion(String path) {
        if (path == null || path.isBlank() || !new File(path).exists()) {
            return false;
        }
        File file = new File(path);
        if (!file.canExecute()) {
            this.messenger.displayErrorMessage("The engine verifydtapn is not executable.\nThe verifydtapn path will be reset. Please try again, to manually set the verifydtapn path.", "Verifydtapn Error");
            return false;
        }
        String version = this.getVersion(path);
        if (version != null) {
            return EngineHelperFunctions.versionIsEqualOrGreater(version, "3.6.1");
        }
        return false;
    }

    private void resetVerifytapn() {
        verifydtapnpath = null;
        Preferences.getInstance().setVerifydtapnLocation(null);
    }

    @Override
    public void kill() {
        if (this.runner != null) {
            this.runner.kill();
        }
    }

    @Override
    public void setPath(String path) throws IllegalArgumentException {
        if (this.isCorrectVersion(path)) {
            verifydtapnpath = path;
            Preferences.getInstance().setVerifydtapnLocation(path);
        } else {
            this.messenger.displayErrorMessage("The specified version of the file verifydtapn is too old, or not recognized as verifypn", "Verifydtapn Error");
        }
    }

    @Override
    public boolean setup() {
        if (this.isNotSetup()) {
            this.messenger.displayInfoMessage(NEED_TO_LOCATE_VERIFYDTAPN_MSG, "Locate verifydtapn");
            try {
                File file = this.fileFinder.ShowFileBrowserDialog("Verifydtapn", "", System.getProperty("user.home"));
                if (file != null) {
                    if (file.getName().matches("^verifydtapn.*(?:\\.exe)?$")) {
                        this.setPath(file.getAbsolutePath());
                    } else {
                        this.messenger.displayErrorMessage("The selected executable does not seem to be verifydtapn.");
                    }
                }
            }
            catch (Exception e) {
                this.messenger.displayErrorMessage("There were errors performing the requested action:\n" + e.getMessage(), "Error");
            }
        }
        return !this.isNotSetup();
    }

    private boolean isNotSetup() {
        return verifydtapnpath == null || verifydtapnpath.equals("") || !new File(verifydtapnpath).exists();
    }

    public static boolean trySetup() {
        String[] paths;
        VerifyDTAPN v;
        String verifydtapn = System.getenv("verifydtapn");
        if (verifydtapn != null && !verifydtapn.isEmpty() && new File(verifydtapn).exists()) {
            verifydtapnpath = verifydtapn;
            v = new VerifyDTAPN(new FileFinder(), new MessengerImpl());
            if (v.isCorrectVersion()) {
                return true;
            }
            verifydtapnpath = null;
        }
        if ((verifydtapn = Preferences.getInstance().getVerifydtapnLocation()) != null && !verifydtapn.isEmpty()) {
            verifydtapnpath = verifydtapn;
            v = new VerifyDTAPN(new FileFinder(), new MessengerImpl());
            if (v.isCorrectVersion()) {
                return true;
            }
            verifydtapnpath = null;
        }
        File installdir = TAPAAL.getInstallDir();
        for (String s : paths = new String[]{"/bin/verifydtapn", "/bin/verifydtapn64", "/bin/verifydtapn.exe", "/bin/verifydtapn64.exe"}) {
            File verifydtapnfile = new File(String.valueOf(installdir) + s);
            if (!verifydtapnfile.exists()) continue;
            verifydtapnpath = verifydtapnfile.getAbsolutePath();
            VerifyDTAPN v2 = new VerifyDTAPN(new FileFinder(), new MessengerImpl());
            if (v2.isCorrectVersion()) {
                return true;
            }
            verifydtapnpath = null;
        }
        return false;
    }

    @Override
    public VerificationResult<TimedArcPetriNetTrace> verify(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, DataLayer guiModel, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        ExportedVerifyTAPNModel exportedModel;
        if (!this.supportsModel(model.value1(), options)) {
            throw new UnsupportedModelException("Verifydtapn does not support the given model.");
        }
        if (!this.supportsQuery(model.value1(), query, options)) {
            throw new UnsupportedQueryException("Verifydtapn does not support the given query-option combination. ");
        }
        if (options instanceof VerifyTAPNOptions && ((VerifyTAPNOptions)options).discreteInclusion()) {
            this.mapDiscreteInclusionPlacesToNewNames(options, model);
        }
        if (lens != null && lens.isColored() || model.value1().parentNetwork() != null && model.value1().parentNetwork().isColored()) {
            VerifyTACPNExporter exporter = new VerifyTACPNExporter();
            exportedModel = exporter.export(model.value1(), query, lens, model.value2(), guiModel, dataLayerQuery);
        } else {
            VerifyTAPNExporter exporter = new VerifyTAPNExporter();
            exportedModel = exporter.export(model.value1(), query, lens, model.value2(), guiModel, dataLayerQuery);
        }
        if (exportedModel == null) {
            this.messenger.displayErrorMessage("There was an error exporting the model");
            return null;
        }
        return this.verify(options, model, exportedModel, query, dataLayerQuery, lens);
    }

    @Override
    public VerificationResult<TimedArcPetriNetTrace> verifyManually(String options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        VerifyTAPNExporter exporter = lens != null && lens.isColored() || model.value1().parentNetwork().isColored() ? new VerifyTACPNExporter() : new VerifyTAPNExporter();
        ExportedVerifyTAPNModel exportedModel = exporter.export(model.value1(), query, lens, model.value2(), null, dataLayerQuery);
        if (exportedModel == null) {
            this.messenger.displayErrorMessage("There was an error exporting the model");
        }
        return this.verifyManually(options, model, exportedModel, query);
    }

    private VerificationResult<TimedArcPetriNetTrace> verifyManually(String options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query) {
        if (exportedModel == null) {
            return null;
        }
        this.runner = new ProcessRunner(verifydtapnpath, this.createArgumentString(exportedModel.modelFile(), exportedModel.queryFile(), options));
        this.runner.run();
        if (this.runner.error()) {
            return null;
        }
        String errorOutput = this.readOutput(this.runner.errorOutput());
        String standardOutput = this.readOutput(this.runner.standardOutput());
        Tuple<QueryResult, Stats> queryResult = this.parseQueryResult(standardOutput, model.value1().marking().size() + query.getExtraTokens(), query.getExtraTokens(), query, model.value1());
        if (queryResult == null || queryResult.value1() == null) {
            return new VerificationResult<TimedArcPetriNetTrace>(errorOutput + System.getProperty("line.separator") + standardOutput, this.runner.getRunningTime());
        }
        this.isSMC = queryResult.value1().isSMC();
        return new VerificationResult<Object>(queryResult.value1(), null, null, this.runner.getRunningTime(), queryResult.value2(), false, standardOutput + "\n\n" + errorOutput, model, null);
    }

    protected void mapDiscreteInclusionPlacesToNewNames(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model) {
        VerifyTAPNOptions verificationOptions = (VerifyTAPNOptions)options;
        if (verificationOptions.inclusionPlaces().inclusionOption() == InclusionPlaces.InclusionPlacesOption.AllPlaces) {
            return;
        }
        ArrayList<TimedPlace> inclusionPlaces = new ArrayList<TimedPlace>();
        for (TimedPlace p : verificationOptions.inclusionPlaces().inclusionPlaces()) {
            if (p instanceof LocalTimedPlace) {
                LocalTimedPlace local = (LocalTimedPlace)p;
                if (!local.model().isActive()) continue;
                inclusionPlaces.add(model.value1().getPlaceByName(model.value2().map(local.model().name(), local.name())));
                continue;
            }
            inclusionPlaces.add(model.value1().getPlaceByName(model.value2().map("", p.name())));
        }
        ((VerifyTAPNOptions)options).setInclusionPlaces(new InclusionPlaces(InclusionPlaces.InclusionPlacesOption.UserSpecified, inclusionPlaces));
    }

    protected VerificationResult<TimedArcPetriNetTrace> verify(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) {
        BufferedReader reader;
        VerifyTAPNTraceParser traceParser;
        Map<String, TimedArcPetriNetTrace> parsedTraceMap;
        boolean showTrace;
        if (options instanceof VerifyTAPNOptions) {
            ((VerifyTAPNOptions)options).setTokensInModel(model.value1().getNumberOfTokensInNet());
        }
        this.runner = new ProcessRunner(verifydtapnpath, this.createArgumentString(exportedModel.modelFile(), exportedModel.queryFile(), options));
        this.runner.run();
        if (this.runner.error()) {
            return null;
        }
        PetriNetTab newTab = null;
        String errorOutput = this.readOutput(this.runner.errorOutput());
        String standardOutput = this.readOutput(this.runner.standardOutput());
        Tuple<QueryResult, Stats> queryResult = this.parseQueryResult(standardOutput, model.value1().marking().size() + query.getExtraTokens(), query.getExtraTokens(), query, model.value1());
        if (queryResult == null || queryResult.value1() == null) {
            return new VerificationResult<TimedArcPetriNetTrace>(errorOutput + System.getProperty("line.separator") + standardOutput, this.runner.getRunningTime());
        }
        this.isSMC = queryResult.value1().isSMC();
        TimedArcPetriNetTrace tapnTrace = null;
        boolean isColored = lens != null && lens.isColored() || model.value1().parentNetwork() != null && model.value1().parentNetwork().isColored();
        boolean bl = showTrace = query.getProperty() instanceof TCTLEFNode && queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLAGNode && !queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLEGNode && queryResult.value1().isQuerySatisfied() || query.getProperty() instanceof TCTLAFNode && !queryResult.value1().isQuerySatisfied();
        if (options.traceOption() != TAPNQuery.TraceOption.NONE && isColored && showTrace || this.isSMC && options.isSimulate() && isColored) {
            TapnEngineXmlLoader tapnLoader = new TapnEngineXmlLoader();
            File fileOut = new File(options.unfoldedModelPath());
            File queriesOut = new File(options.unfoldedQueriesPath());
            try {
                LoadedModel loadedModel = tapnLoader.load(fileOut);
                TAPNComposer newComposer = new TAPNComposer(new MessengerImpl(), true);
                model = newComposer.transformModel(loadedModel.network());
                if (queryResult.value1() != null) {
                    tapnTrace = this.parseTrace(!errorOutput.contains("Trace:") ? errorOutput : errorOutput.split("Trace:")[1], options, model, exportedModel, query, queryResult.value1());
                }
                if (tapnTrace != null || options.isSimulate()) {
                    newTab = new PetriNetTab(loadedModel.network(), loadedModel.templates(), loadedModel.queries(), new TAPNLens(lens.isTimed(), lens.isGame(), false, lens.isStochastic()));
                    for (net.tapaal.gui.petrinet.verification.TAPNQuery loadedQuery : UnfoldNet.getQueries(queriesOut, loadedModel.network(), query.getCategory())) {
                        newTab.setInitialName(loadedQuery.getName() + " - unfolded");
                        loadedQuery.copyOptions(dataLayerQuery);
                        newTab.addQuery(loadedQuery);
                    }
                }
            }
            catch (Exception | ThreadDeath e) {
                e.printStackTrace();
                return null;
            }
        }
        if (this.isSMC && options.isSimulate() && (parsedTraceMap = (traceParser = new VerifyTAPNTraceParser(model.value1())).parseTraces(reader = new BufferedReader(new StringReader(errorOutput)))) != null && !parsedTraceMap.isEmpty()) {
            if (parsedTraceMap.size() > 1) {
                VerificationResult<Map<String, TimedArcPetriNetTrace>> result = new VerificationResult<Map<String, TimedArcPetriNetTrace>>(queryResult.value1(), parsedTraceMap, this.runner.getRunningTime(), queryResult.value2(), false, standardOutput + "\n\n" + errorOutput, model, newTab);
                return result;
            }
            tapnTrace = parsedTraceMap.values().iterator().next();
        }
        if (tapnTrace == null) {
            tapnTrace = this.parseTrace(!errorOutput.contains("Trace:") ? errorOutput : errorOutput.split("Trace:")[1], options, model, exportedModel, query, queryResult.value1());
        }
        TimedArcPetriNetTrace secondaryTrace = null;
        if (queryResult.value2().getCoveredMarking() != null) {
            secondaryTrace = this.parseTrace(errorOutput.split("Trace:")[2], options, model, exportedModel, query, queryResult.value1());
        }
        return new VerificationResult<TimedArcPetriNetTrace>(queryResult.value1(), tapnTrace, secondaryTrace, this.runner.getRunningTime(), queryResult.value2(), false, standardOutput + "\n\n" + errorOutput, model, newTab);
    }

    public Stats getStats(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) {
        VerifyTAPNExporter exporter = lens != null && lens.isColored() || model.value1().parentNetwork().isColored() ? new VerifyTACPNExporter() : new VerifyTAPNExporter();
        ExportedVerifyTAPNModel exportedModel = exporter.export(model.value1(), query, lens, model.value2(), null, dataLayerQuery);
        if (exportedModel == null) {
            this.messenger.displayErrorMessage("There was an error exporting the model");
            return null;
        }
        this.runner = new ProcessRunner(verifydtapnpath, this.createArgumentString(exportedModel.modelFile(), exportedModel.queryFile(), options));
        this.runner.run();
        if (this.runner.error()) {
            return null;
        }
        String standardOutput = this.readOutput(this.runner.standardOutput());
        Tuple<QueryResult, Stats> queryResult = this.parseQueryResult(standardOutput, model.value1().marking().size() + query.getExtraTokens(), query.getExtraTokens(), query, model.value1());
        return queryResult.value2();
    }

    private TimedArcPetriNetTrace parseTrace(String output, VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, ExportedVerifyTAPNModel exportedModel, TAPNQuery query, QueryResult queryResult) {
        if (((VerifyTAPNOptions)options).trace() == TAPNQuery.TraceOption.NONE) {
            return null;
        }
        VerifyTAPNTraceParser traceParser = new VerifyTAPNTraceParser(model.value1());
        TimedArcPetriNetTrace trace = traceParser.parseTrace(new BufferedReader(new StringReader(output)));
        if (trace == null && ((VerifyTAPNOptions)options).trace() != TAPNQuery.TraceOption.NONE && (query.getProperty() instanceof TCTLEFNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAGNode && queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLEGNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAFNode && queryResult.isQuerySatisfied())) {
            return null;
        }
        return trace;
    }

    private String createArgumentString(String modelFile, String queryFile, VerificationOptions options) {
        String queryString = "";
        if (options instanceof VerifyDTAPNOptions && (((VerifyDTAPNOptions)options).getWorkflowMode() == TAPNQuery.WorkflowMode.NOT_WORKFLOW || ((VerifyDTAPNOptions)options).getWorkflowMode() == null)) {
            queryString = queryFile;
        }
        return this.createArgumentString(modelFile, queryString, options.toString());
    }

    private String createArgumentString(String modelFile, String queryFile, String options) {
        if (Platform.isWindows()) {
            return options + " \"" + modelFile + "\" \"" + queryFile + "\"";
        }
        return options + " " + modelFile + " " + queryFile;
    }

    private String readOutput(BufferedReader reader) {
        try {
            if (!reader.ready()) {
                return "";
            }
        }
        catch (IOException e1) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    private Tuple<QueryResult, Stats> parseQueryResult(String output, int totalTokens, int extraTokens, TAPNQuery query, TimedArcPetriNet model) {
        VerifyDTAPNOutputParser outputParser = new VerifyDTAPNOutputParser(totalTokens, extraTokens, query);
        return outputParser.parseOutput(output);
    }

    @Override
    public boolean supportsModel(TimedArcPetriNet model, VerificationOptions options) {
        if (model.hasUrgentTransitions() && options instanceof VerifyTAPNOptions && ((VerifyDTAPNOptions)options).timeDarts()) {
            return false;
        }
        return model.isNonStrict();
    }

    @Override
    public boolean supportsQuery(TimedArcPetriNet model, TAPNQuery query, VerificationOptions options) {
        return !(query.getProperty() instanceof TCTLEGNode) && !(query.getProperty() instanceof TCTLAFNode) || !query.hasDeadlock() || !(options instanceof VerifyDTAPNOptions) || !((VerifyDTAPNOptions)options).timeDarts();
    }

    public static void reset() {
        verifydtapnpath = "";
        Preferences.getInstance().setVerifydtapnLocation(null);
        VerifyDTAPN.trySetup();
    }

    public String getHelpOptions() {
        this.runner = new ProcessRunner(verifydtapnpath, "--help", this);
        this.runner.run();
        if (!this.runner.error()) {
            return this.readOutput(this.runner.standardOutput());
        }
        return null;
    }

    public String toString() {
        return "verifydtapn";
    }

    @Override
    public boolean useDiscreteSemantics() {
        return true;
    }
}

