/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.Boundedness;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.NullStats;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.QueryType;
import dk.aau.cs.verification.ReductionStats;
import dk.aau.cs.verification.Stats;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pipe.gui.petrinet.PetriNetTab;

public class VerificationResult<TTrace> {
    private QueryResult queryResult;
    private TTrace trace;
    private String errorMessage = null;
    private String rawOutput = null;
    private long verificationTime = 0L;
    private Stats stats;
    private NameMapping nameMapping;
    private TTrace secondaryTrace;
    private Map<String, TTrace> traceMap;
    private int bound = -1;
    private Tuple<TimedArcPetriNet, NameMapping> unfoldedModel;
    private PetriNetTab unfoldedTab;
    private boolean resolvedUsingSkeletonPreprocessor = false;

    public boolean isSolvedUsingQuerySimplification() {
        return this.queryResult.isSolvedUsingQuerySimplification();
    }

    public boolean isSolvedUsingTraceAbstractRefinement() {
        return this.queryResult.isSolvedUsingTraceAbstractRefinement();
    }

    public boolean isSolvedUsingSiphonTrap() {
        return this.queryResult.isSolvedUsingSiphonTrap();
    }

    public boolean isQuerySatisfied() {
        return this.queryResult.isQuerySatisfied();
    }

    public VerificationResult(QueryResult queryResult, TTrace trace, long verificationTime, Stats stats, String rawOutput) {
        this.queryResult = queryResult;
        this.trace = trace;
        this.verificationTime = verificationTime;
        this.stats = stats;
        this.rawOutput = rawOutput;
        if (rawOutput != null) {
            String[] lines;
            for (String line : lines = rawOutput.split(System.getProperty("line.separator"))) {
                Matcher matcher = Pattern.compile("\\s*--k-bound\\s*(\\d+)\\s*").matcher(line);
                if (!matcher.find()) continue;
                this.bound = Integer.parseInt(matcher.group(1));
                break;
            }
        }
    }

    public VerificationResult(QueryResult queryResult, Map<String, TTrace> traceMap, long verificationTime, Stats stats, boolean isSolvedUsingStateEquation, String rawOutput, Tuple<TimedArcPetriNet, NameMapping> unfoldedModel, PetriNetTab unfoldedTab) {
        this.queryResult = queryResult;
        this.stats = stats;
        this.rawOutput = rawOutput;
        this.verificationTime = verificationTime;
        this.traceMap = traceMap;
        this.unfoldedModel = unfoldedModel;
        this.unfoldedTab = unfoldedTab;
        this.trace = traceMap != null ? traceMap.get(traceMap.keySet().toArray()[0]) : null;
    }

    public VerificationResult(QueryResult queryResult, TTrace trace, long verificationTime, Stats stats, boolean isSolvedUsingStateEquation, String rawOutput, Tuple<TimedArcPetriNet, NameMapping> unfoldedModel, PetriNetTab unfoldedTab) {
        this(queryResult, trace, verificationTime, stats, rawOutput);
        this.unfoldedModel = unfoldedModel;
        this.unfoldedTab = unfoldedTab;
    }

    public VerificationResult(QueryResult queryResult, TTrace trace, long verificationTime, String rawOutput) {
        this(queryResult, trace, verificationTime, new NullStats(), rawOutput);
    }

    public VerificationResult(String outputMessage, long verificationTime) {
        this.rawOutput = this.errorMessage = outputMessage;
        this.verificationTime = verificationTime;
    }

    public VerificationResult(QueryResult value1, TTrace tapnTrace, TTrace secondaryTrace2, long runningTime, Stats value2, boolean isSolvedUsingStateEquation, Tuple<TimedArcPetriNet, NameMapping> unfoldedModel) {
        this(value1, tapnTrace, runningTime, value2, isSolvedUsingStateEquation, null, unfoldedModel, null);
        this.secondaryTrace = secondaryTrace2;
    }

    public VerificationResult(QueryResult value1, TTrace tapnTrace, TTrace secondaryTrace2, long runningTime, Stats value2, boolean isSolvedUsingStateEquation, String rawOutput, Tuple<TimedArcPetriNet, NameMapping> unfoldedModel, PetriNetTab unfoldedTab) {
        this(value1, tapnTrace, runningTime, value2, isSolvedUsingStateEquation, rawOutput, unfoldedModel, unfoldedTab);
        this.secondaryTrace = secondaryTrace2;
    }

    public VerificationResult(QueryResult value1, Map<String, TTrace> traceMap, TTrace tapnTrace, TTrace secondaryTrace2, long runningTime, Stats value2, boolean isSolvedUsingStateEquation, String rawOutput, Tuple<TimedArcPetriNet, NameMapping> unfoldedModel, PetriNetTab unfoldedTab) {
        this(value1, tapnTrace, runningTime, value2, isSolvedUsingStateEquation, rawOutput, unfoldedModel, unfoldedTab);
        this.traceMap = traceMap;
        this.secondaryTrace = secondaryTrace2;
    }

    public Map<String, TTrace> getTraceMap() {
        return this.traceMap;
    }

    public void setTraceMap(Map<String, TTrace> traceMap) {
        this.traceMap = traceMap;
    }

    public NameMapping getNameMapping() {
        return this.nameMapping;
    }

    public void setNameMapping(NameMapping nameMapping) {
        this.nameMapping = nameMapping;
    }

    public List<Tuple<String, Number>> getTransitionStatistics() {
        ArrayList<Tuple<String, Number>> returnList = new ArrayList<Tuple<String, Number>>();
        for (int i = 0; i < this.stats.transitionsCount(); ++i) {
            Tuple<String, Number> element = this.stats.getTransitionStats(i);
            Object transitionName = element.value1().replace("_", ".");
            if (((String)transitionName).charAt(0) == '.') {
                transitionName = "Shared" + (String)transitionName;
            }
            Number transitionFired = element.value2();
            returnList.add(new Tuple<Object, Number>(transitionName, transitionFired));
        }
        returnList.sort(new transitionTupleComparator());
        return returnList;
    }

    public List<Tuple<String, Number>> getPlaceBoundStatistics() {
        ArrayList<Tuple<String, Number>> returnList = new ArrayList<Tuple<String, Number>>();
        for (int i = 0; i < this.stats.placeBoundCount(); ++i) {
            Tuple<String, Number> element = this.stats.getPlaceBoundStats(i);
            Object placeName = element.value1().replace("_", ".");
            if (((String)placeName).charAt(0) == '.') {
                placeName = "Shared" + (String)placeName;
            }
            Number placeBound = element.value2();
            returnList.add(new Tuple<Object, Number>(placeName, placeBound));
        }
        returnList.sort(new transitionTupleComparator());
        return returnList;
    }

    public boolean isResolvedUsingSkeletonPreprocessor() {
        return this.resolvedUsingSkeletonPreprocessor;
    }

    public boolean setResolvedUsingSkeletonAnalysisPreprocessor(boolean b) {
        this.resolvedUsingSkeletonPreprocessor = b;
        return this.resolvedUsingSkeletonPreprocessor;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public void setTrace(TTrace newTrace) {
        this.trace = newTrace;
    }

    public void setSecondaryTrace(TTrace newTrace) {
        this.secondaryTrace = newTrace;
    }

    public TTrace getTrace() {
        return this.trace;
    }

    public TTrace getSecondaryTrace() {
        return this.secondaryTrace;
    }

    public Tuple<TimedArcPetriNet, NameMapping> getUnfoldedModel() {
        return this.unfoldedModel;
    }

    public PetriNetTab getUnfoldedTab() {
        return this.unfoldedTab;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public Stats stats() {
        return this.stats;
    }

    public boolean error() {
        return this.errorMessage != null;
    }

    public long verificationTime() {
        return this.verificationTime;
    }

    public String getVerificationTimeString() {
        return String.format("Estimated verification time: %1$.2fs", (double)this.verificationTime() / 1000.0);
    }

    public Stats getStats() {
        return this.stats;
    }

    public String getStatsAsString() {
        return this.stats.toString();
    }

    public boolean isBounded() {
        return this.queryResult.boundednessAnalysis().boundednessResult().equals((Object)Boundedness.Bounded);
    }

    public String getResultString() {
        if (this.queryResult.isDiscreteIncludion() && !this.queryResult.boundednessAnalysis().boundednessResult().equals((Object)Boundedness.Bounded) && (!this.queryResult.isQuerySatisfied() && this.queryResult.queryType().equals((Object)QueryType.EF) || this.queryResult.isQuerySatisfied() && this.queryResult.queryType().equals((Object)QueryType.AG))) {
            return "Verification is inconclusive.\nDisable discrete inclusion or add extra tokens and try again.";
        }
        return this.queryResult.toString();
    }

    public String getReductionResultAsString() {
        ReductionStats reductionStats = this.stats.getReductionStats();
        if (reductionStats == null) {
            return "";
        }
        return reductionStats.toString();
    }

    public boolean reductionRulesApplied() {
        ReductionStats reductionStats = this.stats.getReductionStats();
        return reductionStats.getRemovedPlaces() + reductionStats.getRemovedTransitions() > 0;
    }

    public NetworkMarking getCoveredMarking(TimedArcPetriNetNetwork model) {
        if (this.stats.getCoveredMarking() == null) {
            return null;
        }
        NetworkMarking m = model.marking().clone();
        m.clear();
        for (Tuple<String, Tuple<BigDecimal, Integer>> token : this.stats.getCoveredMarking()) {
            Tuple<String, String> originalName = this.nameMapping.map(token.value1());
            TimedPlace p = originalName.value1() == null || originalName.value1().isEmpty() ? model.getSharedPlaceByName(originalName.value2()) : model.getTAPNByName(originalName.value1()).getPlaceByName(originalName.value2());
            for (int i = 0; i < token.value2().value2(); ++i) {
                m.add(new TimedToken(p, token.value2().value1(), ColorType.COLORTYPE_DOT.getFirstColor()));
            }
        }
        return m;
    }

    public void addTime(long timeToAdd) {
        this.verificationTime += timeToAdd;
    }

    public String getCTLStatsAsString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Explored configurations: ");
        buffer.append(this.stats.getConfigurations());
        buffer.append(System.getProperty("line.separator"));
        buffer.append("Explored markings: ");
        buffer.append(this.stats.getMarkings());
        buffer.append(System.getProperty("line.separator"));
        buffer.append("Explored hyper-edges: ");
        buffer.append(this.stats.getEdges());
        return buffer.toString();
    }

    public String getRawOutput() {
        return this.rawOutput;
    }

    public int getBound() {
        return this.bound;
    }

    public static class transitionTupleComparator
    implements Comparator<Tuple<String, Number>> {
        @Override
        public int compare(Tuple<String, Number> tuple1, Tuple<String, Number> tuple2) {
            double val1 = tuple1.value2().doubleValue();
            double val2 = tuple2.value2().doubleValue();
            if (val2 > val1) {
                return 1;
            }
            if (val2 < val1) {
                return -1;
            }
            return 0;
        }
    }
}

