/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification.UPPAAL;

import dk.aau.cs.Messenger;
import dk.aau.cs.TCTL.TCTLAFNode;
import dk.aau.cs.TCTL.TCTLAGNode;
import dk.aau.cs.TCTL.TCTLEFNode;
import dk.aau.cs.TCTL.TCTLEGNode;
import dk.aau.cs.TCTL.visitors.HasDeadlockVisitor;
import dk.aau.cs.model.NTA.trace.UppaalTrace;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.translations.ReductionOption;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.util.UnsupportedQueryException;
import dk.aau.cs.verification.EngineHelperFunctions;
import dk.aau.cs.verification.ModelChecker;
import dk.aau.cs.verification.NameMapping;
import dk.aau.cs.verification.ProcessRunner;
import dk.aau.cs.verification.QueryResult;
import dk.aau.cs.verification.UPPAAL.ExportedModel;
import dk.aau.cs.verification.UPPAAL.UppaalExporter;
import dk.aau.cs.verification.UPPAAL.VerifytaOptions;
import dk.aau.cs.verification.UPPAAL.VerifytaOutputParser;
import dk.aau.cs.verification.UPPAAL.VerifytaTraceInterpreter;
import dk.aau.cs.verification.UPPAAL.VerifytaTraceParser;
import dk.aau.cs.verification.VerificationOptions;
import dk.aau.cs.verification.VerificationResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import net.tapaal.Preferences;
import net.tapaal.gui.petrinet.TAPNLens;
import net.tapaal.gui.petrinet.verification.TAPNQuery;
import pipe.gui.FileFinder;
import pipe.gui.MessengerImpl;
import pipe.gui.petrinet.dataLayer.DataLayer;

public class Verifyta
implements ModelChecker {
    private static final String NEED_TO_LOCATE_VERIFYTA_MSG = "TAPAAL needs to know the location of the file verifyta.\n\nVerifyta is a part of the UPPAAL distribution and it is\nnormally located in uppaal/bin-Linux or uppaal/bin-Win32,\ndepending on the operating system used.";
    private static final String VERIFYTA_VERSION_PATTERN = "(\\d+\\.\\d+\\.\\d+)";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static String verifytapath = "";
    private FileFinder fileFinder;
    private Messenger messenger;
    private ProcessRunner runner;

    public Verifyta() {
    }

    public Verifyta(FileFinder fileFinder, Messenger messenger) {
        this.fileFinder = fileFinder;
        this.messenger = messenger;
    }

    @Override
    public boolean setup() {
        if (this.isNotSetup()) {
            this.messenger.displayInfoMessage(NEED_TO_LOCATE_VERIFYTA_MSG, "Locate UPPAAL Verifyta");
            try {
                File file = this.fileFinder.ShowFileBrowserDialog("Verifyta", "", System.getProperty("user.home"));
                if (file != null) {
                    if (file.getName().matches("^verifyta(?:\\d.*)?(?:\\.exe)?$")) {
                        this.setPath(file.getAbsolutePath());
                    } else {
                        this.messenger.displayErrorMessage("The selected executable does not seem to be verifyta.");
                    }
                }
            }
            catch (Exception e) {
                this.messenger.displayErrorMessage("There were errors performing the requested action:\n" + e.getMessage(), "Error");
            }
        }
        return !this.isNotSetup();
    }

    @Override
    public String getPath() {
        return verifytapath;
    }

    @Override
    public String getVersion() {
        return EngineHelperFunctions.getVersion(new String[]{verifytapath, "-v"}, VERIFYTA_VERSION_PATTERN);
    }

    public String getVersion(String path) {
        return EngineHelperFunctions.getVersion(new String[]{path, "-v"}, VERIFYTA_VERSION_PATTERN);
    }

    @Override
    public boolean isCorrectVersion() {
        return this.isCorrectVersion(this.getPath());
    }

    public boolean isCorrectVersion(String path) {
        if (path == null || path.isBlank() || !new File(path).exists()) {
            return false;
        }
        String versionAsString = this.getVersion(path);
        if (versionAsString == null) {
            this.messenger.displayErrorMessage("The program can not be verified as being verifyta.\nThe verifyta path will be reset. Please try again, to manually set the verifyta path.", "Verifyta Error");
            return false;
        }
        EngineHelperFunctions.versionIsEqualOrGreater(versionAsString, "4.1.19");
        return true;
    }

    private void resetVerifyta() {
        verifytapath = null;
        Preferences.getInstance().setVerifytaLocation(verifytapath);
    }

    private boolean isNotSetup() {
        return verifytapath == null || verifytapath.equals("") || !new File(verifytapath).exists();
    }

    public static boolean trySetup() {
        try {
            Verifyta v;
            String verifyta = null;
            verifyta = System.getenv("verifyta");
            if (verifyta != null && !verifyta.equals("") && new File(verifyta).exists()) {
                verifytapath = verifyta;
                v = new Verifyta(new FileFinder(), new MessengerImpl());
                if (v.isCorrectVersion()) {
                    return true;
                }
                verifyta = null;
                verifytapath = null;
            }
            if ((verifyta = Preferences.getInstance().getVerifytaLocation()) != null && !verifyta.equals("")) {
                verifytapath = verifyta;
                v = new Verifyta(new FileFinder(), new MessengerImpl());
                if (v.isCorrectVersion()) {
                    return true;
                }
                verifyta = null;
                v.resetVerifyta();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String createArgumentString(String modelFile, String queryFile, VerificationOptions options) {
        StringBuilder buffer = new StringBuilder(options.toString());
        buffer.append(' ');
        buffer.append(modelFile);
        buffer.append(' ');
        buffer.append(queryFile);
        return buffer.toString();
    }

    @Override
    public void kill() {
        if (this.runner != null) {
            this.runner.kill();
        }
    }

    @Override
    public void setPath(String path) throws IllegalArgumentException {
        if (this.isCorrectVersion(path)) {
            verifytapath = path;
            Preferences.getInstance().setVerifytaLocation(verifytapath);
        } else {
            this.messenger.displayErrorMessage("The specified version of the file verifyta is too old.\n\nGet the latest development version of UPPAAL from \nwww.uppaal.org.", "Verifyta Error");
        }
    }

    @Override
    public boolean supportsStats() {
        return false;
    }

    @Override
    public String[] getStatsExplanations() {
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public boolean supportsModel(TimedArcPetriNet model, VerificationOptions options) {
        return true;
    }

    @Override
    public boolean supportsQuery(TimedArcPetriNet model, TAPNQuery query, VerificationOptions options) {
        if ((model.hasUrgentTransitions() || model.hasWeights()) && ((VerifytaOptions)options).getReduction() != ReductionOption.COMBI) {
            return false;
        }
        if (query.hasDeadlock()) {
            if (((VerifytaOptions)options).getReduction() != ReductionOption.BROADCAST && ((VerifytaOptions)options).getReduction() != ReductionOption.DEGREE2BROADCAST && ((VerifytaOptions)options).getReduction() != ReductionOption.COMBI) {
                return false;
            }
            if (query.getProperty() instanceof TCTLEGNode || query.getProperty() instanceof TCTLAFNode) {
                return false;
            }
            if (model.hasInhibitorArcs()) {
                return false;
            }
        }
        return options.traceOption() != TAPNQuery.TraceOption.SOME || !((VerifytaOptions)options).symmetry();
    }

    @Override
    public VerificationResult<TimedArcPetriNetTrace> verify(VerificationOptions options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, DataLayer guiModel, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        if (!model.value1().isDegree2() && new HasDeadlockVisitor().hasDeadLock(query.getProperty())) {
            throw new UnsupportedModelException("\nBecause the query contains a deadlock proposition, the selected engine\nsupports only nets where transitions have at most two input places.");
        }
        if (!this.supportsModel(model.value1(), options)) {
            throw new UnsupportedModelException("Verifyta does not support the given model.");
        }
        if (!this.supportsQuery(model.value1(), query, options)) {
            throw new UnsupportedQueryException("Verifyta does not support the given query.");
        }
        UppaalExporter exporter = new UppaalExporter();
        ExportedModel exportedModel = exporter.export(model.value1(), query, ((VerifytaOptions)options).getReduction(), ((VerifytaOptions)options).symmetry());
        if (exportedModel == null) {
            this.messenger.displayErrorMessage("There was an error exporting the model");
        }
        return this.verify(options, model.value1(), exportedModel, query);
    }

    @Override
    public VerificationResult<TimedArcPetriNetTrace> verifyManually(String options, Tuple<TimedArcPetriNet, NameMapping> model, TAPNQuery query, net.tapaal.gui.petrinet.verification.TAPNQuery dataLayerQuery, TAPNLens lens) throws Exception {
        return null;
    }

    private VerificationResult<TimedArcPetriNetTrace> verify(VerificationOptions options, TimedArcPetriNet model, ExportedModel exportedModel, TAPNQuery query) {
        this.runner = new ProcessRunner(verifytapath, this.createArgumentString(exportedModel.modelFile(), exportedModel.queryFile(), options));
        this.runner.run();
        if (this.runner.error()) {
            return null;
        }
        String errorOutput = this.readOutput(this.runner.errorOutput());
        String standardOutput = this.readOutput(this.runner.standardOutput());
        QueryResult queryResult = this.parseQueryResult(standardOutput, query);
        if (queryResult == null) {
            return new VerificationResult<TimedArcPetriNetTrace>(errorOutput + System.getProperty("line.separator") + standardOutput, this.runner.getRunningTime());
        }
        TimedArcPetriNetTrace tapnTrace = this.parseTrace(errorOutput, options, model, exportedModel, query, queryResult);
        return new VerificationResult<TimedArcPetriNetTrace>(queryResult, tapnTrace, this.runner.getRunningTime(), standardOutput + "\n\n" + errorOutput);
    }

    private String readOutput(BufferedReader reader) {
        try {
            if (!reader.ready()) {
                return "";
            }
        }
        catch (IOException e1) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
                buffer.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    private QueryResult parseQueryResult(String output, TAPNQuery query) {
        VerifytaOutputParser outputParser = new VerifytaOutputParser(query);
        return outputParser.parseOutput(output);
    }

    private TimedArcPetriNetTrace parseTrace(String output, VerificationOptions options, TimedArcPetriNet model, ExportedModel exportedModel, TAPNQuery query, QueryResult queryResult) {
        TimedArcPetriNetTrace tapnTrace = null;
        VerifytaTraceParser traceParser = new VerifytaTraceParser();
        UppaalTrace trace = traceParser.parseTrace(new BufferedReader(new StringReader(output)), (VerifytaOptions)options);
        if (trace == null) {
            if (options.traceOption() != TAPNQuery.TraceOption.NONE) {
                if (query.getProperty() instanceof TCTLEFNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAGNode && queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLEGNode && !queryResult.isQuerySatisfied() || query.getProperty() instanceof TCTLAFNode && queryResult.isQuerySatisfied()) {
                    return null;
                }
                this.messenger.displayErrorMessage("UPPAAL could not generate the requested trace for the model. Try another trace option.");
            }
        } else if (exportedModel.namingScheme() == null) {
            this.messenger.displayErrorMessage("Traces are currently not supported on the chosen translation");
        } else {
            tapnTrace = this.interpretTimedTrace(model, exportedModel, trace);
        }
        return tapnTrace;
    }

    private TimedArcPetriNetTrace interpretTimedTrace(TimedArcPetriNet model, ExportedModel exportedModel, UppaalTrace trace) {
        VerifytaTraceInterpreter traceIntepreter = new VerifytaTraceInterpreter(model, exportedModel.namingScheme());
        return traceIntepreter.interpretTrace(trace);
    }

    public static void reset() {
        verifytapath = "";
        Preferences.getInstance().setVerifytaLocation(null);
    }

    @Override
    public boolean useDiscreteSemantics() {
        return false;
    }
}

