/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.NTA.trace.TraceToken;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTimeDelayStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTimedTransitionStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import dk.aau.cs.model.tapn.simulation.TimedTAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.UntimedTAPNNetworkTrace;
import java.util.ArrayList;

public class TraceConverter {
    private final TAPNNetworkTrace trace;
    private final TimedArcPetriNetNetwork tapnNetwork;

    public TraceConverter(TAPNNetworkTrace trace, TimedArcPetriNetNetwork tapnNetwork) {
        this.trace = trace;
        this.tapnNetwork = tapnNetwork;
    }

    public TAPNNetworkTrace convert() {
        if (this.trace instanceof UntimedTAPNNetworkTrace) {
            return this.decomposeUntimedTrace();
        }
        return this.decomposeTimedTrace();
    }

    private TAPNNetworkTrace decomposeUntimedTrace() {
        UntimedTAPNNetworkTrace decomposedTrace = new UntimedTAPNNetworkTrace();
        for (TAPNNetworkTraceStep action : this.trace) {
            decomposedTrace.add((TAPNNetworkTimedTransitionStep)this.decomposeAction(action));
        }
        return decomposedTrace;
    }

    private TAPNNetworkTrace decomposeTimedTrace() {
        TimedTAPNNetworkTrace decomposedTrace = new TimedTAPNNetworkTrace(((TimedTAPNNetworkTrace)this.trace).getLoopToIndex());
        decomposedTrace.setTraceType(((TimedTAPNNetworkTrace)this.trace).getTraceType());
        for (TAPNNetworkTraceStep action : this.trace) {
            TAPNNetworkTraceStep step = this.decomposeAction(action);
            if (step == null) continue;
            decomposedTrace.add(step);
        }
        return decomposedTrace;
    }

    private TAPNNetworkTraceStep decomposeAction(TAPNNetworkTraceStep action) {
        TAPNNetworkTraceStep decomposedAction = null;
        if (action instanceof TAPNNetworkTimedTransitionStep) {
            TAPNNetworkTimedTransitionStep transitionFiring = (TAPNNetworkTimedTransitionStep)action;
            decomposedAction = this.decomposeTransitionFiring(transitionFiring);
        } else if (action instanceof TAPNNetworkTimeDelayStep) {
            decomposedAction = new TAPNNetworkTimeDelayStep(((TAPNNetworkTimeDelayStep)action).getDelay());
        }
        return decomposedAction;
    }

    private TAPNNetworkTraceStep decomposeTransitionFiring(TAPNNetworkTimedTransitionStep transitionFiring) {
        TimedTransition transition = transitionFiring.getTransition().isShared() ? this.tapnNetwork.getSharedTransitionByName(transitionFiring.getTransition().name()).transitions().iterator().next() : this.tapnNetwork.getTAPNByName(transitionFiring.getTransition().model().name()).getTransitionByName(transitionFiring.getTransition().name());
        ArrayList<TimedToken> convertedTokens = null;
        convertedTokens = new ArrayList<TimedToken>(transitionFiring.getConsumedTokens().size());
        for (TimedToken token : transitionFiring.getConsumedTokens()) {
            TimedPlace place;
            TimedPlace timedPlace = place = token.place().isShared() ? this.tapnNetwork.getSharedPlaceByName(token.place().name()) : this.tapnNetwork.getTAPNByName(((LocalTimedPlace)token.place()).model().name()).getPlaceByName(token.place().name());
            if (token instanceof TraceToken) {
                convertedTokens.add(new TraceToken(place, token.age(), ((TraceToken)token).isGreaterThanOrEqual(), ColorType.COLORTYPE_DOT.getFirstColor()));
                continue;
            }
            convertedTokens.add(new TimedToken(place, token.age(), ColorType.COLORTYPE_DOT.getFirstColor()));
        }
        return transition == null ? null : new TAPNNetworkTimedTransitionStep(transition, convertedTokens);
    }
}

