/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.NTA.trace.TraceToken;
import dk.aau.cs.model.tapn.LocalTimedMarking;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.ColoredTAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.ColoredTransitionStep;
import dk.aau.cs.model.tapn.simulation.PetriNetStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkColoredTransitionStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTimeDelayStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTimedTransitionStep;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import dk.aau.cs.model.tapn.simulation.TimeDelayStep;
import dk.aau.cs.model.tapn.simulation.TimedArcPetriNetTrace;
import dk.aau.cs.model.tapn.simulation.TimedTAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TimedTransitionStep;
import dk.aau.cs.model.tapn.simulation.UntimedTAPNNetworkTrace;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.NameMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TAPNTraceDecomposer {
    private final TimedArcPetriNetTrace trace;
    private final NameMapping mapping;
    private final TimedArcPetriNetNetwork tapnNetwork;

    public TAPNTraceDecomposer(TimedArcPetriNetTrace trace, TimedArcPetriNetNetwork tapnNetwork, NameMapping mapping) {
        this.trace = trace;
        this.tapnNetwork = tapnNetwork;
        this.mapping = mapping;
    }

    public TAPNNetworkTrace decompose() {
        if (this.trace.isColoredTrace()) {
            return this.decomposeColoredTrace();
        }
        if (!this.trace.isTimedTrace()) {
            return this.decomposeUntimedTrace();
        }
        return this.decomposeTimedTrace();
    }

    private TAPNNetworkTrace decomposeColoredTrace() {
        ColoredTAPNNetworkTrace decomposedTrace = new ColoredTAPNNetworkTrace();
        for (PetriNetStep action : this.trace) {
            decomposedTrace.add(this.decomposeAction(action));
        }
        return decomposedTrace;
    }

    private TAPNNetworkTrace decomposeUntimedTrace() {
        UntimedTAPNNetworkTrace decomposedTrace = new UntimedTAPNNetworkTrace();
        for (PetriNetStep action : this.trace) {
            decomposedTrace.add((TAPNNetworkTimedTransitionStep)this.decomposeAction(action));
        }
        return decomposedTrace;
    }

    private TAPNNetworkTrace decomposeTimedTrace() {
        TimedTAPNNetworkTrace decomposedTrace = new TimedTAPNNetworkTrace(this.trace.getLoopToIndex());
        decomposedTrace.setTraceType(this.trace.getTraceType());
        for (PetriNetStep action : this.trace) {
            decomposedTrace.add(this.decomposeAction(action));
        }
        return decomposedTrace;
    }

    private TAPNNetworkTraceStep decomposeAction(PetriNetStep action) {
        TAPNNetworkTraceStep decomposedAction = null;
        if (action instanceof TimedTransitionStep) {
            TimedTransitionStep transitionFiring = (TimedTransitionStep)action;
            decomposedAction = this.decomposeTransitionFiring(transitionFiring);
        } else if (action instanceof TimeDelayStep) {
            decomposedAction = new TAPNNetworkTimeDelayStep(((TimeDelayStep)action).delay());
        } else if (action instanceof ColoredTransitionStep) {
            decomposedAction = this.decomposeColoredTransitionFiring((ColoredTransitionStep)action);
        } else {
            throw new IllegalArgumentException("Unknown action type: " + String.valueOf(action.getClass()));
        }
        return decomposedAction;
    }

    private TAPNNetworkTraceStep decomposeTransitionFiring(TimedTransitionStep transitionFiring) {
        Tuple<String, String> originalName = this.mapping.map(transitionFiring.transition().name());
        TimedTransition transition = originalName.value1() == null || originalName.value1().isEmpty() ? this.tapnNetwork.getSharedTransitionByName(originalName.value2()).transitions().iterator().next() : this.tapnNetwork.getTAPNByName(originalName.value1()).getTransitionByName(originalName.value2());
        ArrayList<TimedToken> convertedTokens = null;
        if (this.trace.isTimedTrace()) {
            convertedTokens = new ArrayList<TimedToken>(transitionFiring.consumedTokens().size());
            for (TimedToken token : transitionFiring.consumedTokens()) {
                TimedPlace place;
                Tuple<String, String> remappedName = this.mapping.map(token.place().name());
                TimedPlace timedPlace = place = remappedName.value1() == null || remappedName.value1().isEmpty() ? this.tapnNetwork.getSharedPlaceByName(remappedName.value2()) : this.tapnNetwork.getTAPNByName(remappedName.value1()).getPlaceByName(remappedName.value2());
                if (token instanceof TraceToken) {
                    convertedTokens.add(new TraceToken(place, token.age(), ((TraceToken)token).isGreaterThanOrEqual(), ColorType.COLORTYPE_DOT.getFirstColor()));
                    continue;
                }
                convertedTokens.add(new TimedToken(place, token.age(), ColorType.COLORTYPE_DOT.getFirstColor()));
            }
        }
        return new TAPNNetworkTimedTransitionStep(transition, convertedTokens);
    }

    private TAPNNetworkTraceStep decomposeColoredTransitionFiring(ColoredTransitionStep step) {
        Tuple<String, String> originalName = this.mapping.map(step.transition().name());
        TimedTransition transition = originalName.value1() == null || originalName.value1().isEmpty() ? this.tapnNetwork.getSharedTransitionByName(originalName.value2()).transitions().iterator().next() : this.tapnNetwork.getTAPNByName(originalName.value1()).getTransitionByName(originalName.value2());
        LocalTimedMarking newPostMarking = new LocalTimedMarking();
        HashMap<TimedPlace, List<TimedToken>> sharedPlacesToTokensMap = new HashMap<TimedPlace, List<TimedToken>>();
        newPostMarking.setNetworkMarking(this.tapnNetwork.marking());
        for (Map.Entry<TimedPlace, List<TimedToken>> entry : step.getPostMarking().getPlacesToTokensMap().entrySet()) {
            String entryName = entry.getKey().name();
            String originalPlaceName = this.mapping.map(entryName).value2();
            boolean isSharedPlace = entryName.split("_")[0].equals("Shared");
            TimedPlace place = isSharedPlace ? this.tapnNetwork.getSharedPlaceByName(originalPlaceName) : this.tapnNetwork.getTAPNByName(this.mapping.map(entryName).value1()).getPlaceByName(originalPlaceName);
            for (TimedToken token : entry.getValue()) {
                if (place.isShared()) {
                    sharedPlacesToTokensMap.computeIfAbsent(place, k -> new ArrayList()).add(new TimedToken(place, token.age(), token.color()));
                    continue;
                }
                newPostMarking.add(new TimedToken(place, token.age(), token.color()));
            }
        }
        return new TAPNNetworkColoredTransitionStep(transition, step.bindings(), newPostMarking, sharedPlacesToTokensMap);
    }
}

