/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.ReductionStats;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class Stats {
    private final long discovered;
    private long explored;
    private long stored;
    private long configurations;
    private long markings;
    private long edges;
    private long processedEdges;
    private long processedNEdges;
    private long exploredConfigurations;
    private int minExecutionTime;
    private int maxExecutionTime;
    private ArrayList<Tuple<String, Tuple<BigDecimal, Integer>>> coveredMarking;
    private List<Tuple<String, Number>> transitionStats;
    private List<Tuple<String, Number>> placeBoundStats;
    private ReductionStats reductionStats;

    public Stats(long discovered, long explored, long stored, List<Tuple<String, Number>> transitionStats, List<Tuple<String, Number>> placeBoundStats, int minExecutionTime, int maxExecutionTime, ArrayList<Tuple<String, Tuple<BigDecimal, Integer>>> coveredMarking) {
        this(discovered, explored, stored, transitionStats, placeBoundStats, minExecutionTime, maxExecutionTime, coveredMarking, null);
    }

    public Stats(long discovered, long explored, long stored, List<Tuple<String, Number>> transitionStats, List<Tuple<String, Number>> placeBoundStats, int minExecutionTime, int maxExecutionTime, ArrayList<Tuple<String, Tuple<BigDecimal, Integer>>> coveredMarking, ReductionStats reductionStats) {
        this.discovered = discovered;
        this.explored = explored;
        this.stored = stored;
        this.transitionStats = transitionStats;
        this.placeBoundStats = placeBoundStats;
        this.minExecutionTime = minExecutionTime;
        this.maxExecutionTime = maxExecutionTime;
        this.coveredMarking = coveredMarking;
        this.reductionStats = reductionStats;
    }

    public Stats(long discovered, long explored, long stored, List<Tuple<String, Number>> transitionStats, List<Tuple<String, Number>> placeBoundStats) {
        this(discovered, explored, stored, transitionStats, placeBoundStats, -1, -1, null);
    }

    public Stats(long discovered, long explored, long stored, List<Tuple<String, Number>> transitionStats, List<Tuple<String, Number>> placeBoundStats, ReductionStats reductionStats) {
        this(discovered, explored, stored, transitionStats, placeBoundStats, -1, -1, null, reductionStats);
    }

    public Stats(long discovered, long explored, long stored) {
        this(discovered, explored, stored, new ArrayList<Tuple<String, Number>>(), new ArrayList<Tuple<String, Number>>());
    }

    public Stats(long configurations, long markings, long edges, long processedEdges, long processedNEdges, long exploredConfigurations) {
        this.configurations = configurations;
        this.markings = markings;
        this.discovered = markings;
        this.edges = edges;
        this.processedEdges = processedEdges;
        this.processedNEdges = processedNEdges;
        this.exploredConfigurations = exploredConfigurations;
    }

    public Integer transitionsCount() {
        return this.transitionStats.size();
    }

    public Integer placeBoundCount() {
        return this.placeBoundStats.size();
    }

    public Tuple<String, Number> getTransitionStats(int index) {
        return this.transitionStats.get(index);
    }

    public Tuple<String, Number> getPlaceBoundStats(int index) {
        return this.placeBoundStats.get(index);
    }

    public long exploredStates() {
        return this.explored;
    }

    public long discoveredStates() {
        return this.discovered;
    }

    public long storedStates() {
        return this.stored;
    }

    public int minimumExecutionTime() {
        return this.minExecutionTime;
    }

    public int maximumExecutionTime() {
        return this.maxExecutionTime;
    }

    public ReductionStats getReductionStats() {
        return this.reductionStats;
    }

    public long getConfigurations() {
        return this.configurations;
    }

    public long getMarkings() {
        return this.markings;
    }

    public long getEdges() {
        return this.edges;
    }

    public ArrayList<Tuple<String, Tuple<BigDecimal, Integer>>> getCoveredMarking() {
        return this.coveredMarking;
    }

    public String toString() {
        return "Discovered configurations: " + this.discovered + System.getProperty("line.separator") + "Explored configurations: " + this.explored + System.getProperty("line.separator") + "Stored configurations: " + this.stored;
    }
}

