/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import dk.aau.cs.verification.observations.Observation;
import java.util.ArrayList;
import java.util.List;

public class SMCSettings {
    public int timeBound;
    public int stepBound;
    public float falsePositives;
    public float falseNegatives;
    public float indifferenceWidth;
    public float confidence;
    public float estimationIntervalWidth;
    public boolean compareToFloat;
    public float geqThan;
    private long numericPrecision;
    private List<Observation> observations;

    public static SMCSettings Default() {
        SMCSettings settings = new SMCSettings();
        settings.timeBound = 1000;
        settings.stepBound = Integer.MAX_VALUE;
        settings.falsePositives = 0.01f;
        settings.falseNegatives = 0.01f;
        settings.indifferenceWidth = 0.05f;
        settings.confidence = 0.95f;
        settings.estimationIntervalWidth = 0.05f;
        settings.compareToFloat = false;
        settings.geqThan = 0.5f;
        settings.setNumericPrecision(5L);
        settings.setObservations(new ArrayList<Observation>());
        return settings;
    }

    public int chernoffHoeffdingBound() {
        double bound = Math.log(2.0 / (double)(1.0f - this.confidence)) / (2.0 * Math.pow(this.estimationIntervalWidth, 2.0));
        return (int)Math.ceil(bound);
    }

    public float precisionFromRuns(int runsNeeded) {
        return (float)Math.sqrt(Math.log(2.0 / (double)(1.0f - this.confidence)) / (2.0 * (double)runsNeeded));
    }

    public void setTimeBound(int timeBound) {
        this.timeBound = timeBound;
    }

    public void setStepBound(int stepBound) {
        this.stepBound = stepBound;
    }

    public void setNumericPrecision(long precision) {
        this.numericPrecision = precision;
    }

    public int getTimeBound() {
        return this.timeBound;
    }

    public int getStepBound() {
        return this.stepBound;
    }

    public long getNumericPrecision() {
        return this.numericPrecision;
    }

    public void setObservations(List<Observation> observations) {
        this.observations = observations;
    }

    public List<Observation> getObservations() {
        return this.observations;
    }
}

