/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.verification;

import com.sun.jna.Platform;
import dk.aau.cs.debug.Logger;
import dk.aau.cs.util.MemoryMonitor;
import dk.aau.cs.verification.BufferDrain;
import dk.aau.cs.verification.ModelChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;

public class ProcessRunner {
    private final String file;
    private final String arguments;
    private long runningTime = 0L;
    private Process process;
    private BufferedReader bufferedReaderStdout;
    private BufferedReader bufferedReaderStderr;
    private boolean error = false;

    public ProcessRunner(String file, String arguments, ModelChecker modelChecker) {
        if (file == null || file.isEmpty()) {
            if (modelChecker == null) {
                throw new IllegalArgumentException("file");
            }
            modelChecker.setup();
        }
        this.file = file;
        this.arguments = arguments;
    }

    public ProcessRunner(String file, String arguments) {
        this(file, arguments, null);
    }

    public long getRunningTime() {
        return this.runningTime;
    }

    public BufferedReader standardOutput() {
        return this.bufferedReaderStdout;
    }

    public BufferedReader errorOutput() {
        return this.bufferedReaderStderr;
    }

    public boolean error() {
        return this.error;
    }

    public void kill() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void run() {
        long startTimeMs = 0L;
        long endTimeMs = 0L;
        startTimeMs = System.currentTimeMillis();
        try {
            if (Platform.isWindows()) {
                Logger.log("Running: \"" + this.file + "\" " + this.arguments);
            } else {
                Logger.log("Running: " + this.file + " " + this.arguments);
            }
            this.process = Runtime.getRuntime().exec(this.getCmdArray());
            MemoryMonitor.attach(this.process);
        }
        catch (IOException e1) {
            this.error = true;
            return;
        }
        BufferDrain stdout = new BufferDrain(new BufferedReader(new InputStreamReader(this.process.getInputStream())));
        BufferDrain stderr = new BufferDrain(new BufferedReader(new InputStreamReader(this.process.getErrorStream())));
        stdout.start();
        stderr.start();
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            this.error = true;
            return;
        }
        endTimeMs = System.currentTimeMillis();
        try {
            stdout.join();
            stderr.join();
        }
        catch (InterruptedException e) {
            this.error = true;
            return;
        }
        this.bufferedReaderStdout = new BufferedReader(new StringReader(stdout.getString()));
        this.bufferedReaderStderr = new BufferedReader(new StringReader(stderr.getString()));
        this.runningTime = endTimeMs - startTimeMs;
    }

    private String[] getCmdArray() {
        String[] argSplit = this.arguments.split("\\s+");
        String[] cmdArray = new String[1 + argSplit.length];
        cmdArray[0] = this.file;
        System.arraycopy(argSplit, 0, cmdArray, 1, argSplit.length);
        return cmdArray;
    }
}

