/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.util;

import dk.aau.cs.util.Require;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pipe.gui.TAPAALGUI;

public class NameTransformer {
    private boolean hasConformed = false;

    public String transform(String name) {
        String transformedName = name;
        transformedName = transformedName.replaceAll("\\s+|-", "_");
        transformedName = transformedName.replace("*", "star");
        transformedName = transformedName.replace("/", "slash");
        transformedName = transformedName.replace("+", "plus");
        transformedName = transformedName.replace("-", "minus");
        Require.that(transformedName.matches("[a-zA-Z][_a-zA-Z0-9]*"), "Name: " + name + " does not obey the regex pattern [a-zA-Z][_a-zA-Z0-9]*, and could not be transformed automatically");
        if (!this.hasConformed && !transformedName.equals(name)) {
            this.hasConformed = true;
            SwingUtilities.invokeLater(() -> {
                StringBuilder message = new StringBuilder();
                message.append("Some names were incompatible with TAPAAL, and have\n");
                message.append("been transformed to the pattern [a-zA-Z][_a-zA-Z0-9]*");
                JOptionPane.showMessageDialog(TAPAALGUI.getApp(), message.toString(), "Warning", 2);
            });
        }
        return transformedName;
    }
}

