/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.translations.tapn;

import dk.aau.cs.TCTL.visitors.BroadcastTranslationQueryVisitor;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.NTA.Edge;
import dk.aau.cs.model.NTA.Location;
import dk.aau.cs.model.NTA.NTA;
import dk.aau.cs.model.NTA.StandardUPPAALQuery;
import dk.aau.cs.model.NTA.TimedAutomaton;
import dk.aau.cs.model.NTA.UPPAALQuery;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.translations.Degree2Converter;
import dk.aau.cs.translations.Degree2Pairing;
import dk.aau.cs.translations.ModelTranslator;
import dk.aau.cs.translations.TranslationNamingScheme;
import dk.aau.cs.translations.tapn.TAPNToConservativeTAPNConverter;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.util.UnsupportedQueryException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Degree2BroadcastTranslation
implements ModelTranslator<TimedArcPetriNet, TAPNQuery, NTA, UPPAALQuery> {
    private static final String DEG2_SUFFIX = "_deg2";
    private static final String DEG1_SUFFIX = "_single";
    private static final String PLOCK = "P_lock";
    protected static final String P_CAPACITY = "_BOTTOM_";
    private static final String TOKEN_TEMPLATE_NAME = "Token";
    private static final String CONTROL_TEMPLATE_NAME = "Control";
    private static final String ID_TYPE = "id_t";
    private static final String ID_PARAMETER_NAME = "id";
    protected static final String CLOCK_NAME = "x";
    private static final String COUNTER_NAME = "count%1$d";
    private static final String COUNTER_UPDATE = "%1$s%2$s";
    private static final String TEST_CHANNEL = "%1$s_test%2$s";
    private static final String INIT_CHANNEL = "c%1$d%2$s";
    protected static final String T_I_IN_FORMAT = "%1$s_%2$d_in";
    protected static final String T_MAX_FORMAT = "%1$s_%2$d";
    protected static final String P_T_IN_FORMAT = "P_%1$s_%2$d_in";
    protected static final String LOCK_BOOL = "lock";
    private final Hashtable<String, Location> namesToLocations = new Hashtable();
    private final Hashtable<TimedInputArc, String> inputArcsToCounters = new Hashtable();
    private final Hashtable<TimedInhibitorArc, String> inhibitorArcsToCounters = new Hashtable();
    private final Hashtable<TransportArc, String> transportArcsToCounters = new Hashtable();
    private final Hashtable<String, Hashtable<String, String>> arcGuards = new Hashtable();
    private List<TimedTransition> retainedTransitions;
    private int numberOfInitChannels = 0;
    protected int extraTokens = 0;
    private int largestPresetSize = 0;
    protected final boolean useSymmetry;

    public Degree2BroadcastTranslation(boolean useSymmetry) {
        this.useSymmetry = useSymmetry;
    }

    @Override
    public Tuple<NTA, UPPAALQuery> translate(TimedArcPetriNet model, TAPNQuery query) throws Exception {
        if (!this.supportsModel(model)) {
            throw new UnsupportedModelException("Degree 2 Broadcast Translation does not support the given model.");
        }
        if (!this.supportsQuery(model, query)) {
            throw new UnsupportedQueryException("Degree 2 Broadcast Translation does not support the given query.");
        }
        this.extraTokens = query.getExtraTokens();
        NTA nta = this.transformModel(model);
        UPPAALQuery uppaalQuery = this.transformQuery(query, model);
        return new Tuple<NTA, UPPAALQuery>(nta, uppaalQuery);
    }

    protected NTA transformModel(TimedArcPetriNet model) throws Exception {
        if (model.marking().size() + this.extraTokens == 0) {
            LocalTimedPlace extraPlace = new LocalTimedPlace("EXTRA3242342_234765");
            model.add(extraPlace);
            model.addToken(new TimedToken(extraPlace, ColorType.COLORTYPE_DOT.getFirstColor()));
        }
        this.clearArcMappings();
        this.arcGuards.clear();
        this.clearLocationMappings();
        this.numberOfInitChannels = 0;
        this.largestPresetSize = 0;
        TimedArcPetriNet conservativeModel = null;
        TimedArcPetriNet degree2Model = null;
        try {
            TAPNToConservativeTAPNConverter conservativeConverter = new TAPNToConservativeTAPNConverter();
            conservativeModel = conservativeConverter.makeConservative(model);
            Degree2Converter converter = new Degree2Converter();
            degree2Model = converter.transformModel(conservativeModel);
            this.retainedTransitions = converter.getRetainedTransitions();
        }
        catch (Exception e) {
            return null;
        }
        NTA nta = new NTA();
        if (this.useSymmetry || degree2Model.marking().size() + this.extraTokens == 0) {
            TimedAutomaton ta = this.createTokenAutomaton(degree2Model, conservativeModel, null);
            this.createInitializationTransitionsForTokenAutomata(degree2Model, ta);
            ta.setName(TOKEN_TEMPLATE_NAME);
            ta.setInitLocation(this.getLocationByName(P_CAPACITY));
            if (this.useSymmetry) {
                ta.setParameters("const id_t id");
            }
            nta.addTimedAutomaton(ta);
        } else {
            int j = 0;
            for (TimedPlace p : degree2Model.places()) {
                for (TimedToken token : degree2Model.marking().getTokensFor(p)) {
                    if (token.place().name().equals(PLOCK)) continue;
                    this.clearLocationMappings();
                    this.clearArcMappings();
                    TimedAutomaton ta = this.createTokenAutomaton(degree2Model, conservativeModel, token);
                    ta.setName(TOKEN_TEMPLATE_NAME + j);
                    ta.setInitLocation(this.getLocationByName(token.place().name()));
                    nta.addTimedAutomaton(ta);
                    ++j;
                }
            }
            TimedPlace bottom = degree2Model.getPlaceByName(P_CAPACITY);
            for (int i = 0; i < this.extraTokens; ++i) {
                this.clearLocationMappings();
                this.clearArcMappings();
                TimedAutomaton tokenTemplate = this.createTokenAutomaton(degree2Model, conservativeModel, new TimedToken(bottom, ColorType.COLORTYPE_DOT.getFirstColor()));
                tokenTemplate.setInitLocation(this.getLocationByName(P_CAPACITY));
                nta.addTimedAutomaton(tokenTemplate);
                tokenTemplate.setName(TOKEN_TEMPLATE_NAME + (degree2Model.marking().size() - 1 + i));
            }
        }
        nta.addTimedAutomaton(this.createControlAutomaton(degree2Model, conservativeModel));
        nta.setSystemDeclarations(this.createSystemDeclaration(degree2Model.marking().size()));
        nta.setGlobalDeclarations(this.createGlobalDeclarations(degree2Model, conservativeModel));
        return nta;
    }

    private String createSystemDeclaration(int tokensInModel) {
        if (this.useSymmetry || tokensInModel + this.extraTokens == 1) {
            return "system Control,Token;";
        }
        StringBuilder builder = new StringBuilder("system ");
        builder.append(CONTROL_TEMPLATE_NAME);
        for (int i = 0; i < this.extraTokens + tokensInModel - 1; ++i) {
            builder.append(", ");
            builder.append(TOKEN_TEMPLATE_NAME);
            builder.append(i);
        }
        builder.append(';');
        return builder.toString();
    }

    protected String createGlobalDeclarations(TimedArcPetriNet degree2Net, TimedArcPetriNet originalModel) {
        StringBuilder builder = new StringBuilder();
        if (this.useSymmetry) {
            builder.append("const int N = ");
            builder.append(degree2Net.marking().size() + this.extraTokens - 1);
            builder.append(";\n");
            builder.append("typedef ");
            builder.append("scalar[N] ");
            builder.append(ID_TYPE);
            builder.append(";\n");
            for (int i = 0; i < this.numberOfInitChannels; ++i) {
                builder.append("chan ");
                builder.append(String.format(INIT_CHANNEL, i, ""));
                builder.append(";\n");
            }
        }
        for (TimedTransition t : degree2Net.transitions()) {
            if (t.presetSizeWithoutInhibitorArcs() == 0 && !t.hasInhibitorArcs()) continue;
            if (this.isTransitionDegree1(t)) {
                builder.append("broadcast chan ");
                builder.append(t.name() + DEG1_SUFFIX);
                builder.append(";\n");
                continue;
            }
            if (this.retainedTransitions.contains(t)) {
                builder.append("chan ");
                builder.append(t.name() + DEG2_SUFFIX);
                builder.append(";\n");
                continue;
            }
            builder.append("chan ");
            builder.append(t.name());
            builder.append(";\n");
        }
        for (TimedTransition t : originalModel.transitions()) {
            if ((t.presetSizeWithoutInhibitorArcs() == 0 || this.isTransitionDegree1(t)) && !t.hasInhibitorArcs() || this.isTransitionDegree2(t) && !t.hasInhibitorArcs()) continue;
            builder.append("broadcast chan ");
            builder.append(String.format(TEST_CHANNEL, t.name(), ""));
            builder.append(";\n");
        }
        for (int i = 0; i < this.largestPresetSize; ++i) {
            builder.append("bool ");
            builder.append(String.format(COUNTER_NAME, i));
            builder.append(";\n");
        }
        builder.append("bool ");
        builder.append(LOCK_BOOL);
        builder.append("= false;\n");
        return builder.toString();
    }

    private boolean isTransitionDegree1(TimedTransition t) {
        return t.presetSizeWithoutInhibitorArcs() == 1 && t.postsetSize() == 1;
    }

    private boolean isTransitionDegree2(TimedTransition t) {
        return t.presetSizeWithoutInhibitorArcs() == 2 && t.postsetSize() == 2;
    }

    protected String convertInvariant(TimedPlace place) {
        Object inv = "";
        TimeInvariant invariant = place.invariant();
        if (!invariant.equals(TimeInvariant.LESS_THAN_INFINITY)) {
            inv = "x " + invariant.toString(false);
        }
        return inv;
    }

    protected Location getLocationByName(String name) {
        return this.namesToLocations.get(name);
    }

    protected void addLocationMapping(String name, Location location) {
        this.namesToLocations.put(name, location);
    }

    protected void clearLocationMappings() {
        this.namesToLocations.clear();
    }

    private void clearArcMappings() {
        this.inputArcsToCounters.clear();
        this.inhibitorArcsToCounters.clear();
        this.transportArcsToCounters.clear();
    }

    private TimedAutomaton createControlAutomaton(TimedArcPetriNet degree2Net, TimedArcPetriNet model) {
        TimedAutomaton control = new TimedAutomaton();
        this.createInitialLocationsForControlAutomaton(degree2Net, control);
        this.createEdgesForControlAutomaton(degree2Net, model, control);
        control.setName(CONTROL_TEMPLATE_NAME);
        if (this.useSymmetry) {
            Location initial = this.createInitializationTransitionsForControlAutomaton(degree2Net, control);
            control.setInitLocation(initial);
        } else {
            control.setInitLocation(this.getLocationByName(PLOCK));
        }
        return control;
    }

    private Location createInitializationTransitionsForControlAutomaton(TimedArcPetriNet degree2Net, TimedAutomaton control) {
        if (degree2Net.marking().size() == 1) {
            return this.getLocationByName(PLOCK);
        }
        Location first = new Location("", "");
        first.setCommitted(true);
        control.addLocation(first);
        Location prev = first;
        for (int i = 0; i < degree2Net.marking().size() - 2; ++i) {
            Location l = new Location("", "");
            l.setCommitted(true);
            control.addLocation(l);
            Edge e = new Edge(prev, l, "", String.format(INIT_CHANNEL, i, "!"), "");
            control.addTransition(e);
            prev = l;
        }
        Edge e = new Edge(prev, this.getLocationByName(PLOCK), "", String.format(INIT_CHANNEL, degree2Net.marking().size() - 2, "!"), "");
        control.addTransition(e);
        return first;
    }

    private void createEdgesForControlAutomaton(TimedArcPetriNet degree2Net, TimedArcPetriNet originalModel, TimedAutomaton control) {
        for (TimedTransition transition : degree2Net.transitions()) {
            if (this.retainedTransitions.contains(transition)) continue;
            Degree2Pairing pairing = new Degree2Pairing(transition);
            for (TimedInputArc inputArc : transition.getInputArcs()) {
                if (inputArc.source().name().equals(PLOCK) || !this.isPartOfLockTemplate(inputArc.source().name())) continue;
                Edge e = new Edge(this.getLocationByName(inputArc.source().name()), this.getLocationByName(pairing.getOutputArcFor(inputArc).destination().name()), "", transition.name() + "!", "");
                control.addTransition(e);
            }
        }
        for (TimedTransition transition : originalModel.transitions()) {
            Edge second;
            if ((this.isTransitionDegree1(transition) || this.isTransitionDegree2(transition)) && !transition.hasInhibitorArcs()) continue;
            Location ptest = new Location("", this.createInvariantForControl(transition));
            ptest.setCommitted(true);
            control.addLocation(ptest);
            Edge first = new Edge(this.getLocationByName(PLOCK), ptest, "", String.format(TEST_CHANNEL, transition.name(), "!"), "");
            control.addTransition(first);
            if (transition.presetSizeWithoutInhibitorArcs() != 1) {
                second = new Edge(ptest, this.getLocationByName(String.format(P_T_IN_FORMAT, transition.name(), 1)), "", String.format("%1$s_%2$d_in%3$s", transition.name(), 1, "!"), this.createResetExpressionForControl(transition));
                control.addTransition(second);
                continue;
            }
            second = new Edge(ptest, this.getLocationByName(PLOCK), "", String.format("%1$s_%2$d%3$s", transition.name(), 1, "!"), this.createResetExpressionForControl(transition));
            control.addTransition(second);
        }
    }

    private void createInitialLocationsForControlAutomaton(TimedArcPetriNet degree2Net, TimedAutomaton ta) {
        for (TimedPlace place : degree2Net.places()) {
            if (!this.isPartOfLockTemplate(place.name())) continue;
            Location l = new Location(place.name(), "");
            if (!place.name().equals(PLOCK)) {
                l.setCommitted(true);
            }
            ta.addLocation(l);
            this.addLocationMapping(place.name(), l);
        }
    }

    private TimedAutomaton createTokenAutomaton(TimedArcPetriNet degree2Net, TimedArcPetriNet originalModel, TimedToken token) throws Exception {
        TimedAutomaton tokenTA = new TimedAutomaton();
        this.createInitialLocationsForTokenAutomata(degree2Net, tokenTA);
        this.createEdgesForTokenAutomata(degree2Net, tokenTA);
        this.createTestingEdgesForTokenAutomata(originalModel, tokenTA);
        tokenTA.setDeclarations(this.createLocalDeclarations());
        return tokenTA;
    }

    protected String createLocalDeclarations() {
        return "clock x;";
    }

    private void createInitializationTransitionsForTokenAutomata(TimedArcPetriNet degree2Net, TimedAutomaton ta) {
        int j = 0;
        for (TimedPlace p : degree2Net.places()) {
            for (int i = 0; i < p.numberOfTokens(); ++i) {
                if (p.name().equals(PLOCK) || p.name().equals(P_CAPACITY)) continue;
                Edge e = new Edge(this.getLocationByName(P_CAPACITY), this.getLocationByName(p.name()), "", String.format(INIT_CHANNEL, j, "?"), "");
                ta.addTransition(e);
                ++this.numberOfInitChannels;
                ++j;
            }
        }
    }

    private void createEdgesForTokenAutomata(TimedArcPetriNet degree2Net, TimedAutomaton token) {
        for (TimedTransition transition : degree2Net.transitions()) {
            Edge e;
            String guard;
            if (transition.presetSizeWithoutInhibitorArcs() == 0 && !transition.hasInhibitorArcs()) continue;
            Degree2Pairing pairing = new Degree2Pairing(transition);
            if (this.retainedTransitions.contains(transition)) {
                boolean first = true;
                String suffix = this.isTransitionDegree1(transition) ? DEG1_SUFFIX : DEG2_SUFFIX;
                for (TimedInputArc inputArc : transition.getInputArcs()) {
                    if (this.isPartOfLockTemplate(inputArc.source().name())) continue;
                    TimedOutputArc outputArc = pairing.getOutputArcFor(inputArc);
                    String guard2 = this.createTransitionGuardWithLock(inputArc, outputArc.destination(), false);
                    Edge e2 = new Edge(this.getLocationByName(inputArc.source().name()), this.getLocationByName(outputArc.destination().name()), guard2, transition.name() + suffix + (first ? "!" : "?"), this.createResetExpressionForNormalArc());
                    token.addTransition(e2);
                    this.saveGuard(transition.name(), inputArc.source().name(), guard2);
                    first = false;
                }
                for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
                    String guard3 = this.createTransitionGuardWithLock(transArc, transArc.destination(), true);
                    Edge e3 = new Edge(this.getLocationByName(transArc.source().name()), this.getLocationByName(transArc.destination().name()), guard3, transition.name() + suffix + (first ? "!" : "?"), "");
                    token.addTransition(e3);
                    this.saveGuard(transition.name(), transArc.source().name(), guard3);
                    first = false;
                }
                continue;
            }
            for (TimedInputArc inputArc : transition.getInputArcs()) {
                if (this.isPartOfLockTemplate(inputArc.source().name())) continue;
                guard = this.convertGuard(inputArc.interval());
                e = new Edge(this.getLocationByName(inputArc.source().name()), this.getLocationByName(pairing.getOutputArcFor(inputArc).destination().name()), guard, transition.name() + "?", this.createResetExpressionForNormalArc());
                token.addTransition(e);
                this.saveGuard(transition.name(), inputArc.source().name(), guard);
            }
            for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
                guard = "";
                try {
                    TimeInterval newGuard = transArc.interval().intersect(transArc.destination().invariant());
                    guard = this.convertGuard(newGuard);
                }
                catch (Exception e4) {
                    guard = "false";
                }
                e = new Edge(this.getLocationByName(transArc.source().name()), this.getLocationByName(transArc.destination().name()), guard, transition.name() + "?", "");
                token.addTransition(e);
                this.saveGuard(transition.name(), transArc.source().name(), guard);
            }
        }
    }

    private void saveGuard(String transitionName, String inputPlaceName, String guard) {
        String originalTransitionName = this.getOriginalTransitionName(transitionName);
        if (originalTransitionName != null && !originalTransitionName.isEmpty()) {
            if (!this.arcGuards.containsKey(originalTransitionName)) {
                this.arcGuards.put(originalTransitionName, new Hashtable());
            }
            this.arcGuards.get(originalTransitionName).put(inputPlaceName, guard);
        }
    }

    private String getOriginalTransitionName(String name) {
        Pattern pattern = Pattern.compile("^([a-zA-Z_][a-zA-Z0-9_]*)_([0-9]*(?:_in)?)$");
        Matcher matcher = pattern.matcher(name);
        if (!matcher.find()) {
            return null;
        }
        return matcher.group(1);
    }

    private void createTestingEdgesForTokenAutomata(TimedArcPetriNet originalModel, TimedAutomaton ta) throws Exception {
        for (TimedTransition transition : originalModel.transitions()) {
            Edge e;
            String guard;
            String counter;
            String source;
            int size = transition.presetSizeWithoutInhibitorArcs() + transition.getInhibitorArcs().size();
            if (size > this.largestPresetSize) {
                this.largestPresetSize = size;
            }
            if (size == 0 || (this.isTransitionDegree1(transition) || this.isTransitionDegree2(transition)) && !transition.hasInhibitorArcs()) continue;
            int i = 0;
            for (TimedInputArc inputArc : transition.getInputArcs()) {
                source = inputArc.source().name();
                counter = String.format(COUNTER_NAME, i);
                this.inputArcsToCounters.put(inputArc, counter);
                guard = this.arcGuards.get(transition.name()).get(source);
                if (guard == null && source.equals(P_CAPACITY)) {
                    guard = "";
                } else if (guard == null) {
                    throw new Exception("guard was not precomputed");
                }
                e = new Edge(this.getLocationByName(source), this.getLocationByName(source), guard, String.format(TEST_CHANNEL, transition.name(), "?"), String.format(COUNTER_UPDATE, counter, "= true"));
                ta.addTransition(e);
                ++i;
            }
            for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
                source = transArc.source().name();
                counter = String.format(COUNTER_NAME, i);
                this.transportArcsToCounters.put(transArc, counter);
                guard = this.arcGuards.get(transition.name()).get(source);
                if (guard == null && source.equals(P_CAPACITY)) {
                    guard = "";
                } else if (guard == null) {
                    throw new Exception("guard was not precomputed");
                }
                e = new Edge(this.getLocationByName(source), this.getLocationByName(source), guard, String.format(TEST_CHANNEL, transition.name(), "?"), String.format(COUNTER_UPDATE, counter, "= true"));
                ta.addTransition(e);
                ++i;
            }
            for (TimedInhibitorArc inhibArc : transition.getInhibitorArcs()) {
                source = inhibArc.source().name();
                counter = String.format(COUNTER_NAME, i);
                this.inhibitorArcsToCounters.put(inhibArc, counter);
                Edge e2 = new Edge(this.getLocationByName(source), this.getLocationByName(source), this.convertGuard(inhibArc.interval()), String.format(TEST_CHANNEL, inhibArc.destination().name(), "?"), String.format(COUNTER_UPDATE, counter, "=true"));
                ta.addTransition(e2);
                ++i;
            }
        }
    }

    private void createInitialLocationsForTokenAutomata(TimedArcPetriNet degree2Net, TimedAutomaton ta) {
        for (TimedPlace place : degree2Net.places()) {
            if (this.isPartOfLockTemplate(place.name())) continue;
            Location l = new Location(place.name(), this.convertInvariant(place));
            ta.addLocation(l);
            this.addLocationMapping(place.name(), l);
        }
    }

    private String createInvariantForControl(TimedTransition transition) {
        return this.createBooleanExpressionForControl(transition, "==", "==");
    }

    private String createBooleanExpressionForControl(TimedTransition transition, String comparison, String inhibComparison) {
        String counter;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (TimedInputArc presetArc : transition.getInputArcs()) {
            if (!first) {
                builder.append(" && ");
            }
            counter = this.inputArcsToCounters.get(presetArc);
            builder.append(counter);
            builder.append(comparison);
            builder.append("true");
            first = false;
        }
        for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
            if (!first) {
                builder.append(" && ");
            }
            counter = this.transportArcsToCounters.get(transArc);
            builder.append(counter);
            builder.append(comparison);
            builder.append("true");
            first = false;
        }
        for (TimedInhibitorArc inhib : transition.getInhibitorArcs()) {
            if (!first) {
                builder.append(" && ");
            }
            counter = this.inhibitorArcsToCounters.get(inhib);
            builder.append(counter);
            builder.append(inhibComparison);
            builder.append("false");
        }
        return builder.toString();
    }

    private String createResetExpressionForControl(TimedTransition transition) {
        String counter;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (TimedInputArc presetArc : transition.getInputArcs()) {
            if (!first) {
                builder.append(", ");
            }
            counter = this.inputArcsToCounters.get(presetArc);
            builder.append(counter);
            builder.append(":=false");
            first = false;
        }
        for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
            if (!first) {
                builder.append(", ");
            }
            counter = this.transportArcsToCounters.get(transArc);
            builder.append(counter);
            builder.append(":=false");
            first = false;
        }
        for (TimedInhibitorArc inhib : transition.getInhibitorArcs()) {
            if (!first) {
                builder.append(", ");
            }
            counter = this.inhibitorArcsToCounters.get(inhib);
            builder.append(counter);
            builder.append(":=false");
            first = false;
        }
        return builder.toString();
    }

    protected String createTransitionGuardWithLock(TimedInputArc inputArc, TimedPlace targetPlace, boolean isTransportArc) {
        Object guard = this.convertGuard(inputArc.interval());
        guard = guard == null || ((String)guard).isEmpty() ? "lock == 0" : (String)guard + " && lock == 0";
        return guard;
    }

    private String convertGuard(TimeInterval interval) {
        if (interval.equals(TimeInterval.ZERO_INF)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean lowerBoundAdded = false;
        if (interval.lowerBound().value() != 0 || !interval.isLowerBoundNonStrict()) {
            builder.append(CLOCK_NAME);
            if (interval.isLowerBoundNonStrict()) {
                builder.append(" >= ");
            } else {
                builder.append(" > ");
            }
            builder.append(interval.lowerBound().value());
            lowerBoundAdded = true;
        }
        if (!interval.upperBound().equals(Bound.Infinity)) {
            if (lowerBoundAdded) {
                builder.append(" && ");
            }
            builder.append(CLOCK_NAME);
            if (interval.isUpperBoundNonStrict()) {
                builder.append(" <= ");
            } else {
                builder.append(" < ");
            }
            builder.append(interval.upperBound().value());
        }
        return builder.toString();
    }

    private String createTransitionGuardWithLock(TransportArc transArc, TimedPlace targetPlace, boolean isTransportArc) {
        Object guard = "";
        try {
            TimeInterval newGuard = transArc.interval().intersect(targetPlace.invariant());
            guard = this.convertGuard(newGuard);
        }
        catch (Exception e) {
            guard = "false";
        }
        guard = guard == null || ((String)guard).isEmpty() ? "lock == 0" : (String)guard + " && lock == 0";
        return guard;
    }

    private String createResetExpressionForNormalArc() {
        return String.format("%1s := 0", CLOCK_NAME);
    }

    private boolean isPartOfLockTemplate(String name) {
        Pattern pattern = Pattern.compile("^(P_(?:[a-zA-Z][a-zA-Z0-9_]*)_(?:(?:[0-9]*_(?:in|out)|check))|P_lock|P_deadlock)$");
        Matcher matcher = pattern.matcher(name);
        return matcher.find();
    }

    protected UPPAALQuery transformQuery(TAPNQuery tapnQuery, TimedArcPetriNet model) throws Exception {
        BroadcastTranslationQueryVisitor visitor = new BroadcastTranslationQueryVisitor(this.useSymmetry, model.marking().size() + tapnQuery.getExtraTokens());
        return new StandardUPPAALQuery(visitor.getUppaalQueryFor(tapnQuery));
    }

    @Override
    public TranslationNamingScheme namingScheme() {
        return new Degree2BroadcastNamingScheme();
    }

    @Override
    public boolean supportsModel(TimedArcPetriNet model) {
        return !model.hasWeights();
    }

    @Override
    public boolean supportsQuery(TimedArcPetriNet model, TAPNQuery query) {
        return true;
    }

    protected static class Degree2BroadcastNamingScheme
    implements TranslationNamingScheme {
        private static final int NOT_FOUND = -1;
        private final String START_OF_SEQUENCE_PATTERN = "^(\\w+)_(?:test|single|deg2)$";
        private final Pattern startPattern = Pattern.compile("^(\\w+)_(?:test|single|deg2)$");
        private final Pattern testTransitionPattern = Pattern.compile("^(\\w+)_test$");
        private final Pattern ignoredPlacePattern = Pattern.compile("^P_lock|_BOTTOM_|P_hp_\\w+_\\d+$");
        private final TranslationNamingScheme.TransitionTranslation.SequenceInfo seqInfo = TranslationNamingScheme.TransitionTranslation.SequenceInfo.WHOLE;

        protected Degree2BroadcastNamingScheme() {
        }

        @Override
        public TranslationNamingScheme.TransitionTranslation[] interpretTransitionSequence(List<String> firingSequence) {
            ArrayList<TranslationNamingScheme.TransitionTranslation> transitionTranslations = new ArrayList<TranslationNamingScheme.TransitionTranslation>();
            int startIndex = -1;
            String originalTransitionName = null;
            for (int i = 0; i < firingSequence.size(); ++i) {
                String transitionName = firingSequence.get(i);
                Matcher startMatcher = this.startPattern.matcher(transitionName);
                boolean isStartTransition = startMatcher.matches();
                if (!isStartTransition) continue;
                if (startIndex != -1) {
                    TranslationNamingScheme.TransitionTranslation transitionTranslation = this.createTransitionTranslation(firingSequence.get(startIndex), startIndex, i - 1, originalTransitionName);
                    transitionTranslations.add(transitionTranslation);
                }
                startIndex = i;
                originalTransitionName = startMatcher.group(1);
            }
            if (startIndex != -1) {
                TranslationNamingScheme.TransitionTranslation transitionTranslation = this.createTransitionTranslation(firingSequence.get(startIndex), startIndex, firingSequence.size() - 1, originalTransitionName);
                transitionTranslations.add(transitionTranslation);
            }
            TranslationNamingScheme.TransitionTranslation[] array = new TranslationNamingScheme.TransitionTranslation[transitionTranslations.size()];
            transitionTranslations.toArray(array);
            return array;
        }

        private TranslationNamingScheme.TransitionTranslation createTransitionTranslation(String startTransition, int startIndex, int endIndex, String originalTransitionName) {
            if (this.testTransitionPattern.matcher(startTransition).matches()) {
                ++startIndex;
            }
            return new TranslationNamingScheme.TransitionTranslation(startIndex, endIndex, originalTransitionName, this.seqInfo);
        }

        @Override
        public String tokenClockName() {
            return Degree2BroadcastTranslation.CLOCK_NAME;
        }

        @Override
        public boolean isIgnoredPlace(String location) {
            Matcher matcher = this.ignoredPlacePattern.matcher(location);
            return matcher.matches();
        }

        @Override
        public boolean isIgnoredAutomata(String automata) {
            return automata.equals(Degree2BroadcastTranslation.CONTROL_TEMPLATE_NAME);
        }
    }
}

