/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.translations.tapn;

import dk.aau.cs.model.NTA.Edge;
import dk.aau.cs.model.NTA.Location;
import dk.aau.cs.model.NTA.NTA;
import dk.aau.cs.model.NTA.SupQuery;
import dk.aau.cs.model.NTA.TimedAutomaton;
import dk.aau.cs.model.NTA.UPPAALQuery;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.translations.tapn.Degree2BroadcastTranslation;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Degree2BroadcastKBoundOptimizeTranslation
extends Degree2BroadcastTranslation {
    private final String usedExtraTokens = "usedExtraTokens";
    private int tokens = 0;
    private final int subtract = 0;
    private final int add = 1;

    public Degree2BroadcastKBoundOptimizeTranslation() {
        super(true);
    }

    @Override
    protected NTA transformModel(TimedArcPetriNet model) throws Exception {
        this.tokens = model.marking().size();
        NTA nta = super.transformModel(model);
        for (TimedAutomaton ta : nta.getTimedAutomata()) {
            if (!ta.getName().equals("Token")) continue;
            this.addKBoundUpdates(ta);
        }
        return nta;
    }

    private void addKBoundUpdates(TimedAutomaton ta) {
        Location pcapacity = this.getLocationByName("_BOTTOM_");
        for (Edge e : ta.getTransitions()) {
            String newUpdate;
            if (e.getSource() == pcapacity && this.isNotInitializationEdge(e) && this.isNotTestingEdge(e)) {
                newUpdate = this.createUpdate(e.getUpdate(), 1);
                e.setUpdate(newUpdate);
                continue;
            }
            if (e.getDestination() != pcapacity || !this.isNotTestingEdge(e)) continue;
            newUpdate = this.createUpdate(e.getUpdate(), 0);
            e.setUpdate(newUpdate);
        }
    }

    private boolean isNotTestingEdge(Edge e) {
        Pattern pattern = Pattern.compile("^[a-zA-Z_/=][a-zA-Z0-9_/=]*_test\\?$");
        Matcher matcher = pattern.matcher(e.getSync());
        return !matcher.find();
    }

    private boolean isNotInitializationEdge(Edge e) {
        Pattern pattern = Pattern.compile("^c(?:\\d)+\\?$");
        Matcher matcher = pattern.matcher(e.getSync());
        return !matcher.find();
    }

    private String createUpdate(String update, int method) {
        Object newUpdate = update;
        if (update != null && !update.isEmpty()) {
            newUpdate = (String)newUpdate + ",";
        }
        newUpdate = (String)newUpdate + "usedExtraTokens";
        newUpdate = method == 1 ? (String)newUpdate + "++" : (String)newUpdate + "--";
        return newUpdate;
    }

    @Override
    protected String createGlobalDeclarations(TimedArcPetriNet degree2Net, TimedArcPetriNet originalModel) {
        StringBuilder builder = new StringBuilder("int[");
        builder.append(-(this.tokens + this.extraTokens));
        builder.append(',');
        builder.append(this.tokens + this.extraTokens);
        builder.append("] ");
        builder.append("usedExtraTokens");
        builder.append(" = 0;\n");
        builder.append(super.createGlobalDeclarations(degree2Net, originalModel));
        return builder.toString();
    }

    @Override
    protected UPPAALQuery transformQuery(TAPNQuery tapnQuery, TimedArcPetriNet model) throws Exception {
        return new SupQuery("usedExtraTokens");
    }
}

