/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.translations.tapn;

import dk.aau.cs.TCTL.visitors.CombiTranslationQueryVisitor;
import dk.aau.cs.model.NTA.Edge;
import dk.aau.cs.model.NTA.Location;
import dk.aau.cs.model.NTA.NTA;
import dk.aau.cs.model.NTA.StandardUPPAALQuery;
import dk.aau.cs.model.NTA.TimedAutomaton;
import dk.aau.cs.model.NTA.UPPAALQuery;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.TAPNQuery;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.translations.ModelTranslator;
import dk.aau.cs.translations.PairingCombi;
import dk.aau.cs.translations.TranslationNamingScheme;
import dk.aau.cs.translations.tapn.TAPNToTimedConservativeTAPNConverter;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.util.UnsupportedModelException;
import dk.aau.cs.util.UnsupportedQueryException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;

public class CombiTranslation
implements ModelTranslator<TimedArcPetriNet, TAPNQuery, NTA, UPPAALQuery> {
    private JRootPane myRootPane;
    private int extraTokens;
    private int largestPresetSize = 0;
    private int initTransitions = 0;
    protected boolean useSymmetry = false;
    protected static final String ID_TYPE = "id_t";
    protected static final String ID_TYPE_NAME = "id";
    protected static final String TOKEN_INTERMEDIATE_PLACE = "%1$s_%2$s_%3$d";
    protected static final String TEST_CHANNEL_NAME = "%1$s_test%2$s";
    protected static final String FIRE_CHANNEL_NAME = "%1$s_fire%2$s";
    protected static final String COUNTER_NAME = "count%1$d";
    protected static final String COUNTER_UPDATE = "%1$s%2$s";
    protected static final String TOKEN_CLOCK_NAME = "x";
    protected static final String PLOCK = "P_lock";
    protected static final String PCAPACITY = "_BOTTOMIN_";
    protected static final String PCAPACITY2 = "_BOTTOMOUT_";
    protected static final String INITIALIZE_CHANNEL = "c%1$d%2$s";
    protected static final String CONTROL_TEMPLATE_NAME = "Control";
    protected static final String TOKEN_TEMPLATE_NAME = "Token";
    protected static final String QUERY_PATTERN = "([a-zA-Z][a-zA-Z0-9_]*) (==|<|<=|>=|>) ([0-9])*";
    protected static final String LOCK_BOOL = "lock";
    protected static final String CAPIN_TOKENS = "CapacityInTokens";
    protected static final String CAPOUT_TOKENS = "CapacityOutTokens";
    protected static int maxDegDif = 0;
    protected static int maxTimeIn = 0;
    protected static int capInTokens;
    private final Hashtable<String, Location> namesToLocations = new Hashtable();
    protected final Hashtable<TimedInputArc, String> inputArcsToCounters = new Hashtable();
    protected final Hashtable<TimedInhibitorArc, String> inhibitorArcsToCounters = new Hashtable();
    protected final Hashtable<TransportArc, String> transportArcsToCounters = new Hashtable();
    protected final Hashtable<String, Boolean> placeNameToTimed = new Hashtable();
    protected final Hashtable<String, Boolean> placeNameToUrgent = new Hashtable();

    public CombiTranslation(boolean useSymmetry) {
        this.useSymmetry = useSymmetry;
    }

    @Override
    public Tuple<NTA, UPPAALQuery> translate(TimedArcPetriNet model, TAPNQuery query) throws Exception {
        if (!this.supportsModel(model)) {
            throw new UnsupportedModelException("Combi Translation does not support the given model.");
        }
        if (!this.supportsQuery(model, query)) {
            throw new UnsupportedQueryException("Combi Translation does not support the given query.");
        }
        this.initPlaceToTimed(model);
        this.initPlaceToUrgent(model);
        this.extraTokens = query.getExtraTokens();
        NTA nta = this.transformModel(model);
        UPPAALQuery uppaalQuery = this.transformQuery(query, model);
        return new Tuple<NTA, UPPAALQuery>(nta, uppaalQuery);
    }

    private NTA transformModel(TimedArcPetriNet model) {
        this.clearLocationMappings();
        this.clearArcMappings();
        this.largestPresetSize = 0;
        this.initTransitions = 0;
        for (TimedPlace p : model.places()) {
            if (!this.placeNameToTimed.get(p.name()).booleanValue() || p.numberOfTokens() <= 0) continue;
            this.initTransitions += p.numberOfTokens();
        }
        TimedArcPetriNet conservativeModel = null;
        try {
            TAPNToTimedConservativeTAPNConverter converter = new TAPNToTimedConservativeTAPNConverter();
            conservativeModel = converter.makeConservative(model, this.placeNameToTimed, this.largestPresetSize);
        }
        catch (Exception e) {
            return null;
        }
        NTA nta = new NTA();
        maxDegDif = this.largestTimedDegreeDifference(conservativeModel);
        maxTimeIn = this.largestTimedDegreeIn(conservativeModel);
        if (maxDegDif != 0 || this.initTransitions != 0 || maxTimeIn != 0) {
            if (this.useSymmetry || conservativeModel.marking().size() + this.extraTokens == 0) {
                capInTokens = model.getNumberOfTokensInNet() + this.extraTokens;
                TimedAutomaton tokenTemplate = this.createTokenTemplate(conservativeModel);
                this.addInitializationStructure(tokenTemplate, conservativeModel);
                tokenTemplate.setName(TOKEN_TEMPLATE_NAME);
                if (this.useSymmetry) {
                    tokenTemplate.setParameters("const id_t id");
                }
                tokenTemplate.setInitLocation(this.getLocationByName(PCAPACITY));
                nta.addTimedAutomaton(tokenTemplate);
            } else {
                capInTokens = model.getNumberOfTokensInNet() + this.extraTokens;
                int j = 0;
                for (TimedPlace p : conservativeModel.places()) {
                    for (TimedToken token : conservativeModel.marking().getTokensFor(p)) {
                        if (!this.placeNameToTimed.get(p.name()).booleanValue()) continue;
                        --capInTokens;
                        this.clearLocationMappings();
                        this.clearArcMappings();
                        TimedAutomaton tokenTemplate = this.createTokenTemplate(conservativeModel);
                        tokenTemplate.setInitLocation(this.getLocationByName(token.place().name()));
                        nta.addTimedAutomaton(tokenTemplate);
                        tokenTemplate.setName(TOKEN_TEMPLATE_NAME + j);
                        ++j;
                    }
                }
                for (int i = j; i < conservativeModel.marking().size() + this.extraTokens; ++i) {
                    this.clearLocationMappings();
                    this.clearArcMappings();
                    TimedAutomaton tokenTemplate = this.createTokenTemplate(conservativeModel);
                    tokenTemplate.setInitLocation(this.getLocationByName(PCAPACITY));
                    nta.addTimedAutomaton(tokenTemplate);
                    tokenTemplate.setName(TOKEN_TEMPLATE_NAME + i);
                }
            }
        }
        TimedAutomaton controlTemplate = this.createControlTemplate(conservativeModel);
        nta.addTimedAutomaton(controlTemplate);
        nta.setSystemDeclarations(this.createSystemDeclaration(conservativeModel.marking().size()));
        String globalDecl = this.createGlobalDeclarations(conservativeModel);
        nta.setGlobalDeclarations(globalDecl);
        return nta;
    }

    private String createSystemDeclaration(int tokensInModel) {
        if (maxDegDif == 0 && this.initTransitions == 0 && maxTimeIn == 0) {
            return "system Control;";
        }
        if (this.useSymmetry || tokensInModel + this.extraTokens == 0) {
            return "system Control,Token;";
        }
        StringBuilder builder = new StringBuilder("system ");
        builder.append(CONTROL_TEMPLATE_NAME);
        for (int i = 0; i < this.extraTokens + tokensInModel; ++i) {
            builder.append(", ");
            builder.append(TOKEN_TEMPLATE_NAME);
            builder.append(i);
        }
        builder.append(';');
        return builder.toString();
    }

    private String createGlobalDeclarations(TimedArcPetriNet model) {
        StringBuilder builder = new StringBuilder();
        builder.append("const int N = ");
        if (maxDegDif == 0 && this.initTransitions == 0 && maxTimeIn == 0) {
            builder.append("0");
        } else if (maxDegDif == 0 && this.initTransitions == 0) {
            builder.append(maxTimeIn);
        } else if (maxDegDif == 0) {
            builder.append(this.initTransitions);
        } else if (model.marking().size() + this.extraTokens == 0) {
            builder.append("1");
        } else {
            builder.append(model.marking().size() + this.extraTokens);
        }
        builder.append(";\n");
        if (this.useSymmetry && (maxDegDif != 0 || this.initTransitions != 0 || maxTimeIn != 0)) {
            builder.append("typedef ");
            builder.append("scalar[N] ");
            builder.append(ID_TYPE);
            builder.append(";\n");
            for (int i = 0; i < this.initTransitions; ++i) {
                builder.append("chan c");
                builder.append(i);
                builder.append(";\n");
            }
        }
        builder.append("urgent broadcast chan __fill_remove_from_trace__;\n");
        for (TimedTransition t : model.transitions()) {
            if (this.timedDegreeIn(t) == 0 && this.timedDegreeOut(t) == 0 && !this.hasTimedInhibitor(t)) {
                if (t.isUrgent()) {
                    builder.append("urgent ");
                }
                builder.append("broadcast chan ");
                builder.append(t.name());
                builder.append(";\n");
                continue;
            }
            if (!(this.timedDegreeIn(t) != 1 && this.timedDegreeOut(t) != 1 || this.timedDegreeIn(t) > 1 || this.timedDegreeOut(t) > 1 || this.hasTimedInhibitor(t))) {
                if (t.isUrgent()) {
                    builder.append("urgent ");
                }
                builder.append("broadcast chan ");
                builder.append(t.name());
                builder.append(";\n");
                continue;
            }
            if (!(this.timedDegreeIn(t) != 2 && this.timedDegreeOut(t) != 2 || this.timedDegreeIn(t) > 2 || this.timedDegreeOut(t) > 2 || this.hasTimedInhibitor(t))) {
                if (t.isUrgent()) {
                    builder.append("urgent ");
                }
                builder.append("chan ");
                builder.append(t.name());
                builder.append(";\n");
                continue;
            }
            if (t.isUrgent()) {
                builder.append("urgent ");
            }
            builder.append("broadcast chan ");
            builder.append(String.format(TEST_CHANNEL_NAME, t.name(), ""));
            builder.append(',');
            builder.append(String.format(FIRE_CHANNEL_NAME, t.name(), ""));
            builder.append(";\n");
        }
        int max = this.largestPresetSize;
        if (max < maxTimeIn) {
            max = maxTimeIn;
        }
        for (int i = 0; i < max; ++i) {
            builder.append("int[0,N] ");
            builder.append(String.format(COUNTER_NAME, i));
            builder.append(";\n");
        }
        for (TimedPlace p : model.places()) {
            if (this.placeNameToTimed.get(p.name()).booleanValue()) continue;
            builder.append("int X_" + p.name());
            builder.append(" = " + p.numberOfTokens());
            builder.append("; \n");
        }
        for (TimedPlace p : model.places()) {
            if (!this.placeNameToUrgent.get(p.name()).booleanValue()) continue;
            builder.append("int Y_" + p.name());
            builder.append(" = " + p.numberOfTokens());
            builder.append("; \n");
        }
        builder.append("int Max = ");
        builder.append(model.getNumberOfTokensInNet() + this.extraTokens);
        builder.append("; \n");
        builder.append("int Active = ");
        builder.append(model.getNumberOfTokensInNet());
        builder.append("; \n");
        builder.append("bool ");
        builder.append(LOCK_BOOL);
        builder.append(" = false;\n");
        builder.append("int ");
        builder.append(CAPOUT_TOKENS);
        builder.append(" = 0;\n");
        builder.append("int ");
        builder.append(CAPIN_TOKENS);
        builder.append(" = ");
        builder.append(capInTokens);
        builder.append("; \n");
        return builder.toString();
    }

    private TimedAutomaton createControlTemplate(TimedArcPetriNet model) {
        TimedAutomaton control = new TimedAutomaton();
        control.setName(CONTROL_TEMPLATE_NAME);
        Location lock = new Location(PLOCK, "");
        control.addLocation(lock);
        if (this.useSymmetry) {
            Location last = this.createInitializationStructure(control);
            if (last == null) {
                control.setInitLocation(lock);
            } else {
                Edge e = new Edge(last, lock, "", String.format(INITIALIZE_CHANNEL, this.initTransitions - 1, "!"), "");
                control.addTransition(e);
            }
        } else {
            control.setInitLocation(lock);
        }
        this.createTransitionSimulations(control, lock, model);
        return control;
    }

    protected void createTransitionSimulations(TimedAutomaton control, Location lock, TimedArcPetriNet model) {
        for (TimedTransition transition : model.transitions()) {
            if ((this.timedDegreeIn(transition) == 2 || this.timedDegreeOut(transition) == 2) && this.timedDegreeIn(transition) <= 2 && this.timedDegreeOut(transition) <= 2 && !this.hasTimedInhibitor(transition) || (this.timedDegreeIn(transition) == 1 || this.timedDegreeOut(transition) == 1) && this.timedDegreeIn(transition) <= 1 && this.timedDegreeOut(transition) <= 1 && !this.hasTimedInhibitor(transition)) continue;
            if (this.timedDegreeIn(transition) == 0 && this.timedDegreeOut(transition) == 0 && !this.hasTimedInhibitor(transition)) {
                Edge fireEdge = new Edge(lock, lock, this.createControlGuard(transition), transition.name() + "!", this.createResetExpressionForControl(transition));
                control.addTransition(fireEdge);
                continue;
            }
            String invariant = this.createInvariantForControl(transition);
            Location tempLoc = new Location("", invariant);
            tempLoc.setCommitted(true);
            control.addLocation(tempLoc);
            Edge testEdge = new Edge(lock, tempLoc, this.createControlGuard(transition), String.format(TEST_CHANNEL_NAME, transition.name(), "!"), this.lockUpdateStatement(true));
            control.addTransition(testEdge);
            Edge fireEdge = new Edge(tempLoc, lock, this.createGuardForControl(transition), String.format(FIRE_CHANNEL_NAME, transition.name(), "!"), this.createResetExpressionForControl(transition));
            control.addTransition(fireEdge);
        }
    }

    private String createControlGuard(TimedTransition transition) {
        StringBuilder builder = new StringBuilder();
        builder.append("(CapacityOutTokens == " + maxDegDif + " || CapacityInTokens == 0)");
        Hashtable<String, Integer> weightTable = new Hashtable<String, Integer>();
        for (TimedInputArc ia : transition.getInputArcs()) {
            if (!this.placeNameToTimed.get(ia.source().name()).booleanValue()) {
                builder.append(" && ");
                builder.append("X_" + ia.source().name());
                builder.append(" >= ");
                builder.append(ia.getWeight().value());
            }
            if (!this.placeNameToUrgent.get(ia.source().name()).booleanValue()) continue;
            String name = ia.source().name();
            if (weightTable.containsKey(name)) {
                int i = (Integer)weightTable.get(name) + ia.getWeight().value();
                weightTable.remove(name);
                weightTable.put(name, i);
                continue;
            }
            weightTable.put(name, ia.getWeight().value());
        }
        for (String place : weightTable.keySet()) {
            builder.append(" && ");
            builder.append("Y_" + place);
            builder.append(" >= ");
            builder.append(weightTable.get(place));
        }
        for (TimedInhibitorArc inhib : transition.getInhibitorArcs()) {
            if (!this.placeNameToTimed.get(inhib.source().name()).booleanValue()) {
                builder.append(" && ");
                builder.append("X_" + inhib.source().name());
                builder.append(" < ");
                builder.append(inhib.getWeight().value());
            }
            if (!this.placeNameToUrgent.get(inhib.source().name()).booleanValue()) continue;
            builder.append(" && ");
            builder.append("Y_" + inhib.source().name());
            builder.append(" < ");
            builder.append(inhib.getWeight().value());
        }
        for (TransportArc trans : transition.getTransportArcsGoingThrough()) {
            if (!this.placeNameToUrgent.get(trans.source().name()).booleanValue()) continue;
            builder.append(" && ");
            builder.append("Y_" + trans.source().name());
            builder.append(" >= ");
            builder.append(trans.getWeight().value());
        }
        int dif = this.degreeDifference(transition);
        if (dif > 0) {
            builder.append(" && ");
            builder.append("Active + " + dif + " <= Max");
        }
        return builder.toString();
    }

    private String lockUpdateStatement(boolean value) {
        return "lock = " + value;
    }

    protected String createResetExpressionForControl(TimedTransition transition) {
        String counter;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (TimedInputArc presetArc : transition.getInputArcs()) {
            if (!first) {
                builder.append(", ");
            }
            if (this.placeNameToTimed.get(presetArc.source().name()).booleanValue()) {
                counter = this.inputArcsToCounters.get(presetArc);
                builder.append(counter);
                builder.append(":=0");
                first = false;
                continue;
            }
            builder.append("X_" + presetArc.source().name());
            builder.append(" = X_" + presetArc.source().name());
            builder.append(" - " + presetArc.getWeight().value());
            first = false;
        }
        for (TimedOutputArc oa : transition.getOutputArcs()) {
            if (this.placeNameToTimed.get(oa.destination().name()).booleanValue()) continue;
            if (!first) {
                builder.append(", ");
            }
            builder.append("X_" + oa.destination().name());
            builder.append(" = X_" + oa.destination().name());
            builder.append(" + " + oa.getWeight().value());
            first = false;
        }
        for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
            if (!first) {
                builder.append(", ");
            }
            counter = this.transportArcsToCounters.get(transArc);
            builder.append(counter);
            builder.append(":=0");
            first = false;
        }
        for (TimedInhibitorArc inhib : transition.getInhibitorArcs()) {
            if (!this.placeNameToTimed.get(inhib.source().name()).booleanValue()) continue;
            if (!first) {
                builder.append(", ");
            }
            counter = this.inhibitorArcsToCounters.get(inhib);
            builder.append(counter);
            builder.append(":=0");
            first = false;
        }
        if (!first) {
            builder.append(", ");
        }
        builder.append(this.lockUpdateStatement(false));
        int dif = this.degreeDifference(transition);
        if (!first) {
            builder.append(" , ");
        }
        builder.append("Active = Active + " + dif);
        return builder.toString();
    }

    private String createGuardForControl(TimedTransition transition) {
        return this.createBooleanExpressionForControl(transition, "==", "<", ">=");
    }

    protected String createInvariantForControl(TimedTransition transition) {
        return this.createBooleanExpressionForControl(transition, ">=", "<", ">=");
    }

    protected String createBooleanExpressionForControl(TimedTransition transition, String comparison, String inhibComparison, String untimedComparison) {
        String counter;
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (TimedInputArc presetArc : transition.getInputArcs()) {
            if (!this.placeNameToTimed.get(presetArc.source().name()).booleanValue()) continue;
            if (!first) {
                builder.append(" && ");
            }
            counter = this.inputArcsToCounters.get(presetArc);
            builder.append(counter);
            builder.append(comparison);
            builder.append(presetArc.getWeight().value());
            first = false;
        }
        for (TransportArc transArc : transition.getTransportArcsGoingThrough()) {
            if (!first) {
                builder.append(" && ");
            }
            counter = this.transportArcsToCounters.get(transArc);
            builder.append(counter);
            builder.append(comparison);
            builder.append(transArc.getWeight().value());
            first = false;
        }
        for (TimedInhibitorArc inhib : transition.getInhibitorArcs()) {
            if (!this.placeNameToTimed.get(inhib.source().name()).booleanValue()) continue;
            if (!first) {
                builder.append(" && ");
            }
            counter = this.inhibitorArcsToCounters.get(inhib);
            builder.append(counter);
            builder.append(inhibComparison);
            builder.append(inhib.getWeight().value());
            first = false;
        }
        return builder.toString();
    }

    private Location createInitializationStructure(TimedAutomaton control) {
        Location previous = null;
        for (int i = 0; i <= this.initTransitions - 1; ++i) {
            Location loc = new Location("", "");
            loc.setCommitted(true);
            control.addLocation(loc);
            if (previous != null) {
                Edge e = new Edge(previous, loc, "", String.format(INITIALIZE_CHANNEL, i - 1, "!"), "");
                control.addTransition(e);
            } else {
                control.setInitLocation(loc);
            }
            previous = loc;
        }
        return previous;
    }

    private TimedAutomaton createTokenTemplate(TimedArcPetriNet model) {
        TimedAutomaton ta = new TimedAutomaton();
        String declarations = this.createLocalDeclarations();
        ta.setDeclarations(declarations);
        this.createTemplateStructure(ta, model);
        if (maxDegDif != 0) {
            Edge move = new Edge(this.getLocationByName(PCAPACITY), this.getLocationByName(PCAPACITY2), "CapacityOutTokens < " + maxDegDif, "__fill_remove_from_trace__!", "CapacityOutTokens++, CapacityInTokens--");
            ta.addTransition(move);
        }
        return ta;
    }

    protected String createLocalDeclarations() {
        return "clock x;";
    }

    protected void addInitializationStructure(TimedAutomaton ta, TimedArcPetriNet model) {
        int j = 0;
        for (TimedPlace p : model.places()) {
            if (p.name().equals(PCAPACITY) || !this.placeNameToTimed.get(p.name()).booleanValue()) continue;
            for (int i = 0; i < p.numberOfTokens(); ++i) {
                Edge initEdge = new Edge(this.getLocationByName(PCAPACITY), this.getLocationByName(p.name()), "", String.format(INITIALIZE_CHANNEL, j, "?"), "CapacityInTokens--");
                ta.addTransition(initEdge);
                ++j;
            }
        }
    }

    private void createTemplateStructure(TimedAutomaton ta, TimedArcPetriNet model) {
        ta.setLocations(this.CreateLocationsFromModel(model));
        if (maxDegDif != 0) {
            Location bot = new Location(PCAPACITY2, "CapacityOutTokens <= " + maxDegDif);
            ta.addLocation(bot);
            this.addLocationMapping(PCAPACITY2, bot);
        }
        for (TimedTransition t : model.transitions()) {
            int presetSize = t.getInhibitorArcs().size() + t.getNumberOfTransportArcsGoingThrough();
            for (TimedInputArc ia : t.getInputArcs()) {
                presetSize += ia.getWeight().value();
            }
            if (presetSize == 0) continue;
            if (presetSize > this.largestPresetSize) {
                this.largestPresetSize = presetSize;
            }
            PairingCombi pairing = new PairingCombi(t, this.placeNameToTimed);
            if (this.timedDegreeIn(t) == 0 && this.timedDegreeOut(t) == 0 && !this.hasTimedInhibitor(t)) continue;
            if (!(this.timedDegreeIn(t) != 1 && this.timedDegreeOut(t) != 1 || this.timedDegreeIn(t) > 1 || this.timedDegreeOut(t) > 1 || this.hasTimedInhibitor(t))) {
                this.createDeg1Structure(ta, t, pairing);
                continue;
            }
            if (!(this.timedDegreeIn(t) != 2 && this.timedDegreeOut(t) != 2 || this.timedDegreeIn(t) > 2 || this.timedDegreeOut(t) > 2 || this.hasTimedInhibitor(t))) {
                this.createDeg2Structure(ta, t, pairing);
                continue;
            }
            this.createStructureForPairing(ta, t, pairing);
        }
    }

    private void createDeg1Structure(TimedAutomaton ta, TimedTransition t, PairingCombi pairing) {
        if (t.getNumberOfTransportArcsGoingThrough() > 0) {
            for (TransportArc transArc : t.getTransportArcsGoingThrough()) {
                String chan = t.name() + "!";
                Edge e = new Edge(this.getLocationByName(transArc.source().name()), this.getLocationByName(transArc.destination().name()), this.createTransitionGuardWithLock(t, transArc, transArc.destination(), true), chan, this.createUpdateDeg2(t, true, true));
                ta.addTransition(e);
            }
        } else {
            for (TimedInputArc inputArc : t.getInputArcs()) {
                if (!this.placeNameToTimed.get(inputArc.source().name()).booleanValue()) continue;
                Location source = this.getLocationByName(inputArc.source().name());
                String chan = t.name() + "!";
                if (inputArc.source().name().equals(PCAPACITY)) {
                    source = this.getLocationByName(PCAPACITY2);
                }
                TimedOutputArc outputArc = pairing.getOutputArcFor(inputArc);
                Edge e = new Edge(source, this.getLocationByName(outputArc.destination().name()), this.createTransitionGuardWithLock(t, inputArc, outputArc, outputArc.destination(), true), chan, this.createUpdateDeg2(t, true, false));
                ta.addTransition(e);
            }
        }
    }

    private void createDeg2Structure(TimedAutomaton ta, TimedTransition t, PairingCombi pairing) {
        int i;
        boolean first = true;
        for (TimedInputArc inputArc : t.getInputArcs()) {
            if (!this.placeNameToTimed.get(inputArc.source().name()).booleanValue()) continue;
            for (i = 0; i < inputArc.getWeight().value(); ++i) {
                Location source = this.getLocationByName(inputArc.source().name());
                if (inputArc.source().name().equals(PCAPACITY)) {
                    source = this.getLocationByName(PCAPACITY2);
                }
                TimedOutputArc outputArc = pairing.getOutputArcFor(inputArc);
                Edge e = new Edge(source, this.getLocationByName(outputArc.destination().name()), this.createTransitionGuardWithLock(t, inputArc, outputArc, outputArc.destination(), first), t.name() + (first ? "!" : "?"), this.createUpdateDeg2(t, first, false));
                ta.addTransition(e);
                first = false;
            }
        }
        for (TransportArc transArc : t.getTransportArcsGoingThrough()) {
            for (i = 0; i < transArc.getWeight().value(); ++i) {
                Edge e = new Edge(this.getLocationByName(transArc.source().name()), this.getLocationByName(transArc.destination().name()), this.createTransitionGuardWithLock(t, transArc, transArc.destination(), first), t.name() + (first ? "!" : "?"), this.createUpdateDeg2(t, first, true));
                ta.addTransition(e);
                first = false;
            }
        }
    }

    private String createUpdateDeg2(TimedTransition t, boolean first, boolean transport) {
        StringBuilder builder = new StringBuilder();
        boolean firstUp = true;
        if (!transport) {
            builder.append(this.createResetExpressionForNormalArc());
            firstUp = false;
        }
        if (first) {
            for (TimedInputArc presetArc : t.getInputArcs()) {
                if (presetArc.source().name().equals(PCAPACITY)) {
                    if (!firstUp) {
                        builder.append(", ");
                    }
                    builder.append(CAPOUT_TOKENS);
                    builder.append(" = CapacityOutTokens");
                    builder.append(" - " + presetArc.getWeight().value());
                    firstUp = false;
                }
                if (!this.placeNameToTimed.get(presetArc.source().name()).booleanValue()) {
                    if (!firstUp) {
                        builder.append(", ");
                    }
                    builder.append("X_" + presetArc.source().name());
                    builder.append(" = X_" + presetArc.source().name());
                    builder.append(" - " + presetArc.getWeight().value());
                    firstUp = false;
                    continue;
                }
                if (!this.placeNameToUrgent.get(presetArc.source().name()).booleanValue() || presetArc.source().name().equals(PCAPACITY2)) continue;
                if (!firstUp) {
                    builder.append(", ");
                }
                builder.append("Y_" + presetArc.source().name());
                builder.append(" = Y_" + presetArc.source().name());
                builder.append(" - " + presetArc.getWeight().value());
                firstUp = false;
            }
            for (TimedOutputArc oa : t.getOutputArcs()) {
                if (oa.destination().name().equals(PCAPACITY)) {
                    if (!firstUp) {
                        builder.append(", ");
                    }
                    builder.append(CAPIN_TOKENS);
                    builder.append(" = CapacityInTokens");
                    builder.append(" + " + oa.getWeight().value());
                    firstUp = false;
                }
                if (!this.placeNameToTimed.get(oa.destination().name()).booleanValue()) {
                    if (!firstUp) {
                        builder.append(" , ");
                    }
                    builder.append("X_" + oa.destination().name());
                    builder.append(" = X_" + oa.destination().name());
                    builder.append(" + " + oa.getWeight().value());
                    firstUp = false;
                    continue;
                }
                if (!this.placeNameToUrgent.get(oa.destination().name()).booleanValue() || oa.destination().name().equals(PCAPACITY)) continue;
                if (!firstUp) {
                    builder.append(" , ");
                }
                builder.append("Y_" + oa.destination().name());
                builder.append(" = Y_" + oa.destination().name());
                builder.append(" + " + oa.getWeight().value());
                firstUp = false;
            }
            for (TransportArc tarc : t.getTransportArcsGoingThrough()) {
                if (this.placeNameToUrgent.get(tarc.source().name()).booleanValue()) {
                    if (!firstUp) {
                        builder.append(", ");
                    }
                    builder.append("Y_" + tarc.source().name());
                    builder.append(" = Y_" + tarc.source().name());
                    builder.append(" - " + tarc.getWeight().value());
                    firstUp = false;
                }
                if (!this.placeNameToUrgent.get(tarc.destination().name()).booleanValue()) continue;
                if (!firstUp) {
                    builder.append(", ");
                }
                builder.append("Y_" + tarc.destination().name());
                builder.append(" = Y_" + tarc.destination().name());
                builder.append(" + " + tarc.getWeight().value());
                firstUp = false;
            }
            int dif = this.degreeDifference(t);
            if (!firstUp) {
                builder.append(" , ");
            }
            builder.append("Active = Active + " + dif);
        }
        return builder.toString();
    }

    private String createTransitionGuardWithLock(TimedTransition t, TransportArc transArc, TimedPlace destination, boolean first) {
        int dif;
        String interval;
        StringBuilder builder = new StringBuilder();
        if (first) {
            builder.append("(CapacityOutTokens == " + maxDegDif + " || CapacityInTokens == 0)");
            builder.append(" && lock == 0");
        }
        try {
            TimeInterval newInterval = transArc.interval().intersect(destination.invariant());
            interval = this.convertGuard(newInterval);
        }
        catch (Exception e) {
            interval = "false";
        }
        if (!interval.equals("")) {
            if (first) {
                builder.append(" && ");
            }
            builder.append(interval);
        }
        if (first) {
            for (TimedInputArc IA : t.getInputArcs()) {
                if (this.placeNameToTimed.get(IA.source().name()).booleanValue()) continue;
                builder.append(" && ");
                builder.append("X_" + IA.source().name());
                builder.append(">=");
                builder.append(IA.getWeight().value());
            }
            for (TimedInhibitorArc inhib : t.getInhibitorArcs()) {
                if (this.placeNameToTimed.get(inhib.source().name()).booleanValue()) continue;
                builder.append(" && ");
                builder.append("X_" + inhib.source().name());
                builder.append("<");
                builder.append(inhib.getWeight().value());
            }
            if (t.isUrgent()) {
                // empty if block
            }
        }
        if (first && (dif = this.degreeDifference(t)) > 0) {
            builder.append(" && ");
            builder.append("Active + " + dif + " <= Max");
        }
        return builder.toString();
    }

    private String createTransitionGuardWithLock(TimedTransition t, TimedInputArc inputArc, TimedOutputArc outputArc, TimedPlace destination, boolean first) {
        int dif;
        String interval;
        StringBuilder builder = new StringBuilder();
        if (first) {
            builder.append("(CapacityOutTokens == " + maxDegDif + " || CapacityInTokens == 0)");
            builder.append(" && lock == 0");
        }
        if (!(interval = this.convertGuard(inputArc.interval())).equals("")) {
            if (first) {
                builder.append(" && ");
            }
            builder.append(interval);
        }
        if (first) {
            for (TimedInputArc IA : t.getInputArcs()) {
                if (this.placeNameToTimed.get(IA.source().name()).booleanValue()) continue;
                builder.append(" && ");
                builder.append("X_" + IA.source().name());
                builder.append(">=");
                builder.append(IA.getWeight().value());
            }
            for (TimedInhibitorArc inhib : t.getInhibitorArcs()) {
                if (this.placeNameToTimed.get(inhib.source().name()).booleanValue()) continue;
                builder.append(" && ");
                builder.append("X_" + inhib.source().name());
                builder.append("<");
                builder.append(inhib.getWeight().value());
            }
        }
        if (first && (dif = this.degreeDifference(t)) > 0) {
            builder.append(" && ");
            builder.append("Active + " + dif + " <= Max");
        }
        return builder.toString();
    }

    protected void createStructureForPairing(TimedAutomaton ta, TimedTransition t, PairingCombi pairing) {
        String counter;
        Location intermediate;
        String locationName;
        String inputPlaceName;
        int i = 0;
        for (TimedInputArc inputArc : t.getInputArcs()) {
            if (!this.placeNameToTimed.get(inputArc.source().name()).booleanValue()) continue;
            inputPlaceName = inputArc.source().name();
            locationName = String.format(TOKEN_INTERMEDIATE_PLACE, inputPlaceName, t.name(), i);
            if (inputPlaceName.equals(PCAPACITY)) {
                locationName = String.format(TOKEN_INTERMEDIATE_PLACE, PCAPACITY2, t.name(), i);
            }
            intermediate = new Location(locationName, "");
            intermediate.setCommitted(true);
            ta.addLocation(intermediate);
            this.addLocationMapping(locationName, intermediate);
            counter = String.format(COUNTER_NAME, i);
            this.inputArcsToCounters.put(inputArc, counter);
            this.createTestFireStructure(ta, t, pairing, inputArc.source(), this.convertGuard(inputArc.interval()), pairing.getOutputArcFor(inputArc).destination(), intermediate, counter, false, inputArc.getWeight().value());
            ++i;
        }
        for (TransportArc transArc : t.getTransportArcsGoingThrough()) {
            inputPlaceName = transArc.source().name();
            locationName = String.format(TOKEN_INTERMEDIATE_PLACE, inputPlaceName, t.name(), i);
            if (inputPlaceName.equals(PCAPACITY)) {
                locationName = String.format(TOKEN_INTERMEDIATE_PLACE, PCAPACITY2, t.name(), i);
            }
            intermediate = new Location(locationName, "");
            intermediate.setCommitted(true);
            ta.addLocation(intermediate);
            this.addLocationMapping(locationName, intermediate);
            counter = String.format(COUNTER_NAME, i);
            this.transportArcsToCounters.put(transArc, counter);
            String guard = "";
            if (t.isUrgent() && !transArc.destination().invariant().asIterval().toString().equals("[0,inf)")) {
                JOptionPane.showMessageDialog(this.myRootPane, "There is an invariant on a destination for a transport arc going through an urgent transition. The translation will not consider this. To get the true result remove the invariant or the urgency.", "Error", 0);
            } else {
                try {
                    TimeInterval newInterval = transArc.interval().intersect(transArc.destination().invariant());
                    guard = this.convertGuard(newInterval);
                }
                catch (Exception e) {
                    guard = "false";
                }
            }
            int weight = transArc.getWeight().value();
            this.createTestFireStructure(ta, t, pairing, transArc.source(), guard, transArc.destination(), intermediate, counter, true, weight);
            ++i;
        }
        this.createStructureForInhibitorArcs(ta, t, i);
    }

    private void createTestFireStructure(TimedAutomaton ta, TimedTransition t, PairingCombi pairing, TimedPlace inputPlace, String testTransitionGuard, TimedPlace OutputPlace, Location intermediate, String counter, boolean isTransportArc, int weight) {
        Object update = String.format(COUNTER_UPDATE, counter, "++");
        Location source = this.getLocationByName(inputPlace.name());
        if (inputPlace.name().equals(PCAPACITY)) {
            update = String.format(COUNTER_UPDATE, counter, "++") + ", CapacityOutTokens--";
            source = this.getLocationByName(PCAPACITY2);
        }
        if (this.placeNameToUrgent.get(inputPlace.name()).booleanValue()) {
            update = (String)update + ", Y_" + inputPlace.name() + "--";
        }
        Edge testEdge = new Edge(source, intermediate, testTransitionGuard, String.format(TEST_CHANNEL_NAME, t.name(), "?"), (String)update);
        ta.addTransition(testEdge);
        Object object = update = isTransportArc ? "" : this.createResetExpressionForNormalArc();
        if (OutputPlace.name().equals(PCAPACITY)) {
            Object object2 = update = isTransportArc ? "" : this.createResetExpressionForNormalArc() + ", CapacityInTokens++";
        }
        if (this.placeNameToUrgent.get(OutputPlace.name()).booleanValue()) {
            update = isTransportArc ? (String)update + "Y_" + OutputPlace.name() + "++" : (String)update + ", Y_" + OutputPlace.name() + "++";
        }
        Edge fireEdge = new Edge(intermediate, this.getLocationByName(OutputPlace.name()), "", String.format(FIRE_CHANNEL_NAME, t.name(), "?"), (String)update);
        ta.addTransition(fireEdge);
        String guard = String.format(COUNTER_UPDATE, counter, ">" + weight);
        update = String.format(COUNTER_UPDATE, counter, "--");
        source = this.getLocationByName(inputPlace.name());
        if (inputPlace.name().equals(PCAPACITY)) {
            update = String.format(COUNTER_UPDATE, counter, "--") + ", CapacityOutTokens++";
            source = this.getLocationByName(PCAPACITY2);
        }
        if (this.placeNameToUrgent.get(inputPlace.name()).booleanValue()) {
            update = (String)update + ", Y_" + inputPlace.name() + "++";
        }
        Edge backEdge = new Edge(intermediate, source, guard, "", (String)update);
        ta.addTransition(backEdge);
    }

    protected void createStructureForInhibitorArcs(TimedAutomaton ta, TimedTransition t, int i) {
        for (TimedInhibitorArc inhibArc : t.getInhibitorArcs()) {
            if (!this.placeNameToTimed.get(inhibArc.source().name()).booleanValue()) continue;
            String inputPlace = inhibArc.source().name();
            String counter = String.format(COUNTER_NAME, i);
            this.inhibitorArcsToCounters.put(inhibArc, counter);
            Location location = this.getLocationByName(inputPlace);
            Edge inhibEdge = new Edge(location, location, this.convertGuard(inhibArc.interval()), String.format(TEST_CHANNEL_NAME, t.name(), "?"), String.format(COUNTER_UPDATE, counter, "++"));
            ta.addTransition(inhibEdge);
            ++i;
        }
    }

    private String createResetExpressionForNormalArc() {
        return String.format("%1s := 0", TOKEN_CLOCK_NAME);
    }

    private ArrayList<Location> CreateLocationsFromModel(TimedArcPetriNet model) {
        this.clearLocationMappings();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (TimedPlace p : model.places()) {
            if (!this.placeNameToTimed.get(p.name()).booleanValue()) continue;
            Location l = new Location(p.name(), this.convertInvariant(p));
            locations.add(l);
            this.addLocationMapping(p.name(), l);
        }
        return locations;
    }

    private String convertGuard(TimeInterval interval) {
        if (interval.equals(TimeInterval.ZERO_INF)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean lowerBoundAdded = false;
        if (interval.lowerBound().value() != 0 || !interval.isLowerBoundNonStrict()) {
            builder.append(TOKEN_CLOCK_NAME);
            if (interval.isLowerBoundNonStrict()) {
                builder.append(" >= ");
            } else {
                builder.append(" > ");
            }
            builder.append(interval.lowerBound().value());
            lowerBoundAdded = true;
        }
        if (!interval.upperBound().equals(Bound.Infinity)) {
            if (lowerBoundAdded) {
                builder.append(" && ");
            }
            builder.append(TOKEN_CLOCK_NAME);
            if (interval.isUpperBoundNonStrict()) {
                builder.append(" <= ");
            } else {
                builder.append(" < ");
            }
            builder.append(interval.upperBound().value());
        }
        return builder.toString();
    }

    protected String convertInvariant(TimedPlace p) {
        Object inv = "";
        TimeInvariant invariant = p.invariant();
        if (!invariant.equals(TimeInvariant.LESS_THAN_INFINITY)) {
            inv = "x " + invariant.toString(false);
        }
        return inv;
    }

    protected Location getLocationByName(String name) {
        return this.namesToLocations.get(name);
    }

    protected void addLocationMapping(String name, Location location) {
        this.namesToLocations.put(name, location);
    }

    protected void clearLocationMappings() {
        this.namesToLocations.clear();
    }

    private void clearArcMappings() {
        this.inputArcsToCounters.clear();
        this.inhibitorArcsToCounters.clear();
        this.transportArcsToCounters.clear();
    }

    private UPPAALQuery transformQuery(TAPNQuery tapnQuery, TimedArcPetriNet model) {
        CombiTranslationQueryVisitor visitor = new CombiTranslationQueryVisitor(this.useSymmetry, model.marking().size() + tapnQuery.getExtraTokens(), model, this.placeNameToTimed, maxDegDif, this.initTransitions, maxTimeIn);
        return new StandardUPPAALQuery(visitor.getUppaalQueryFor(tapnQuery));
    }

    @Override
    public TranslationNamingScheme namingScheme() {
        return new BroadcastNamingScheme();
    }

    private void initPlaceToTimed(TimedArcPetriNet model) {
        for (TimedPlace p : model.places()) {
            this.placeNameToTimed.put(p.name(), false);
            if (p.invariant().equals(TimeInvariant.LESS_THAN_INFINITY)) continue;
            this.placeNameToTimed.put(p.name(), true);
        }
        for (TimedTransition t : model.transitions()) {
            for (TransportArc tt : t.getTransportArcsGoingThrough()) {
                this.placeNameToTimed.put(tt.destination().name(), true);
                this.placeNameToTimed.put(tt.source().name(), true);
            }
            for (TimedInputArc ia : t.getInputArcs()) {
                if (ia.interval().equals(TimeInterval.ZERO_INF)) continue;
                this.placeNameToTimed.put(ia.source().name(), true);
            }
        }
        this.placeNameToTimed.put(PCAPACITY, true);
    }

    private void initPlaceToUrgent(TimedArcPetriNet model) {
        for (TimedPlace p : model.places()) {
            this.placeNameToUrgent.put(p.name(), false);
        }
        this.placeNameToUrgent.put(PCAPACITY, false);
        for (TimedTransition t : model.transitions()) {
            if (!t.isUrgent()) continue;
            for (TimedInputArc ia : t.getInputArcs()) {
                if (!this.placeNameToTimed.get(ia.source().name()).booleanValue()) continue;
                this.placeNameToUrgent.put(ia.source().name(), true);
            }
            for (TransportArc trans : t.getTransportArcsGoingThrough()) {
                if (!this.placeNameToTimed.get(trans.source().name()).booleanValue()) continue;
                this.placeNameToUrgent.put(trans.source().name(), true);
            }
            for (TimedInhibitorArc inhib : t.getInhibitorArcs()) {
                if (!this.placeNameToTimed.get(inhib.source().name()).booleanValue()) continue;
                this.placeNameToUrgent.put(inhib.source().name(), true);
            }
        }
    }

    @Override
    public boolean supportsModel(TimedArcPetriNet model) {
        return true;
    }

    @Override
    public boolean supportsQuery(TimedArcPetriNet model, TAPNQuery query) {
        return true;
    }

    public int degreeDifference(TimedTransition t) {
        int inDeg = 0;
        int outDeg = 0;
        for (TimedInputArc presetArc : t.getInputArcs()) {
            if (presetArc.source().name().equals(PCAPACITY)) continue;
            inDeg += presetArc.getWeight().value();
        }
        for (TimedOutputArc postsetArc : t.getOutputArcs()) {
            if (postsetArc.destination().name().equals(PCAPACITY)) continue;
            outDeg += postsetArc.getWeight().value();
        }
        int dif = outDeg - inDeg;
        return dif;
    }

    public int timedDegreeDifference(TimedTransition t) {
        int inDeg = 0;
        int outDeg = 0;
        for (TimedInputArc presetArc : t.getInputArcs()) {
            if (!this.placeNameToTimed.get(presetArc.source().name()).booleanValue() || presetArc.source().name().equals(PCAPACITY)) continue;
            inDeg += presetArc.getWeight().value();
        }
        for (TimedOutputArc postsetArc : t.getOutputArcs()) {
            if (!this.placeNameToTimed.get(postsetArc.destination().name()).booleanValue() || postsetArc.destination().name().equals(PCAPACITY)) continue;
            outDeg += postsetArc.getWeight().value();
        }
        int dif = outDeg - inDeg;
        return dif;
    }

    public int timedDegreeIn(TimedTransition t) {
        int inDeg = 0;
        for (TimedInputArc presetArc : t.getInputArcs()) {
            if (!this.placeNameToTimed.get(presetArc.source().name()).booleanValue() || presetArc.source().name().equals(PCAPACITY)) continue;
            inDeg += presetArc.getWeight().value();
        }
        for (TransportArc tarc : t.getTransportArcsGoingThrough()) {
            inDeg += tarc.getWeight().value();
        }
        return inDeg;
    }

    public int timedDegreeOut(TimedTransition t) {
        int outDeg = 0;
        for (TimedOutputArc postsetArc : t.getOutputArcs()) {
            if (!this.placeNameToTimed.get(postsetArc.destination().name()).booleanValue() || postsetArc.destination().name().equals(PCAPACITY)) continue;
            outDeg += postsetArc.getWeight().value();
        }
        for (TransportArc tarc : t.getTransportArcsGoingThrough()) {
            outDeg += tarc.getWeight().value();
        }
        return outDeg;
    }

    public int largestTimedDegreeDifference(TimedArcPetriNet model) {
        int maxDeg = 0;
        for (TimedTransition transition : model.transitions()) {
            int deg = this.timedDegreeDifference(transition);
            if (deg <= maxDeg) continue;
            maxDeg = deg;
        }
        return maxDeg;
    }

    public int largestTimedDegreeIn(TimedArcPetriNet model) {
        int maxDeg = 0;
        for (TimedTransition transition : model.transitions()) {
            int deg = this.timedDegreeIn(transition);
            if (deg <= maxDeg) continue;
            maxDeg = deg;
        }
        return maxDeg;
    }

    public boolean hasTimedInhibitor(TimedTransition t) {
        if (t.hasInhibitorArcs()) {
            for (TimedInhibitorArc IA : t.getInhibitorArcs()) {
                if (!this.placeNameToTimed.get(IA.source().name()).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    protected static class BroadcastNamingScheme
    implements TranslationNamingScheme {
        private static final int NOT_FOUND = -1;
        private final String TAU = "tau";
        private final String START_OF_SEQUENCE_PATTERN = "^(\\w+?)(_test)?$";
        private final String END_OF_SEQUENCE_PATTERN = "^(\\w+?)_fire$";
        private final Pattern startPattern = Pattern.compile("^(\\w+?)(_test)?$");
        private final Pattern endPattern = Pattern.compile("^(\\w+?)_fire$");
        private final TranslationNamingScheme.TransitionTranslation.SequenceInfo seqInfo = TranslationNamingScheme.TransitionTranslation.SequenceInfo.END;

        protected BroadcastNamingScheme() {
        }

        @Override
        public TranslationNamingScheme.TransitionTranslation[] interpretTransitionSequence(List<String> firingSequence) {
            ArrayList<TranslationNamingScheme.TransitionTranslation> transitionTranslations = new ArrayList<TranslationNamingScheme.TransitionTranslation>();
            int startIndex = 0;
            int endIndex = -1;
            String originalTransitionName = null;
            for (int i = 0; i < firingSequence.size(); ++i) {
                boolean isDegree2Optimization;
                String transitionName = firingSequence.get(i);
                if (this.isInitializationTransition(transitionName)) continue;
                Matcher startMatcher = this.startPattern.matcher(transitionName);
                Matcher endMatcher = this.endPattern.matcher(transitionName);
                boolean isTau = transitionName.equals("tau");
                boolean isEndTransition = endMatcher.matches();
                boolean isStartTransition = !isTau && !isEndTransition && startMatcher.matches();
                boolean bl = isDegree2Optimization = isStartTransition && (startMatcher.group(2) == null || startMatcher.group(2).isEmpty());
                if (isStartTransition) {
                    startIndex = i;
                    originalTransitionName = startMatcher.group(1);
                }
                if (isEndTransition || isDegree2Optimization) {
                    endIndex = i;
                }
                if (endIndex == -1) continue;
                transitionTranslations.add(new TranslationNamingScheme.TransitionTranslation(startIndex, endIndex, originalTransitionName, this.seqInfo));
                endIndex = -1;
                originalTransitionName = null;
            }
            TranslationNamingScheme.TransitionTranslation[] array = new TranslationNamingScheme.TransitionTranslation[transitionTranslations.size()];
            transitionTranslations.toArray(array);
            return array;
        }

        private boolean isInitializationTransition(String transitionName) {
            Pattern pattern = Pattern.compile("^c\\d+$");
            Matcher matcher = pattern.matcher(transitionName);
            return matcher.find();
        }

        public boolean isIgnoredTransition(String string) {
            Pattern pattern = Pattern.compile("^tau|\\w+?_test$");
            Matcher matcher = pattern.matcher(string);
            return matcher.find();
        }

        @Override
        public String tokenClockName() {
            return CombiTranslation.TOKEN_CLOCK_NAME;
        }

        @Override
        public boolean isIgnoredPlace(String location) {
            return location.equals(CombiTranslation.PLOCK) || location.equals(CombiTranslation.PCAPACITY);
        }

        @Override
        public boolean isIgnoredAutomata(String automata) {
            return automata.equals(CombiTranslation.CONTROL_TEMPLATE_NAME);
        }
    }
}

