/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.translations;

import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.translations.Pairing;
import dk.aau.cs.util.Require;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class PairingCombi
extends Pairing {
    private final Hashtable<String, Boolean> placeNameToTimed;

    public PairingCombi(TimedTransition t, Hashtable<String, Boolean> placeNameToTimed) {
        super(t);
        this.placeNameToTimed = placeNameToTimed;
        this.getInputArcToOutputArc();
    }

    @Override
    protected void generatePairing() {
        List<TimedInputArc> inputArcs = this.getTransition().getInputArcs();
        List<TimedOutputArc> outputArcs = this.getTransition().getOutputArcs();
        int presetSize = 0;
        int postsetSize = 0;
        for (TimedInputArc ia : inputArcs) {
            if (!this.placeNameToTimed.get(ia.source().name()).booleanValue()) continue;
            ++presetSize;
        }
        for (TimedOutputArc oa : outputArcs) {
            if (!this.placeNameToTimed.get(oa.destination().name()).booleanValue()) continue;
            ++postsetSize;
        }
        TimedInputArc[] timedInputArcs = new TimedInputArc[presetSize];
        TimedOutputArc[] timedOutputArcs = new TimedOutputArc[postsetSize];
        int in = 0;
        for (TimedInputArc timedInputArc : inputArcs) {
            if (!this.placeNameToTimed.get(timedInputArc.source().name()).booleanValue()) continue;
            timedInputArcs[in] = timedInputArc;
            ++in;
        }
        int out = 0;
        for (TimedOutputArc oa : outputArcs) {
            if (!this.placeNameToTimed.get(oa.destination().name()).booleanValue()) continue;
            timedOutputArcs[out] = oa;
            ++out;
        }
        Require.that(presetSize == postsetSize, "The provided model is not conservative");
        HashMap<String, ArrayList> hashMap = new HashMap<String, ArrayList>();
        for (int i = 0; i < presetSize; ++i) {
            boolean test = false;
            int j = 0;
            if (hashMap.containsKey(timedInputArcs[i].source().name())) {
                for (j = 0; j < ((ArrayList)hashMap.get(timedInputArcs[i].source().name())).size(); ++j) {
                    if (!((Map)((ArrayList)hashMap.get(timedInputArcs[i].source().name())).get(j)).containsKey(timedOutputArcs[i].destination().name())) continue;
                    test = true;
                    break;
                }
            }
            if (test) {
                int prevArc = (Integer)((Map)((ArrayList)hashMap.get(timedInputArcs[i].source().name())).get(j)).get(timedOutputArcs[i].destination().name());
                IntWeight newInWeight = new IntWeight(timedInputArcs[prevArc].getWeight().value() + 1);
                IntWeight newOutWeight = new IntWeight(timedOutputArcs[prevArc].getWeight().value() + 1);
                this.getTransition().removeFromPreset(timedInputArcs[i]);
                this.getTransition().removeFromPostset(timedOutputArcs[i]);
                timedInputArcs[prevArc].setWeight(newInWeight);
                timedOutputArcs[prevArc].setWeight(newOutWeight);
                continue;
            }
            this.add(timedInputArcs[i], timedOutputArcs[i]);
            HashMap<String, Integer> newOutMap = new HashMap<String, Integer>();
            newOutMap.put(timedOutputArcs[i].destination().name(), i);
            ArrayList existing = new ArrayList();
            if (hashMap.containsKey(timedInputArcs[i].source().name())) {
                existing = (ArrayList)hashMap.get(timedInputArcs[i].source().name());
            }
            existing.add(newOutMap);
            hashMap.put(timedInputArcs[i].source().name(), existing);
        }
    }
}

