/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn.simulation;

import dk.aau.cs.model.tapn.simulation.TAPNNetworkTrace;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import dk.aau.cs.verification.VerifyTAPN.TraceType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TimedTAPNNetworkTrace
implements TAPNNetworkTrace {
    private final List<TAPNNetworkTraceStep> steps = new ArrayList<TAPNNetworkTraceStep>();
    TraceType traceType;
    private final int loopToIndex;

    public TimedTAPNNetworkTrace(int loopToIndex) {
        this.loopToIndex = loopToIndex;
    }

    public void add(TAPNNetworkTraceStep step) {
        if (this.steps.size() == this.loopToIndex) {
            step.setLoopStep();
        }
        this.steps.add(step);
    }

    @Override
    @NotNull
    public Iterator<TAPNNetworkTraceStep> iterator() {
        return this.steps.iterator();
    }

    @Override
    public int length() {
        return this.steps.size();
    }

    @Override
    public boolean isConcreteTrace() {
        return true;
    }

    public List<TAPNNetworkTraceStep> getLoopSteps() {
        return this.steps.subList(this.loopToIndex, this.steps.size());
    }

    public List<TAPNNetworkTraceStep> getSteps() {
        return this.steps;
    }

    public int getLoopToIndex() {
        return this.loopToIndex;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setTraceType(TraceType traceType) {
        this.traceType = traceType;
    }
}

