/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn.simulation;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.LocalTimedMarking;
import dk.aau.cs.model.tapn.NetworkMarking;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.TAPNNetworkTraceStep;
import java.util.List;
import java.util.Map;

public class TAPNNetworkColoredTransitionStep
extends TAPNNetworkTraceStep {
    private final TimedTransition transition;
    private final Map<Variable, Color> bindings;
    private final NetworkMarking marking;

    public TAPNNetworkColoredTransitionStep(TimedTransition transition, Map<Variable, Color> bindings, LocalTimedMarking marking, Map<TimedPlace, List<TimedToken>> sharedPlacesToTokensMap) {
        this.transition = transition;
        this.bindings = bindings;
        NetworkMarking networkMarking = marking.getNetworkMarking().clone();
        networkMarking.updateMarking(marking, sharedPlacesToTokensMap);
        this.marking = networkMarking;
    }

    public TAPNNetworkColoredTransitionStep(TimedTransition transition, Map<Variable, Color> bindings, NetworkMarking marking) {
        this.transition = transition;
        this.bindings = bindings;
        this.marking = marking;
    }

    public TimedTransition getTransition() {
        return this.transition;
    }

    public Map<Variable, Color> getBindings() {
        return this.bindings;
    }

    public NetworkMarking getMarking() {
        return this.marking;
    }

    @Override
    public boolean isColoredTransitionStep() {
        return true;
    }

    @Override
    public NetworkMarking performStepFrom(NetworkMarking marking) {
        throw new UnsupportedOperationException("This method is not implemented for TAPNNeworkColoredTransitionStep");
    }

    public String toString() {
        String transitionName = this.formatTransitionName(this.transition);
        Object result = this.isLoopStep() ? this.formatAsLoopStep(transitionName) : transitionName;
        StringBuilder sb = new StringBuilder();
        if (!this.bindings.isEmpty()) {
            sb.append(" [");
            int i = 0;
            for (Map.Entry<Variable, Color> entry : this.bindings.entrySet()) {
                sb.append(entry.getKey().getId()).append("->").append(entry.getValue().getName());
                if (i < this.bindings.size() - 1) {
                    sb.append(",");
                }
                ++i;
            }
            sb.append("]");
        }
        result = (String)result + sb.toString();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TAPNNetworkColoredTransitionStep otherStep = (TAPNNetworkColoredTransitionStep)other;
        if (!this.transition.equals(otherStep.transition)) {
            return false;
        }
        return this.marking.equals(otherStep.marking);
    }

    private String formatTransitionName(TimedTransition transition) {
        return transition.isShared() ? transition.name() : transition.model().name() + "." + transition.name();
    }
}

