/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn.simulation;

import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.RatBound;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.DelayMode;
import dk.aau.cs.util.IntervalOperations;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;

public class RandomDelayMode
implements DelayMode {
    private static RandomDelayMode instance;
    int numberOfDecimals = -1;

    public static RandomDelayMode getInstance() {
        if (instance == null) {
            instance = new RandomDelayMode();
        }
        return instance;
    }

    private RandomDelayMode() {
    }

    @Override
    public BigDecimal GetDelay(TimedTransition transition, TimeInterval dInterval, BigDecimal delayGranularity) {
        BigDecimal result;
        this.setNumberOfDecimalsAccordingToGranularity(delayGranularity);
        BigDecimal lower = IntervalOperations.getRatBound(dInterval.lowerBound()).getBound();
        BigDecimal upper = IntervalOperations.getRatBound(dInterval.upperBound()).getBound();
        if (dInterval.upperBound() instanceof Bound.InfBound) {
            TimeInterval range = new TimeInterval(dInterval.isLowerBoundNonStrict(), new IntBound(0), Bound.Infinity, dInterval.isUpperBoundNonStrict());
            result = this.exponentialDistribution(range, transition);
        } else {
            TimeInterval range = new TimeInterval(dInterval.isLowerBoundNonStrict(), new IntBound(0), new RatBound(upper.subtract(lower)), dInterval.isUpperBoundNonStrict());
            result = this.randomBigDecimal(range);
        }
        result = result.add(lower);
        return result;
    }

    private void setNumberOfDecimalsAccordingToGranularity(BigDecimal granularity) {
        int scale = (granularity = granularity.stripTrailingZeros()).scale();
        if (scale < 0) {
            throw new IllegalArgumentException("The granularity supplied has a negative scale");
        }
        this.numberOfDecimals = scale;
    }

    private BigDecimal randomBigDecimal(TimeInterval range) {
        BigDecimal randFromDouble;
        BigDecimal result;
        BigDecimal maxValue = ((RatBound)range.upperBound()).getBound();
        if (maxValue.equals(BigDecimal.ZERO)) {
            return BigDecimal.ZERO;
        }
        while (!range.isIncluded(result = (randFromDouble = new BigDecimal(Math.random())).multiply(maxValue))) {
        }
        return result.setScale(this.numberOfDecimals, RoundingMode.DOWN);
    }

    private BigDecimal exponentialDistribution(TimeInterval range, TimedTransition transition) {
        BigDecimal result;
        Random r = new Random();
        TimedArcPetriNetNetwork network = transition.model().parentNetwork();
        double biggestConstant = network.biggestConstantInActiveNet();
        double biggestConstantEnabled = network.biggestContantInActiveNetEnabledTransitions();
        double factor = 1.0 / (biggestConstantEnabled * 0.6 + biggestConstant * 0.4);
        if (factor == Double.POSITIVE_INFINITY) {
            factor = 1.6666666666666667;
        }
        do {
            double uniformDistribution = r.nextDouble();
            double number = Math.log(1.0 - uniformDistribution) / (factor * -1.0);
            result = new BigDecimal(number);
        } while (!range.isIncluded(result = result.setScale(this.numberOfDecimals, RoundingMode.DOWN)));
        return result;
    }

    public String toString() {
        return RandomDelayMode.name();
    }

    public static String name() {
        return "Random delay";
    }
}

