/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.tapn.IntWeight;
import dk.aau.cs.model.tapn.RatBound;
import dk.aau.cs.model.tapn.TAPNElement;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.Weight;
import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.Require;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TransportArc
extends TAPNElement {
    private Weight weight;
    private TimedPlace source;
    private final TimedTransition transition;
    private TimedPlace destination;
    private ArcExpression inputExpression;
    private ArcExpression outputExpression;
    private List<ColoredTimeInterval> ctiList = new ArrayList<ColoredTimeInterval>();
    private TimeInterval interval;

    public TransportArc(TimedPlace source, TimedTransition transition, TimedPlace destination, TimeInterval interval) {
        this(source, transition, destination, interval, new IntWeight(1));
    }

    public TransportArc(TimedPlace source, TimedTransition transition, TimedPlace destination, TimeInterval interval, Weight weight) {
        this(source, transition, destination, interval, weight, null, null);
    }

    public TransportArc(TimedPlace source, TimedTransition transition, TimedPlace destination, TimeInterval interval, Weight weight, ArcExpression inputExpression, ArcExpression outputExpression) {
        Require.that(source != null, "The source place cannot be null");
        Require.that(transition != null, "The associated transition cannot be null");
        Require.that(destination != null, "The destination place cannot be null");
        Require.that(!source.isShared() || !transition.isShared(), "You cannot draw an arc between a shared transition and shared place.");
        Require.that(!transition.isShared() || !destination.isShared(), "You cannot draw an arc between a shared transition and shared place.");
        this.source = source;
        this.transition = transition;
        this.destination = destination;
        this.setTimeInterval(interval);
        this.weight = weight;
        if (inputExpression == null) {
            this.createNewInputArcExpression();
        } else {
            this.inputExpression = inputExpression;
        }
        if (outputExpression == null) {
            this.createNewOutputArcExpression();
        } else {
            this.outputExpression = outputExpression;
        }
    }

    public TransportArc(TimedPlace source, TimedTransition transitions, TimedPlace destination) {
        this(source, transitions, destination, TimeInterval.ZERO_INF);
    }

    public Weight getWeight() {
        return this.weight;
    }

    public Weight getWeightValue() {
        return new IntWeight(this.weight.value());
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public TimedPlace source() {
        return this.source;
    }

    public TimedTransition transition() {
        return this.transition;
    }

    public TimedPlace destination() {
        return this.destination;
    }

    public TimeInterval interval() {
        return this.interval;
    }

    public void setTimeInterval(TimeInterval interval) {
        Require.that(interval != null, "A transport arc must have an associated interval");
        this.interval = interval;
    }

    public boolean isEnabled() {
        return this.getElligibleTokens().size() >= this.weight.value();
    }

    public boolean isEnabledBy(TimedToken token) {
        Require.that(this.source.equals(token.place()), "Token must be in the correct place");
        return this.interval.isIncluded(token.age()) && this.destination.invariant().isSatisfied(token.age());
    }

    public List<TimedToken> getElligibleTokens() {
        ArrayList<TimedToken> elligibleTokens = new ArrayList<TimedToken>();
        List<TimedToken> tokens = this.source.tokens();
        for (TimedToken token : tokens) {
            if (!this.isEnabledBy(token)) continue;
            elligibleTokens.add(token);
        }
        return elligibleTokens;
    }

    @Override
    public void delete() {
        if (this.model() != null) {
            this.model().remove(this);
        }
    }

    public TransportArc copy(TimedArcPetriNet tapn) {
        TransportArc ta = new TransportArc(tapn.getPlaceByName(this.source.name()), tapn.getTransitionByName(this.transition.name()), tapn.getPlaceByName(this.destination.name()), this.interval.copy(), this.weight, this.inputExpression.deepCopy(), this.outputExpression.deepCopy());
        ta.setColorTimeIntervals(this.ctiList);
        return ta;
    }

    public void setSource(TimedPlace place) {
        Require.that(place != null, "place cannot be null");
        this.source = place;
    }

    public void setDestination(TimedPlace place) {
        Require.that(place != null, "place cannot be null");
        this.destination = place;
    }

    public ArrayList<TimeInterval> getDEnabledInterval() {
        ArrayList<TimeInterval> result = new ArrayList<TimeInterval>();
        TimeInterval interval = IntervalOperations.intersection(this.interval, this.destination().invariant().asIterval());
        if (interval == null) {
            return result;
        }
        BigDecimal iLow = IntervalOperations.getRatBound(interval.lowerBound()).getBound();
        BigDecimal iHeigh = IntervalOperations.getRatBound(interval.upperBound()).getBound();
        List<TimedToken> sortedTokens = this.source.sortedTokens();
        boolean overrideLowerInclusion = false;
        int i = 0;
        while (i + this.getWeight().value() - 1 < sortedTokens.size()) {
            int j = i + this.getWeight().value() - 1;
            TimedToken oldestToken = sortedTokens.get(i);
            TimedToken youngestToken = sortedTokens.get(j);
            TimeInterval temp = null;
            if (oldestToken.age().compareTo(iHeigh) <= 0 || iHeigh.compareTo(BigDecimal.ZERO) < 0) {
                BigDecimal newLower = iLow.subtract(youngestToken.age(), new MathContext(9));
                if (newLower.compareTo(BigDecimal.ZERO) < 0) {
                    overrideLowerInclusion = true;
                    newLower = BigDecimal.ZERO;
                }
                if (iHeigh.compareTo(BigDecimal.ZERO) >= 0) {
                    BigDecimal newUpper = iHeigh.subtract(oldestToken.age(), new MathContext(9));
                    if (newUpper.compareTo(BigDecimal.ZERO) < 0) {
                        newUpper = BigDecimal.ZERO;
                    }
                    temp = newUpper.compareTo(newLower) == 0 && interval.isLowerBoundNonStrict() && interval.isUpperBoundNonStrict() ? new TimeInterval(true, new RatBound(newLower), new RatBound(newUpper), true) : (newLower.compareTo(newUpper) < 0 ? new TimeInterval(interval.isLowerBoundNonStrict() || overrideLowerInclusion, new RatBound(newLower), new RatBound(newUpper), interval.isUpperBoundNonStrict()) : null);
                } else {
                    temp = new TimeInterval(interval.isLowerBoundNonStrict(), new RatBound(newLower), interval.upperBound(), false);
                }
            }
            if (temp != null) {
                result = IntervalOperations.unionIntervalSequences(List.of(temp), result);
            }
            ++i;
        }
        return result;
    }

    public void createNewInputArcExpression() {
        UserOperatorExpression userOperatorExpression = new UserOperatorExpression(this.source().getColorType().getFirstColor());
        Vector<ColorExpression> vecColorExpr = new Vector<ColorExpression>();
        vecColorExpr.add(userOperatorExpression);
        NumberOfExpression numbExpr = new NumberOfExpression(1, vecColorExpr);
        this.setInputExpression(numbExpr);
        this.setWeight(new IntWeight(1));
    }

    public void createNewOutputArcExpression() {
        UserOperatorExpression userOperatorExpression = new UserOperatorExpression(this.destination().getColorType().getFirstColor());
        Vector<ColorExpression> vecColorExpr = new Vector<ColorExpression>();
        vecColorExpr.add(userOperatorExpression);
        NumberOfExpression numbExpr = new NumberOfExpression(1, vecColorExpr);
        this.setOutputExpression(numbExpr);
        this.setWeight(new IntWeight(1));
    }

    public String toString() {
        return "from " + this.source.name() + " to " + this.destination.name() + " through " + this.transition.name() + " with interval " + this.interval().toString();
    }

    public String fromTo() {
        return "from " + this.source.name() + " to " + this.destination.name() + " through " + this.transition.name();
    }

    public ArcExpression getOutputExpression() {
        return this.outputExpression;
    }

    public void setOutputExpression(ArcExpression outputExpression) {
        this.outputExpression = outputExpression;
    }

    public ArcExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(ArcExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    public List<ColoredTimeInterval> getColorTimeIntervals() {
        return this.ctiList;
    }

    public void setColorTimeIntervals(List<ColoredTimeInterval> ctiList) {
        this.ctiList = ctiList;
    }
}

