/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInterval;
import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.CPN.Variable;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.DoubleProbability;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.Probability;
import dk.aau.cs.model.tapn.SMCDistribution;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TAPNElement;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.event.TimedTransitionEvent;
import dk.aau.cs.model.tapn.event.TimedTransitionListener;
import dk.aau.cs.model.tapn.simulation.FiringMode;
import dk.aau.cs.model.tapn.simulation.RandomFiringMode;
import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.Require;
import dk.aau.cs.verification.TAPNComposer;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pipe.gui.petrinet.animation.Animator;

public class TimedTransition
extends TAPNElement {
    private static final Pattern namePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private String name;
    private final List<TimedOutputArc> postset = new ArrayList<TimedOutputArc>();
    private final List<TimedInputArc> preset = new ArrayList<TimedInputArc>();
    private final List<TransportArc> transportArcsGoingThrough = new ArrayList<TransportArc>();
    private final List<TimedInhibitorArc> inhibitorArcs = new ArrayList<TimedInhibitorArc>();
    private boolean isUrgent = false;
    private boolean isUncontrollable = false;
    private SMCDistribution distribution = SMCDistribution.defaultDistribution();
    private Probability weight = new DoubleProbability(1.0);
    private FiringMode firingMode = new RandomFiringMode();
    private GuardExpression guard;
    private SharedTransition sharedTransition;
    private final List<TimedTransitionListener> listeners = new ArrayList<TimedTransitionListener>();

    public TimedTransition(String name) {
        this(name, false, null);
    }

    public TimedTransition(String name, GuardExpression guard) {
        this(name, false, guard);
    }

    public TimedTransition(String name, boolean isUrgent, GuardExpression guard) {
        this.setName(name);
        this.setUrgent(isUrgent);
        this.guard = guard;
    }

    public TimedTransition(String name, boolean isUrgent, GuardExpression guard, SMCDistribution distribution) {
        this.setName(name);
        this.setUrgent(isUrgent);
        this.setDistribution(distribution);
        this.guard = guard;
    }

    public TimedTransition(String name, boolean isUrgent, GuardExpression guard, SMCDistribution distribution, Probability weight, FiringMode firingMode) {
        this.setName(name);
        this.setUrgent(isUrgent);
        this.setDistribution(distribution);
        this.setWeight(weight);
        this.setFiringMode(firingMode);
        this.guard = guard;
    }

    public void addTimedTransitionListener(TimedTransitionListener listener) {
        Require.that(listener != null, "listener cannot be null");
        this.listeners.add(listener);
    }

    public void removeListener(TimedTransitionListener listener) {
        Require.that(listener != null, "listener cannot be null");
        this.listeners.remove(listener);
    }

    public boolean isUrgent() {
        return this.isUrgent;
    }

    public void setUrgent(boolean value) {
        this.setUrgent(value, true);
    }

    protected void setUrgent(boolean value, boolean cascade) {
        this.isUrgent = value;
        if (this.isUrgent) {
            this.setDistribution(SMCDistribution.urgent());
        }
        if (this.isShared() && cascade) {
            this.sharedTransition.setUrgent(value);
        }
    }

    public boolean isUncontrollable() {
        return this.isUncontrollable;
    }

    public void setUncontrollable(boolean isUncontrollable) {
        this.setUncontrollable(isUncontrollable, true);
    }

    public void setUncontrollable(boolean isUncontrollable, boolean cascade) {
        this.isUncontrollable = isUncontrollable;
        if (this.isShared() && cascade) {
            this.sharedTransition.setUncontrollable(isUncontrollable);
        }
    }

    public SMCDistribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(SMCDistribution distrib) {
        this.setDistribution(distrib, true);
    }

    public void setDistribution(SMCDistribution distrib, boolean cascade) {
        this.distribution = distrib;
        if (this.isShared() && cascade) {
            this.sharedTransition.setDistribution(distrib);
        }
    }

    public Probability getWeight() {
        return this.weight;
    }

    public void setWeight(Probability weight) {
        this.setWeight(weight, true);
    }

    public void setWeight(Probability weight, boolean cascade) {
        this.weight = weight;
        if (this.isShared() && cascade) {
            this.sharedTransition.setWeight(weight);
        }
    }

    public void setFiringMode(FiringMode firingMode) {
        this.firingMode = firingMode;
    }

    public FiringMode getFiringMode() {
        if (this.firingMode == null) {
            this.firingMode = new RandomFiringMode();
        }
        return this.firingMode;
    }

    public boolean hasCustomDistribution() {
        return !this.distribution.equals(SMCDistribution.defaultDistribution());
    }

    public boolean hasUntimedPreset() {
        return this.hasUntimedPreset(true);
    }

    private boolean hasUntimedPreset(boolean cascade) {
        for (TimedInputArc timedInputArc : this.preset) {
            if (!timedInputArc.interval().equals(TimeInterval.ZERO_INF)) {
                return false;
            }
            for (ColoredTimeInterval interval : timedInputArc.getColorTimeIntervals()) {
                if (interval.getInterval().equals(TimeInterval.ZERO_INF.toString())) continue;
                return false;
            }
        }
        for (TransportArc transportArc : this.transportArcsGoingThrough) {
            if (!transportArc.interval().equals(TimeInterval.ZERO_INF)) {
                return false;
            }
            for (ColoredTimeInterval interval : transportArc.getColorTimeIntervals()) {
                if (!interval.getInterval().equals(TimeInterval.ZERO_INF.toString())) continue;
                return false;
            }
        }
        if (cascade && this.isShared()) {
            for (TimedTransition timedTransition : this.sharedTransition.transitions()) {
                if (timedTransition.hasUntimedPreset(false)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isShared() {
        return this.sharedTransition != null;
    }

    public SharedTransition sharedTransition() {
        return this.sharedTransition;
    }

    public void makeShared(SharedTransition sharedTransition) {
        Require.that(sharedTransition != null, "sharedTransition cannot be null");
        if (this.sharedTransition != sharedTransition) {
            this.unshare();
            this.sharedTransition = sharedTransition;
            this.setName(sharedTransition.name());
            this.fireSharedStateChanged();
        }
    }

    public void unshare() {
        if (this.isShared()) {
            this.sharedTransition.unshare(this);
            this.sharedTransition = null;
            this.fireSharedStateChanged();
        }
    }

    public String name() {
        return this.name;
    }

    public void setName(String newName) {
        Require.that(newName != null && !newName.isEmpty(), "A timed transition must have a name");
        Require.that(this.isValid(newName), "The specified name must conform to the pattern [a-zA-Z_][a-zA-Z0-9_]*, Name: " + newName);
        this.name = newName;
        this.fireNameChanged();
    }

    private void fireNameChanged() {
        for (TimedTransitionListener listener : this.listeners) {
            listener.nameChanged(new TimedTransitionEvent(this));
        }
    }

    private void fireSharedStateChanged() {
        for (TimedTransitionListener listener : this.listeners) {
            listener.sharedStateChanged(new TimedTransitionEvent(this));
        }
    }

    private boolean isValid(String newName) {
        return namePattern.matcher(newName).matches();
    }

    public void addToPreset(TimedInputArc arc) {
        Require.that(arc != null, "Cannot add null to preset");
        this.preset.add(arc);
    }

    public void addToPostset(TimedOutputArc arc) {
        Require.that(arc != null, "Cannot add null to postset");
        this.postset.add(arc);
    }

    public void removeFromPreset(TimedInputArc arc) {
        this.preset.remove(arc);
    }

    public void removeFromPostset(TimedOutputArc arc) {
        this.postset.remove(arc);
    }

    public void addTransportArcGoingThrough(TransportArc arc) {
        Require.that(arc != null, "Cannot add null to preset");
        this.transportArcsGoingThrough.add(arc);
    }

    public void removeTransportArcGoingThrough(TransportArc arc) {
        this.transportArcsGoingThrough.remove(arc);
    }

    public void addInhibitorArc(TimedInhibitorArc arc) {
        this.inhibitorArcs.add(arc);
    }

    public void removeInhibitorArc(TimedInhibitorArc arc) {
        this.inhibitorArcs.remove(arc);
    }

    @Override
    public void delete() {
        this.unshare();
        this.model().remove(this);
    }

    public int presetSizeWithoutInhibitorArcs() {
        return this.preset.size() + this.transportArcsGoingThrough.size();
    }

    public int presetSize() {
        return this.preset.size() + this.transportArcsGoingThrough.size() + this.inhibitorArcs.size();
    }

    public int postsetSize() {
        return this.postset.size() + this.transportArcsGoingThrough.size();
    }

    public boolean isDEnabled() {
        TimeInterval dInterval = this.calculateDInterval();
        return dInterval != null;
    }

    public TimeInterval calculateDInterval() {
        ArrayList<TimeInterval> result = this.isShared() ? this.sharedTransition.calculateDInterval() : this.calculateDIntervalAlone();
        for (TimedArcPetriNet model : this.model().parentNetwork().activeTemplates()) {
            for (TimedPlace place : model.places()) {
                if (place.invariant().upperBound() instanceof Bound.InfBound) continue;
                for (TimedToken x : place.tokens()) {
                    result = IntervalOperations.intersectingInterval(result, List.of(place.invariant().subtractToken(x.age())));
                }
            }
        }
        if (Animator.isUrgentTransitionEnabled()) {
            result = IntervalOperations.intersectingInterval(result, List.of(new TimeInterval(true, new IntBound(0), new IntBound(0), true)));
        }
        TimeInterval dInterval = result.isEmpty() ? null : result.get(0);
        return dInterval;
    }

    public ArrayList<TimeInterval> calculateDIntervalAlone() {
        ArrayList<TimeInterval> result = new ArrayList<TimeInterval>();
        result.add(TimeInterval.ZERO_INF);
        for (TimedInputArc timedInputArc : this.getInputArcs()) {
            result = IntervalOperations.intersectingInterval(timedInputArc.getDEnabledInterval(), result);
        }
        for (TransportArc transportArc : this.getTransportArcsGoingThrough()) {
            result = IntervalOperations.intersectingInterval(transportArc.getDEnabledInterval(), result);
        }
        for (TimedInhibitorArc timedInhibitorArc : this.getInhibitorArcs()) {
            result = IntervalOperations.intersectingInterval(timedInhibitorArc.getDEnabledInterval(), result);
        }
        return result;
    }

    public boolean isEnabled() {
        if (this.isShared()) {
            return this.sharedTransition.isEnabled();
        }
        return this.isEnabledAlone();
    }

    public boolean isEnabledAlone() {
        for (TimedInputArc timedInputArc : this.preset) {
            if (timedInputArc.isEnabled()) continue;
            return false;
        }
        for (TransportArc transportArc : this.transportArcsGoingThrough) {
            if (transportArc.isEnabled()) continue;
            return false;
        }
        for (TimedInhibitorArc timedInhibitorArc : this.inhibitorArcs) {
            if (timedInhibitorArc.isEnabled()) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabledBy(List<TimedToken> tokens) {
        int tokensMissing;
        for (TimedInputArc inputArc : this.preset) {
            tokensMissing = inputArc.getWeight().value();
            for (TimedToken token : tokens) {
                if (!inputArc.source().equals(token.place()) || !inputArc.isEnabledBy(token)) continue;
                --tokensMissing;
            }
            if (tokensMissing == 0) continue;
            return false;
        }
        for (TransportArc transportArc : this.transportArcsGoingThrough) {
            tokensMissing = transportArc.getWeight().value();
            for (TimedToken token : tokens) {
                if (!transportArc.source().equals(token.place()) || !transportArc.isEnabledBy(token)) continue;
                --tokensMissing;
            }
            if (tokensMissing == 0) continue;
            return false;
        }
        return true;
    }

    public List<TimedToken> calculateProducedTokensFrom(List<TimedToken> consumedTokens) {
        ArrayList<TimedToken> producedTokens = new ArrayList<TimedToken>();
        for (TimedOutputArc arc : this.postset) {
            for (int i = 0; i < arc.getWeight().value(); ++i) {
                producedTokens.add(new TimedToken(arc.destination(), ColorType.COLORTYPE_DOT.getFirstColor()));
            }
        }
        for (TransportArc transportArc : this.transportArcsGoingThrough) {
            for (TimedToken token : consumedTokens) {
                if (!token.place().equals(transportArc.source())) continue;
                producedTokens.add(new TimedToken(transportArc.destination(), token.age(), ColorType.COLORTYPE_DOT.getFirstColor()));
            }
        }
        return producedTokens;
    }

    public List<TimedToken> calculateConsumedTokens(FiringMode firingMode) {
        List<TimedToken> tokens;
        ArrayList<TimedToken> tokensToConsume = new ArrayList<TimedToken>();
        for (TimedInputArc timedInputArc : this.preset) {
            tokens = firingMode.pickTokensFrom(timedInputArc.getElligibleTokens(), timedInputArc.getWeight().value());
            tokensToConsume.addAll(tokens);
        }
        for (TransportArc transportArc : this.transportArcsGoingThrough) {
            tokens = firingMode.pickTokensFrom(transportArc.getElligibleTokens(), transportArc.getWeight().value());
            tokensToConsume.addAll(tokens);
        }
        return tokensToConsume;
    }

    public boolean hasInhibitorArcs() {
        return this.inhibitorArcs.size() > 0;
    }

    public List<TimedInputArc> getInputArcs() {
        return this.preset;
    }

    public List<TimedOutputArc> getOutputArcs() {
        return this.postset;
    }

    public List<TransportArc> getTransportArcsGoingThrough() {
        return this.transportArcsGoingThrough;
    }

    public int getNumberOfTransportArcsGoingThrough() {
        return this.transportArcsGoingThrough.size();
    }

    public List<TimedInhibitorArc> getInhibitorArcs() {
        return this.inhibitorArcs;
    }

    public TimedTransition copy() {
        if (this.guard == null) {
            return new TimedTransition(this.name, this.isUrgent, null, this.distribution, this.weight, this.firingMode);
        }
        return new TimedTransition(this.name, this.isUrgent, this.guard.copy(), this.distribution, this.weight, this.firingMode);
    }

    public String toString() {
        if (this.model() != null) {
            return this.model().name() + "." + this.name;
        }
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model() == null ? 0 : this.model().hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimedTransition)) {
            return false;
        }
        TimedTransition other = (TimedTransition)obj;
        if (this.model() == null ? other.model() != null : !this.model().equals(other.model())) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean isOrphan() {
        if (this.isShared()) {
            return this.sharedTransition.isOrphan();
        }
        return this.presetSize() == 0 && this.postsetSize() == 0;
    }

    public TimeInterval getdInterval() {
        return this.calculateDInterval();
    }

    public int getLagestAssociatedConstant() {
        Bound max;
        int biggestConstant = -1;
        for (TimedInputArc timedInputArc : this.preset) {
            max = IntervalOperations.getMaxNoInfBound(timedInputArc.interval());
            if (max.value() > biggestConstant) {
                biggestConstant = max.value();
            }
            if (!((max = timedInputArc.source().invariant().upperBound()) instanceof Bound.InfBound) || max.value() <= biggestConstant) continue;
            biggestConstant = max.value();
        }
        for (TransportArc transportArc : this.transportArcsGoingThrough) {
            max = IntervalOperations.getMaxNoInfBound(transportArc.interval());
            if (max.value() > biggestConstant) {
                biggestConstant = max.value();
            }
            if ((max = transportArc.source().invariant().upperBound()) instanceof Bound.InfBound && max.value() > biggestConstant) {
                biggestConstant = max.value();
            }
            if (!((max = transportArc.destination().invariant().upperBound()) instanceof Bound.InfBound) || max.value() <= biggestConstant) continue;
            biggestConstant = max.value();
        }
        return biggestConstant;
    }

    public GuardExpression getGuard() {
        return this.guard;
    }

    public void setGuard(GuardExpression guard) {
        this.setGuard(guard, true);
    }

    public void setGuard(GuardExpression guard, boolean cascade) {
        this.guard = guard;
        if (this.isShared() && cascade) {
            if (guard != null) {
                this.sharedTransition.setGuard(guard.copy());
            } else {
                this.sharedTransition.setGuard(null);
            }
        }
    }

    public String toBindingXmlStr(Map<Variable, Color> bindings, TAPNComposer composer) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element transitionElement = this.toXmlElement(bindings, document, composer);
            document.appendChild(transitionElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.getBuffer().toString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Element toXmlElement(Map<Variable, Color> bindings, Document document, TAPNComposer composer) {
        Element transitionElement = document.createElement("transition");
        transitionElement.setAttribute("id", composer.composedTransitionName(this));
        Element bindingElement = document.createElement("binding");
        if (!bindings.isEmpty()) {
            for (Map.Entry<Variable, Color> binding : bindings.entrySet()) {
                Element variableElement = document.createElement("variable");
                variableElement.setAttribute("id", binding.getKey().getId());
                Element colorElement = document.createElement("color");
                colorElement.setTextContent(binding.getValue().getName());
                variableElement.appendChild(colorElement);
                bindingElement.appendChild(variableElement);
            }
        }
        transitionElement.appendChild(bindingElement);
        return transitionElement;
    }
}

