/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.CPN.Expressions.AddExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedMarking;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.model.tapn.event.TimedPlaceEvent;
import dk.aau.cs.model.tapn.event.TimedPlaceListener;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.Tuple;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public abstract class TimedPlace {
    protected static final Pattern namePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    protected final List<TimedPlaceListener> listeners = new ArrayList<TimedPlaceListener>();
    protected Tuple<PlaceType, Integer> extrapolation = new Tuple<PlaceType, Integer>(PlaceType.Dead, -2);
    protected String name;
    protected TimeInvariant invariant;
    protected TimedMarking currentMarking;
    protected ArcExpression tokensAsExpression;
    private final List<TimedOutputArc> postset = new ArrayList<TimedOutputArc>();
    private final List<TimedInputArc> preset = new ArrayList<TimedInputArc>();
    private final List<TransportArc> transportArcs = new ArrayList<TransportArc>();
    private final List<TimedInhibitorArc> inhibitorArcs = new ArrayList<TimedInhibitorArc>();
    protected int numberOfTokens = 0;

    public abstract ColorType getColorType();

    public abstract List<ColoredTimeInvariant> getCtiList();

    public abstract void setCtiList(List<ColoredTimeInvariant> var1);

    public abstract void setColorType(ColorType var1);

    public abstract boolean isShared();

    public String name() {
        return this.name;
    }

    public void setName(String newName) {
        Require.that(newName != null && !newName.isEmpty(), "A timed place must have a name");
        Require.that(this.isValid(newName) && !newName.equalsIgnoreCase("true") && !newName.equalsIgnoreCase("false"), "The specified name must conform to the pattern [a-zA-Z_][a-zA-Z0-9_]*");
        List<TimedToken> tokens = null;
        if (this.currentMarking != null) {
            if (this.currentMarking.getTokensFor(this).size() != 0) {
                tokens = this.tokens();
                this.currentMarking.removePlaceFromMarking(this);
            }
            this.name = newName;
            if (tokens != null) {
                this.addTokens(tokens);
            }
            this.fireNameChanged();
        } else {
            this.name = newName;
            this.fireNameChanged();
        }
    }

    public TimeInvariant invariant() {
        return this.invariant;
    }

    public List<TimedToken> tokens() {
        return this.currentMarking.getTokensFor(this);
    }

    public int numberOfTokens() {
        return this.numberOfTokens > 0 ? this.numberOfTokens : this.tokens().size();
    }

    public void setNumberOfTokens(int numberOfTokens) {
        this.numberOfTokens = numberOfTokens;
    }

    public void resetNumberOfTokens() {
        this.numberOfTokens = 0;
    }

    public void resetNumberOfTokensColor() {
        this.resetNumberOfTokens();
        this.tokens().clear();
    }

    private void updateNonColoredTokenExpr() {
        if (this.getColorType() == ColorType.COLORTYPE_DOT) {
            Vector<ArcExpression> v = new Vector<ArcExpression>();
            Vector<ColorExpression> ev = new Vector<ColorExpression>();
            ev.add(new UserOperatorExpression(ColorType.COLORTYPE_DOT.getFirstColor()));
            v.add(new NumberOfExpression(this.numberOfTokens(), ev));
            AddExpression tokenExp = new AddExpression(v);
            this.setTokenExpression(tokenExp);
        }
    }

    public void addToken(TimedToken timedToken) {
        Require.that(timedToken != null, "timedToken cannot be null");
        Require.that(timedToken.place().equals(this), "token is located in a different place");
        this.currentMarking.add(timedToken);
        this.updateNonColoredTokenExpr();
        this.fireMarkingChanged();
    }

    public void addTokens(Iterable<TimedToken> tokens) {
        Require.that(tokens != null, "tokens cannot be null");
        for (TimedToken token : tokens) {
            this.currentMarking.add(token);
        }
        this.updateNonColoredTokenExpr();
        this.fireMarkingChanged();
    }

    public void addTokens(int numberOfTokensToAdd) {
        Require.that(this.getColorType().equals(ColorType.COLORTYPE_DOT), "Cannot add a number of tokens of unspecified color to a place which does not have the dot colortype");
        for (int i = 0; i < numberOfTokensToAdd; ++i) {
            this.addToken(new TimedToken(this, BigDecimal.ZERO, ColorType.COLORTYPE_DOT.getFirstColor()));
        }
    }

    public void removeTokens(int numberOfTokensToRemove) {
        Require.that(this.getColorType().equals(ColorType.COLORTYPE_DOT), "Cannot remove a number of tokens of unspecified color from a place which does not have the dot colortype");
        for (int i = 0; i < numberOfTokensToRemove; ++i) {
            this.removeToken();
        }
    }

    public void removeToken() {
        Require.that(this.getColorType().equals(ColorType.COLORTYPE_DOT), "Cannot remove tokens of unspecified color from a place which does not have the dot colortype");
        if (this.numberOfTokens() > 0) {
            this.currentMarking.remove(this.tokens().get(0));
            this.updateNonColoredTokenExpr();
            this.fireMarkingChanged();
        }
    }

    public void updateTokens(Iterable<TimedToken> tokens, ArcExpression expression) {
        this.currentMarking.removePlaceFromMarking(this);
        this.addTokens(tokens);
        this.setTokenExpression(expression);
    }

    public abstract Tuple<PlaceType, Integer> extrapolate();

    public abstract TimedPlace copy();

    public List<TimedToken> sortedTokens() {
        ArrayList<TimedToken> copy = new ArrayList<TimedToken>(this.tokens());
        copy.sort((o1, o2) -> o1.age().compareTo(o2.age()) * -1);
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimedPlace)) {
            return false;
        }
        TimedPlace other = (TimedPlace)obj;
        return this.name() == other.name();
    }

    protected void fireMarkingChanged() {
        for (TimedPlaceListener listener : this.listeners) {
            listener.markingChanged(new TimedPlaceEvent(this));
        }
    }

    protected void fireNameChanged() {
        for (TimedPlaceListener listener : this.listeners) {
            listener.nameChanged(new TimedPlaceEvent(this));
        }
    }

    protected void fireInvariantChanged() {
        for (TimedPlaceListener listener : this.listeners) {
            listener.invariantChanged(new TimedPlaceEvent(this));
        }
    }

    protected boolean isValid(String newName) {
        return namePattern.matcher(newName).matches();
    }

    public void setInvariant(TimeInvariant invariant) {
        Require.that(invariant != null, "invariant must not be null");
        this.invariant = invariant;
        this.fireInvariantChanged();
    }

    public void addTimedPlaceListener(TimedPlaceListener listener) {
        Require.that(listener != null, "Listener cannot be null");
        this.listeners.add(listener);
    }

    public void removeTimedPlaceListener(TimedPlaceListener listener) {
        Require.that(listener != null, "Listener cannot be null");
        this.listeners.remove(listener);
    }

    public void setCurrentMarking(TimedMarking marking) {
        Require.that(marking != null, "marking cannot be null");
        this.currentMarking = marking;
        this.fireMarkingChanged();
    }

    public boolean isOrphan() {
        return this.presetSize() == 0 && this.postsetSize() == 0;
    }

    public void addInputArc(TimedInputArc arc) {
        Require.that(arc != null, "Cannot add null to preset");
        this.preset.add(arc);
    }

    public void addOutputArc(TimedOutputArc arc) {
        Require.that(arc != null, "Cannot add null to postset");
        this.postset.add(arc);
    }

    public void removeInputArc(TimedInputArc arc) {
        this.preset.remove(arc);
    }

    public void removeOutputArc(TimedOutputArc arc) {
        this.postset.remove(arc);
    }

    public void addTransportArc(TransportArc arc) {
        Require.that(arc != null, "Cannot add null to preset");
        this.transportArcs.add(arc);
    }

    public void removeTransportArc(TransportArc arc) {
        this.transportArcs.remove(arc);
    }

    public void addInhibitorArc(TimedInhibitorArc arc) {
        this.inhibitorArcs.add(arc);
    }

    public void removeInhibitorArc(TimedInhibitorArc arc) {
        this.inhibitorArcs.remove(arc);
    }

    public int presetSize() {
        return this.preset.size() + this.transportArcs.size();
    }

    public int postsetSize() {
        return this.postset.size() + this.transportArcs.size() + this.inhibitorArcs.size();
    }

    public void setTokenExpression(ArcExpression newExpression) {
        this.tokensAsExpression = newExpression;
    }

    public void setTokenExpression(ArcExpression colorMarking, ArcExpression newExpression) {
        this.tokensAsExpression = colorMarking != null && colorMarking.toString().contains(".all") || newExpression == null ? colorMarking : newExpression;
    }

    public ArcExpression getTokensAsExpression() {
        return this.tokensAsExpression;
    }

    public ArcExpression getExprWithNewColorType(ColorType colorType) {
        if (this.tokensAsExpression != null) {
            return this.tokensAsExpression.getExprWithNewColorType(colorType);
        }
        return this.tokensAsExpression;
    }

    public static enum PlaceType {
        Standard,
        Invariant,
        Dead;

    }
}

