/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.NumberOfExpression;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.IntBound;
import dk.aau.cs.model.tapn.LocalTimedMarking;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedInhibitorArc;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedMarking;
import dk.aau.cs.model.tapn.TimedOutputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.Require;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TimedArcPetriNet {
    private String name;
    private TimedArcPetriNetNetwork parentNetwork;
    private boolean isActive;
    private boolean checkNames = true;
    private final List<TimedPlace> places = new ArrayList<TimedPlace>();
    private final List<TimedTransition> transitions = new ArrayList<TimedTransition>();
    private final List<TimedInputArc> inputArcs = new ArrayList<TimedInputArc>();
    private final List<TimedOutputArc> outputArcs = new ArrayList<TimedOutputArc>();
    private final List<TimedInhibitorArc> inhibitorArcs = new ArrayList<TimedInhibitorArc>();
    private final List<TransportArc> transportArcs = new ArrayList<TransportArc>();
    private TimedMarking currentMarking = new LocalTimedMarking();

    public TimedArcPetriNet(String name) {
        this.setName(name);
        this.isActive = true;
    }

    public TimedMarking marking() {
        return this.currentMarking;
    }

    public void setParentNetwork(TimedArcPetriNetNetwork network) {
        this.parentNetwork = network;
    }

    public TimedArcPetriNetNetwork parentNetwork() {
        return this.parentNetwork;
    }

    public void add(TimedPlace place) {
        this.add(place, false);
    }

    public void add(TimedPlace place, boolean multiRemove) {
        Require.that(place != null, "Argument must be a non-null place");
        if (!multiRemove) {
            Require.that(!this.isNameUsed(place.name()) || place.isShared() && !this.places.contains(place), "A place or transition with the specified name, " + place.name() + ", already exists in the petri net.");
        }
        if (!place.isShared()) {
            ((LocalTimedPlace)place).setModel(this);
        }
        this.places.add(place);
        place.setCurrentMarking(this.currentMarking);
    }

    public boolean isColored() {
        ExprValues values = new ExprValues();
        for (TimedTransition timedTransition : this.transitions) {
            if (timedTransition.getGuard() == null) continue;
            timedTransition.getGuard().getValues(values);
        }
        for (TimedInputArc timedInputArc : this.inputArcs) {
            if (timedInputArc.getArcExpression() != null) {
                timedInputArc.getArcExpression().getValues(values);
            }
            if (timedInputArc.getColorTimeIntervals().isEmpty()) continue;
            return true;
        }
        for (TimedOutputArc timedOutputArc : this.outputArcs) {
            if (timedOutputArc.getExpression() == null) continue;
            timedOutputArc.getExpression().getValues(values);
        }
        for (TimedInhibitorArc timedInhibitorArc : this.inhibitorArcs) {
            if (timedInhibitorArc.getArcExpression() == null) continue;
            timedInhibitorArc.getArcExpression().getValues(values);
        }
        for (TransportArc transportArc : this.transportArcs) {
            if (!transportArc.getColorTimeIntervals().isEmpty()) {
                return true;
            }
            if (transportArc.getInputExpression() != null) {
                transportArc.getInputExpression().getValues(values);
            }
            if (transportArc.getOutputExpression() == null) continue;
            transportArc.getOutputExpression().getValues(values);
        }
        boolean hasColors = false;
        for (Color color : values.getColors()) {
            if (color.getColorType() == ColorType.COLORTYPE_DOT || color.getColorType().getId().equals("dot")) continue;
            hasColors = true;
            break;
        }
        return hasColors || values.getColorTypes().stream().distinct().count() > 1L || !values.getVariables().isEmpty();
    }

    public boolean isStochastic() {
        for (TimedTransition t : this.transitions) {
            if (!t.hasCustomDistribution()) continue;
            return true;
        }
        return false;
    }

    public void add(TimedTransition transition) {
        Require.that(transition != null, "Argument must be a non-null transition");
        Require.that(!this.isNameUsed(transition.name()) || transition.isShared(), "A place or transition with the specified name, " + transition.name() + ", already exists in the petri net.");
        transition.setModel(this);
        this.transitions.add(transition);
    }

    public void add(TimedInputArc arc) {
        Require.that(arc != null, "Argument must be a non-null input arc.");
        Require.that(!this.checkNames || this.places.contains(arc.source()), "The source place must be part of the petri net.");
        Require.that(!this.checkNames || this.transitions.contains(arc.destination()), "The destination transition must be part of the petri net");
        Require.that(!this.checkNames || !this.inputArcs.contains(arc), "The specified arc is already a part of the petri net.");
        arc.setModel(this);
        this.inputArcs.add(arc);
        arc.source().addInputArc(arc);
        arc.destination().addToPreset(arc);
    }

    public void add(TimedOutputArc arc) {
        Require.that(arc != null, "Argument must be a non-null output arc.");
        Require.that(!this.checkNames || this.places.contains(arc.destination()), "The destination place must be part of the petri net.");
        Require.that(!this.checkNames || this.transitions.contains(arc.source()), "The source transition must be part of the petri net");
        Require.that(!this.checkNames || !this.outputArcs.contains(arc), "The specified arc is already a part of the petri net.");
        arc.setModel(this);
        this.outputArcs.add(arc);
        arc.source().addToPostset(arc);
        arc.destination().addOutputArc(arc);
    }

    public void add(TimedInhibitorArc arc) {
        Require.that(arc != null, "Argument must be a non-null output arc.");
        Require.that(!this.checkNames || this.places.contains(arc.source()), "The source place must be part of the petri net.");
        Require.that(!this.checkNames || this.transitions.contains(arc.destination()), "The destination transition must be part of the petri net");
        Require.that(!this.checkNames || !this.inhibitorArcs.contains(arc), "The specified arc is already a part of the petri net.");
        Require.that(!this.checkNames || !this.hasArcFromPlaceToTransition(arc.source(), arc.destination()), "Cannot have two arcs between the same place and transition");
        arc.setModel(this);
        this.inhibitorArcs.add(arc);
        arc.destination().addInhibitorArc(arc);
        arc.source().addInhibitorArc(arc);
    }

    public void add(TransportArc arc) {
        Require.that(arc != null, "Argument must be a non-null output arc.");
        Require.that(!this.checkNames || this.places.contains(arc.source()), "The source place must be part of the petri net.");
        Require.that(!this.checkNames || this.transitions.contains(arc.transition()), "The transition must be part of the petri net");
        Require.that(!this.checkNames || this.places.contains(arc.destination()), "The destination place must be part of the petri net.");
        Require.that(!this.checkNames || !this.inhibitorArcs.contains(arc), "The specified arc is already a part of the petri net.");
        Require.that(!this.checkNames || !this.hasArcFromPlaceToTransition(arc.source(), arc.transition()), "Cannot have two arcs between the same place and transition");
        Require.that(!this.checkNames || !this.hasArcFromTransitionToPlace(arc.transition(), arc.destination()), "Cannot have two arcs between the same transition and place");
        arc.setModel(this);
        this.transportArcs.add(arc);
        arc.transition().addTransportArcGoingThrough(arc);
        arc.source().addTransportArc(arc);
        arc.destination().addTransportArc(arc);
    }

    public void addToken(TimedToken token) {
        this.currentMarking.add(token);
    }

    public void remove(TimedPlace place) {
        boolean removed = this.places.remove(place);
        if (removed && !place.isShared()) {
            this.currentMarking.removePlaceFromMarking(place);
            ((LocalTimedPlace)place).setModel(null);
        }
    }

    public void remove(TimedTransition transition) {
        boolean removed = this.transitions.remove(transition);
    }

    public void remove(TimedInputArc arc) {
        boolean removed = this.inputArcs.remove(arc);
        if (removed) {
            arc.setModel(null);
            arc.source().removeInputArc(arc);
            arc.destination().removeFromPreset(arc);
        }
    }

    public void remove(TransportArc arc) {
        boolean removed = this.transportArcs.remove(arc);
        if (removed) {
            arc.setModel(null);
            arc.destination().removeTransportArc(arc);
            arc.transition().removeTransportArcGoingThrough(arc);
        }
    }

    public void remove(TimedOutputArc arc) {
        boolean removed = this.outputArcs.remove(arc);
        if (removed) {
            arc.setModel(null);
            arc.source().removeFromPostset(arc);
            arc.destination().removeOutputArc(arc);
        }
    }

    public void remove(TimedInhibitorArc arc) {
        boolean removed = this.inhibitorArcs.remove(arc);
        if (removed) {
            arc.setModel(null);
            arc.destination().removeInhibitorArc(arc);
            arc.source().removeInhibitorArc(arc);
        }
    }

    public boolean hasArcFromPlaceToTransition(TimedPlace source, TimedTransition destination) {
        for (TimedInputArc timedInputArc : this.inputArcs) {
            if (!timedInputArc.source().equals(source) || !timedInputArc.destination().equals(destination)) continue;
            return true;
        }
        for (TimedInhibitorArc timedInhibitorArc : this.inhibitorArcs) {
            if (!timedInhibitorArc.source().equals(source) || !timedInhibitorArc.destination().equals(destination)) continue;
            return true;
        }
        for (TransportArc transportArc : this.transportArcs) {
            if (!transportArc.source().equals(source) || !transportArc.transition().equals(destination)) continue;
            return true;
        }
        return false;
    }

    public boolean hasArcFromTransitionToPlace(TimedTransition source, TimedPlace destination) {
        for (TimedOutputArc timedOutputArc : this.outputArcs) {
            if (!timedOutputArc.source().equals(source) || !timedOutputArc.destination().equals(destination)) continue;
            return true;
        }
        for (TransportArc transportArc : this.transportArcs) {
            if (!transportArc.transition().equals(source) || !transportArc.destination().equals(destination)) continue;
            return true;
        }
        return false;
    }

    public boolean isNameUsed(String name) {
        if (!this.isCheckNames()) {
            return false;
        }
        if (this.parentNetwork != null && this.parentNetwork.isNameUsedForShared(name)) {
            return true;
        }
        for (TimedPlace place : this.places) {
            if (!place.name().equals(name)) continue;
            return true;
        }
        for (TimedTransition transition : this.transitions) {
            if (!transition.name().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void setName(String newName) {
        Require.that(newName != null && !newName.isEmpty(), "name cannot be null or empty");
        this.name = newName;
    }

    public TimedPlace getPlaceByName(String placeName) {
        for (TimedPlace p : this.places) {
            if (!p.name().equals(placeName)) continue;
            return p;
        }
        return null;
    }

    public TimedTransition getTransitionByName(String transitionName) {
        for (TimedTransition t : this.transitions) {
            if (!t.name().equals(transitionName)) continue;
            return t;
        }
        return null;
    }

    public void setMarking(TimedMarking marking) {
        Require.that(marking != null, "marking must not be null");
        this.currentMarking = marking;
        for (TimedPlace p : this.places) {
            p.setCurrentMarking(marking);
        }
    }

    public List<TimedPlace> places() {
        return this.places;
    }

    public List<TimedTransition> transitions() {
        return this.transitions;
    }

    public Iterable<TimedInputArc> inputArcs() {
        return this.inputArcs;
    }

    public Iterable<TimedOutputArc> outputArcs() {
        return this.outputArcs;
    }

    public Iterable<TransportArc> transportArcs() {
        return this.transportArcs;
    }

    public Iterable<TimedInhibitorArc> inhibitorArcs() {
        return this.inhibitorArcs;
    }

    public TimedArcPetriNet copy() {
        Object copy;
        TimedArcPetriNet tapn = new TimedArcPetriNet(this.name);
        for (TimedPlace p : this.places) {
            if (!p.isShared()) {
                copy = p.copy();
                tapn.add((TimedPlace)copy);
                for (TimedToken token : p.tokens()) {
                    tapn.addToken(new TimedToken((TimedPlace)copy, token.getColor()));
                }
                continue;
            }
            tapn.add(p);
        }
        for (TimedTransition t : this.transitions) {
            copy = t.copy();
            tapn.add((TimedTransition)copy);
            if (!t.isShared()) continue;
            t.sharedTransition().makeShared((TimedTransition)copy);
        }
        for (TimedInputArc inputArc : this.inputArcs) {
            tapn.add(inputArc.copy(tapn));
        }
        for (TimedOutputArc outputArc : this.outputArcs) {
            tapn.add(outputArc.copy(tapn));
        }
        for (TransportArc transArc : this.transportArcs) {
            tapn.add(transArc.copy(tapn));
        }
        for (TimedInhibitorArc inhibArc : this.inhibitorArcs) {
            tapn.add(inhibArc.copy(tapn));
        }
        tapn.setActive(this.isActive());
        return tapn;
    }

    public TimedInputArc getInputArcFromPlaceToTransition(TimedPlace place, TimedTransition transition) {
        for (TimedInputArc inputArc : this.inputArcs) {
            if (!inputArc.source().equals(place) || !inputArc.destination().equals(transition)) continue;
            return inputArc;
        }
        return null;
    }

    public TimedOutputArc getOutputArcFromTransitionAndPlace(TimedTransition transition, TimedPlace place) {
        for (TimedOutputArc outputArc : this.outputArcs) {
            if (!outputArc.source().equals(transition) || !outputArc.destination().equals(place)) continue;
            return outputArc;
        }
        return null;
    }

    public TransportArc getTransportArcFromPlaceTransitionAndPlace(TimedPlace sourcePlace, TimedTransition transition, TimedPlace destinationPlace) {
        for (TransportArc transArc : this.transportArcs) {
            if (!transArc.source().equals(sourcePlace) || !transArc.transition().equals(transition) || !transArc.destination().equals(destinationPlace)) continue;
            return transArc;
        }
        return null;
    }

    public TimedInhibitorArc getInhibitorArcFromPlaceAndTransition(TimedPlace place, TimedTransition transition) {
        for (TimedInhibitorArc inhibArc : this.inhibitorArcs) {
            if (!inhibArc.source().equals(place) || !inhibArc.destination().equals(transition)) continue;
            return inhibArc;
        }
        return null;
    }

    public boolean hasInhibitorArcs() {
        return this.inhibitorArcs.size() > 0;
    }

    public boolean isDegree2() {
        for (TimedTransition t : this.transitions()) {
            if (t.presetSizeWithoutInhibitorArcs() <= 2 && t.postsetSize() <= 2) continue;
            return false;
        }
        return true;
    }

    public int getHighestNetDegree() {
        int currentHighestNetDegree = 0;
        for (TimedTransition t : this.transitions()) {
            currentHighestNetDegree = Collections.max(Arrays.asList(currentHighestNetDegree, t.presetSize(), t.postsetSize()));
        }
        return currentHighestNetDegree;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    private void fillStatistics(Iterable<TimedArcPetriNet> nets, Object[][] array, int columnNumber) {
        int numberOfComponents = 0;
        int numberOfPlaces = 0;
        int numberOfTransitions = 0;
        int numberOfInputArcs = 0;
        int numberOfOutputArcs = 0;
        int numberOfInhibitorArcs = 0;
        int numberOfTransportArcs = 0;
        int numberOfTotalNumberOfArcs = 0;
        int numberOfTokens = 0;
        int numberOfOrphanTransitions = 0;
        int numberOfOrphanPlaces = 0;
        boolean networkUntimed = true;
        boolean networkWeighted = false;
        boolean isGame = this.hasUncontrollableTransitions();
        boolean isColored = this.isColored();
        boolean isStochastic = this.isStochastic();
        int numberOfUntimedInputArcs = 0;
        int numberOfUntimedTransportArcs = 0;
        HashSet<TimedPlace> sharedPlaces = new HashSet<TimedPlace>();
        HashSet<TimedTransition> sharedTransitions = new HashSet<TimedTransition>();
        TimeInterval infInterval = new TimeInterval(true, new IntBound(0), Bound.Infinity, false);
        TimeInterval infIntervalConst = new TimeInterval(true, new IntBound(0), Bound.Infinity, false);
        block0: for (TimedArcPetriNet t : nets) {
            ++numberOfComponents;
            for (TimedPlace p : t.places()) {
                if (!p.isShared()) {
                    ++numberOfPlaces;
                    numberOfTokens += p.numberOfTokens();
                    continue;
                }
                sharedPlaces.add(p);
            }
            boolean sharedTransitionCount = false;
            for (TimedTransition timedTransition : t.transitions()) {
                if (!timedTransition.isShared()) {
                    ++numberOfTransitions;
                    continue;
                }
                sharedTransitions.add(timedTransition);
            }
            numberOfInputArcs += t.inputArcs.size();
            numberOfOutputArcs += t.outputArcs.size();
            numberOfInhibitorArcs += t.inhibitorArcs.size();
            numberOfTransportArcs += t.transportArcs.size();
            numberOfOrphanTransitions += t.getOrphanTransitions().size();
            numberOfOrphanPlaces += t.getOrphanPlaces().size();
            for (TimedInputArc timedInputArc : t.inputArcs()) {
                if (timedInputArc.interval().lowerBound().value() != 0 || !timedInputArc.interval().isLowerBoundNonStrict() || !timedInputArc.interval().upperBound().equals(Bound.Infinity)) {
                    networkUntimed = false;
                } else {
                    ++numberOfUntimedInputArcs;
                }
                if (networkWeighted || timedInputArc.getWeight().value() <= 1) continue;
                networkWeighted = true;
            }
            for (TransportArc transportArc : t.transportArcs()) {
                if (transportArc.interval().lowerBound().value() != 0 || !transportArc.interval().isLowerBoundNonStrict() || !transportArc.interval().upperBound().equals(Bound.Infinity)) {
                    networkUntimed = false;
                } else {
                    ++numberOfUntimedTransportArcs;
                }
                if (networkWeighted || transportArc.getWeight().value() <= 1) continue;
                networkWeighted = true;
            }
            for (TimedPlace timedPlace : t.places) {
                if (timedPlace.invariant().upperBound().equals(Bound.Infinity)) continue;
                networkUntimed = false;
            }
            for (TimedTransition timedTransition : t.transitions) {
                if (!timedTransition.isUrgent()) continue;
                networkUntimed = false;
                break;
            }
            if (!networkWeighted) {
                for (TimedOutputArc timedOutputArc : t.outputArcs()) {
                    if (timedOutputArc.getWeight().value() <= 1) continue;
                    networkWeighted = true;
                    break;
                }
            }
            if (networkWeighted) continue;
            for (TimedInhibitorArc timedInhibitorArc : t.inhibitorArcs()) {
                if (timedInhibitorArc.getWeight().value() <= 1) continue;
                networkWeighted = true;
                continue block0;
            }
        }
        numberOfPlaces += sharedPlaces.size();
        numberOfTransitions += sharedTransitions.size();
        for (TimedPlace p : sharedPlaces) {
            numberOfTokens += p.numberOfTokens();
        }
        numberOfTotalNumberOfArcs = numberOfInputArcs + numberOfOutputArcs + numberOfInhibitorArcs + numberOfTransportArcs;
        int rowNumber = 0;
        array[rowNumber++][columnNumber] = numberOfComponents;
        array[rowNumber++][columnNumber] = numberOfPlaces;
        array[rowNumber++][columnNumber] = numberOfTransitions;
        array[rowNumber++][columnNumber] = numberOfInputArcs;
        array[rowNumber++][columnNumber] = numberOfOutputArcs;
        array[rowNumber++][columnNumber] = numberOfInhibitorArcs;
        array[rowNumber++][columnNumber] = numberOfTransportArcs;
        array[rowNumber++][columnNumber] = numberOfTotalNumberOfArcs;
        array[rowNumber++][columnNumber] = numberOfTokens;
        array[rowNumber++][columnNumber] = numberOfUntimedInputArcs;
        array[rowNumber++][columnNumber] = numberOfUntimedTransportArcs;
        rowNumber += 2;
        array[rowNumber++][columnNumber] = networkUntimed ? "yes" : "no";
        array[rowNumber++][columnNumber] = networkWeighted ? "yes" : "no";
        array[rowNumber++][columnNumber] = isGame ? "yes" : "no";
        array[rowNumber++][columnNumber] = isColored ? "yes" : "no";
        array[rowNumber++][columnNumber] = isStochastic ? "yes" : "no";
        array[rowNumber++][columnNumber] = numberOfOrphanTransitions;
        array[rowNumber++][columnNumber] = numberOfOrphanPlaces;
    }

    public Object[][] getStatistics() {
        Object[][] result = new Object[20][4];
        int rowNumber = 0;
        int columnNumber = 0;
        result[rowNumber++][columnNumber] = "Number of components considered: ";
        result[rowNumber++][columnNumber] = "Number of places: ";
        result[rowNumber++][columnNumber] = "Number of transitions: ";
        result[rowNumber++][columnNumber] = "Number of input arcs: ";
        result[rowNumber++][columnNumber] = "Number of output arcs: ";
        result[rowNumber++][columnNumber] = "Number of inhibitor arcs: ";
        result[rowNumber++][columnNumber] = "Number of pairs of transport arcs: ";
        result[rowNumber++][columnNumber] = "Total number of arcs: ";
        result[rowNumber++][columnNumber] = "Number of tokens: ";
        result[rowNumber++][columnNumber] = "Number of untimed input arcs: ";
        result[rowNumber++][columnNumber] = "Number of untimed transport arcs: ";
        result[rowNumber++][columnNumber] = "Number of shared places: ";
        result[rowNumber++][columnNumber] = "Number of shared transitions: ";
        result[rowNumber++][columnNumber] = "The network is untimed: ";
        result[rowNumber++][columnNumber] = "The network is weighted: ";
        result[rowNumber++][columnNumber] = "The network is game: ";
        result[rowNumber++][columnNumber] = "The network is colored: ";
        result[rowNumber++][columnNumber] = "The network is stochastic: ";
        result[rowNumber++][columnNumber] = "Number of orphan transitions: ";
        result[rowNumber++][columnNumber] = "Number of orphan places: ";
        this.fillStatistics(Arrays.asList(this), result, 1);
        this.fillStatistics(this.parentNetwork().activeTemplates(), result, 2);
        this.fillStatistics(this.parentNetwork().allTemplates(), result, 3);
        result[11][3] = this.parentNetwork().numberOfSharedPlaces();
        result[12][3] = this.parentNetwork().numberOfSharedTransitions();
        return result;
    }

    public List<TimedTransition> getOrphanTransitions() {
        ArrayList<TimedTransition> orphans = new ArrayList<TimedTransition>();
        for (TimedTransition transition : this.transitions) {
            if (!transition.isOrphan()) continue;
            orphans.add(transition);
        }
        return orphans;
    }

    public List<TimedPlace> getOrphanPlaces() {
        ArrayList<TimedPlace> orphans = new ArrayList<TimedPlace>();
        for (TimedPlace place : this.places) {
            if (!place.isOrphan()) continue;
            orphans.add(place);
        }
        return orphans;
    }

    public int getNumberOfTokensInNet() {
        int result = 0;
        for (TimedPlace place : this.places) {
            if (place.numberOfTokens == 0) {
                int tokens = this.countTokens(place.tokensAsExpression, 0);
                result += tokens == 0 && this.marking().getTokensFor(place).size() > 0 ? this.marking().getTokensFor(place).size() : tokens;
                continue;
            }
            result += place.numberOfTokens();
        }
        return result == 0 ? this.marking().size() : result;
    }

    private int countTokens(Expression expression, int numberOf) {
        if (expression == null) {
            return 0;
        }
        if (expression instanceof TupleExpression) {
            return this.countTupleTokens((TupleExpression)expression, numberOf);
        }
        int result = 0;
        for (ExprStringPosition exprStringPosition : expression.getChildren()) {
            Expression child = exprStringPosition.getObject();
            if (child instanceof AllExpression) {
                result += ((AllExpression)child).size() * numberOf;
                continue;
            }
            if (child instanceof NumberOfExpression) {
                result += this.countTokens(child, ((NumberOfExpression)child).getNumber());
                continue;
            }
            result += this.countTokens(child, numberOf);
        }
        return result == 0 ? numberOf : result;
    }

    private int countTupleTokens(TupleExpression expression, int numberOf) {
        int result = 1;
        for (ColorExpression colorExpression : expression.getColors()) {
            if (!(colorExpression instanceof AllExpression)) continue;
            if (result < numberOf) {
                result *= ((AllExpression)colorExpression).size() * numberOf;
                continue;
            }
            result *= ((AllExpression)colorExpression).size().intValue();
        }
        return result;
    }

    public boolean hasWeights() {
        for (TimedInputArc timedInputArc : this.inputArcs) {
            if (timedInputArc.getWeight().value() == 1) continue;
            return true;
        }
        for (TimedOutputArc timedOutputArc : this.outputArcs) {
            if (timedOutputArc.getWeight().value() == 1) continue;
            return true;
        }
        for (TimedInhibitorArc timedInhibitorArc : this.inhibitorArcs) {
            if (timedInhibitorArc.getWeight().value() == 1) continue;
            return true;
        }
        for (TransportArc transportArc : this.transportArcs) {
            if (transportArc.getWeight().value() == 1) continue;
            return true;
        }
        return false;
    }

    public boolean isUntimed() {
        for (TimedInputArc t : this.inputArcs) {
            if (t.interval().equals(TimeInterval.ZERO_INF)) continue;
            return false;
        }
        if (this.transportArcs.size() > 0) {
            return false;
        }
        if (this.hasUrgentTransitions()) {
            return false;
        }
        for (TimedPlace p : this.places) {
            if (p.invariant().upperBound().toString().equals("inf")) continue;
            return false;
        }
        return true;
    }

    public boolean hasUrgentTransitions() {
        for (TimedTransition t : this.transitions) {
            if (!t.isUrgent()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUncontrollableTransitions() {
        for (TimedTransition t : this.transitions) {
            if (!t.isUncontrollable()) continue;
            return true;
        }
        return false;
    }

    public boolean isNonStrict() {
        for (TimedInputArc timedInputArc : this.inputArcs) {
            if (timedInputArc.interval().isLowerBoundNonStrict() && (timedInputArc.interval().isUpperBoundNonStrict() || timedInputArc.interval().upperBound() instanceof Bound.InfBound)) continue;
            return false;
        }
        for (TransportArc transportArc : this.transportArcs) {
            if (transportArc.interval().isLowerBoundNonStrict() && (transportArc.interval().isUpperBoundNonStrict() || transportArc.interval().upperBound() instanceof Bound.InfBound)) continue;
            return false;
        }
        for (TimedPlace timedPlace : this.places) {
            if (timedPlace.invariant().isUpperNonstrict() || timedPlace.invariant().upperBound() instanceof Bound.InfBound) continue;
            return false;
        }
        return true;
    }

    public int getBiggestConstant() {
        Bound max;
        int biggestConstant = -1;
        for (TimedInputArc timedInputArc : this.inputArcs) {
            max = IntervalOperations.getMaxNoInfBound(timedInputArc.interval());
            if (max.value() <= biggestConstant) continue;
            biggestConstant = max.value();
        }
        for (TransportArc transportArc : this.transportArcs) {
            max = IntervalOperations.getMaxNoInfBound(transportArc.interval());
            if (max.value() <= biggestConstant) continue;
            biggestConstant = max.value();
        }
        for (TimedPlace timedPlace : this.places) {
            if (timedPlace.invariant().upperBound() instanceof Bound.InfBound || timedPlace.invariant().upperBound().value() <= biggestConstant) continue;
            biggestConstant = timedPlace.invariant().upperBound().value();
        }
        return biggestConstant;
    }

    public int getBiggestConstantEnabledTransitions() {
        int biggestConstant = -1;
        for (TimedTransition t : this.transitions) {
            int tmp;
            if (!t.isDEnabled() || (tmp = t.getLagestAssociatedConstant()) <= biggestConstant) continue;
            biggestConstant = tmp;
        }
        return biggestConstant;
    }

    public boolean isCheckNames() {
        return this.checkNames;
    }

    public void setCheckNames(boolean checkNames) {
        this.checkNames = checkNames;
    }
}

