/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.Expressions.GuardExpression;
import dk.aau.cs.model.tapn.DoubleProbability;
import dk.aau.cs.model.tapn.Probability;
import dk.aau.cs.model.tapn.SMCDistribution;
import dk.aau.cs.model.tapn.TimeInterval;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.FiringMode;
import dk.aau.cs.model.tapn.simulation.RandomFiringMode;
import dk.aau.cs.util.IntervalOperations;
import dk.aau.cs.util.Require;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class SharedTransition {
    private static final Pattern namePattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private String name;
    private final List<TimedTransition> transitions = new ArrayList<TimedTransition>();
    private boolean isUrgent = false;
    private boolean isUncontrollable = false;
    private SMCDistribution distribution = SMCDistribution.defaultDistribution();
    private Probability weight = new DoubleProbability(1.0);
    private FiringMode firingMode = new RandomFiringMode();
    private GuardExpression guard = null;
    private TimedArcPetriNetNetwork network;

    public SharedTransition(String name) {
        this.setName(name);
    }

    public TimedArcPetriNetNetwork network() {
        return this.network;
    }

    public void setNetwork(TimedArcPetriNetNetwork network) {
        this.network = network;
    }

    public boolean isUrgent() {
        return this.isUrgent;
    }

    public void setUrgent(boolean value) {
        this.isUrgent = value;
        if (this.isUrgent) {
            this.setDistribution(SMCDistribution.urgent());
        }
        for (TimedTransition t : this.transitions) {
            t.setUrgent(value, false);
        }
    }

    public boolean isUncontrollable() {
        return this.isUncontrollable;
    }

    public void setUncontrollable(boolean isUncontrollable) {
        this.isUncontrollable = isUncontrollable;
        for (TimedTransition transition : this.transitions) {
            transition.setUncontrollable(isUncontrollable, false);
        }
    }

    public SMCDistribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(SMCDistribution distribution) {
        this.distribution = distribution;
        for (TimedTransition transition : this.transitions) {
            transition.setDistribution(distribution, false);
        }
    }

    public Probability getWeight() {
        return this.weight;
    }

    public void setWeight(Probability weight) {
        this.weight = weight;
        for (TimedTransition transition : this.transitions) {
            transition.setWeight(weight, false);
        }
    }

    public void setFiringMode(FiringMode firingMode) {
        this.firingMode = firingMode;
        for (TimedTransition transition : this.transitions) {
            transition.setFiringMode(firingMode);
        }
    }

    public FiringMode getFiringMode() {
        return this.firingMode;
    }

    public boolean hasCustomDistribution() {
        return !this.distribution.equals(SMCDistribution.defaultDistribution());
    }

    public GuardExpression getGuard() {
        return this.guard;
    }

    public void setGuard(GuardExpression guard) {
        this.guard = guard;
        for (TimedTransition transition : this.transitions) {
            if (guard != null) {
                transition.setGuard(guard.copy(), false);
                continue;
            }
            transition.setGuard(null, false);
        }
    }

    public void setName(String newName) {
        Require.that(newName != null && !newName.isEmpty(), "A timed transition must have a name");
        Require.that(this.isValid(newName), "The specified name must conform to the pattern [a-zA-Z_][a-zA-Z0-9_]*");
        this.name = newName;
        for (TimedTransition transition : this.transitions) {
            transition.setName(newName);
        }
    }

    private boolean isValid(String newName) {
        return namePattern.matcher(newName).matches();
    }

    public void makeShared(TimedTransition transition) {
        Require.that(transition != null, "transition cannot be null");
        Require.that(this.templateDoesNotContainSharedTransition(transition.model()), "Another transition in the same template is already shared under that name");
        transition.makeShared(this);
        this.transitions.add(transition);
    }

    private boolean templateDoesNotContainSharedTransition(TimedArcPetriNet model) {
        Require.that(model != null, "model cannot be null");
        for (TimedTransition transition : this.transitions) {
            if (!model.equals(transition.model())) continue;
            return false;
        }
        return true;
    }

    public void unshare(TimedTransition timedTransition) {
        Require.that(timedTransition != null, "timedTransition cannot be null");
        this.transitions.remove(timedTransition);
    }

    public boolean isEnabled() {
        if (this.transitions.size() == 0) {
            return false;
        }
        for (TimedTransition transition : this.transitions) {
            if (!transition.model().isActive() || transition.isEnabledAlone()) continue;
            return false;
        }
        return true;
    }

    public ArrayList<TimeInterval> calculateDInterval() {
        if (this.transitions.size() == 0) {
            return null;
        }
        ArrayList<TimeInterval> result = new ArrayList<TimeInterval>();
        result.add(TimeInterval.ZERO_INF);
        for (TimedTransition transition : this.transitions) {
            if (!transition.model().isActive()) continue;
            result = IntervalOperations.intersectingInterval(transition.calculateDIntervalAlone(), result);
        }
        return result;
    }

    public String name() {
        return this.name;
    }

    public void delete() {
        ArrayList<TimedTransition> copy = new ArrayList<TimedTransition>(this.transitions);
        for (TimedTransition transition : copy) {
            transition.delete();
        }
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedTransition)) {
            return false;
        }
        SharedTransition other = (SharedTransition)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Collection<TimedTransition> transitions() {
        return new ArrayList<TimedTransition>(this.transitions);
    }

    public boolean isOrphan() {
        for (TimedTransition transition : this.transitions) {
            if (transition.presetSize() <= 0 && transition.postsetSize() <= 0) continue;
            return false;
        }
        return true;
    }
}

