/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import net.tapaal.gui.petrinet.Template;
import pipe.gui.TAPAALGUI;

public class SharedPlace
extends TimedPlace {
    private ColorType colorType;
    private List<ColoredTimeInvariant> ctiList = new ArrayList<ColoredTimeInvariant>(){
        {
            this.add(ColoredTimeInvariant.LESS_THAN_INFINITY_DYN_COLOR(Color.STAR_COLOR));
        }
    };
    private TimedArcPetriNetNetwork network;

    public SharedPlace(String name) {
        this(name, TimeInvariant.LESS_THAN_INFINITY, ColorType.COLORTYPE_DOT);
    }

    public SharedPlace(String name, ColorType colorType) {
        this(name, TimeInvariant.LESS_THAN_INFINITY, colorType);
    }

    public SharedPlace(String name, TimeInvariant invariant) {
        this(name, invariant, ColorType.COLORTYPE_DOT);
    }

    public SharedPlace(String name, TimeInvariant invariant, ColorType colorType) {
        this.setName(name);
        this.setInvariant(invariant);
        this.colorType = colorType;
    }

    public void setNetwork(TimedArcPetriNetNetwork network) {
        this.network = network;
    }

    public TimedArcPetriNetNetwork network() {
        return this.network;
    }

    @Override
    public TimedPlace copy() {
        SharedPlace p = new SharedPlace(this.name(), this.invariant().copy(), this.colorType);
        p.setTokenExpression(this.tokensAsExpression.deepCopy());
        p.setCtiList(this.ctiList);
        return p;
    }

    @Override
    public boolean isShared() {
        return true;
    }

    public ArrayList<String> getComponentsUsingThisPlace() {
        ArrayList<String> components = new ArrayList<String>();
        for (Template t : TAPAALGUI.getCurrentTab().allTemplates()) {
            TimedPlace tp = t.model().getPlaceByName(this.name);
            if (tp == null) continue;
            components.add(t.model().name());
        }
        return components;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedPlace)) {
            return false;
        }
        SharedPlace other = (SharedPlace)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Tuple<TimedPlace.PlaceType, Integer> extrapolate() {
        if ((Integer)this.extrapolation.value2() > -2) {
            return this.extrapolation;
        }
        TimedPlace.PlaceType type = TimedPlace.PlaceType.Dead;
        int cmax = -1;
        this.extrapolation = new Tuple<TimedPlace.PlaceType, Integer>(type, cmax);
        for (Template t : TAPAALGUI.getCurrentTab().activeTemplates()) {
            TimedPlace tp = t.model().getPlaceByName(this.name);
            if (tp == null) continue;
            cmax = Math.max(cmax, tp.extrapolate().value2());
            if (tp.extrapolate().value1() == TimedPlace.PlaceType.Invariant || type == TimedPlace.PlaceType.Dead && tp.extrapolate().value1() == TimedPlace.PlaceType.Standard) {
                type = tp.extrapolate().value1();
            }
            this.extrapolation = new Tuple<TimedPlace.PlaceType, Integer>(type, cmax);
        }
        this.extrapolation = new Tuple<TimedPlace.PlaceType, Integer>(TimedPlace.PlaceType.Dead, -2);
        return new Tuple<TimedPlace.PlaceType, Integer>(type, cmax);
    }

    @Override
    public List<ColoredTimeInvariant> getCtiList() {
        return this.ctiList;
    }

    @Override
    public void setCtiList(List<ColoredTimeInvariant> ctiList) {
        ArrayList<ColoredTimeInvariant> found = new ArrayList<ColoredTimeInvariant>();
        for (ColoredTimeInvariant timeInvariant : ctiList) {
            if (timeInvariant != null) continue;
            found.add(timeInvariant);
        }
        ctiList.removeAll(found);
        this.ctiList = ctiList;
    }

    @Override
    public void setColorType(ColorType colorType) {
        this.colorType = colorType;
    }

    @Override
    public ColorType getColorType() {
        return this.colorType;
    }
}

