/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.ConstantProbability;
import dk.aau.cs.model.tapn.ConstantStore;
import dk.aau.cs.model.tapn.DoubleProbability;

public abstract class Probability {
    public abstract double value();

    public abstract Probability copy();

    public abstract String toString(boolean var1);

    public abstract String nameForSaving(boolean var1);

    public boolean isInfinite() {
        return Double.isInfinite(this.value());
    }

    public static Probability parseProbability(String attribute, ConstantStore constants) {
        Probability weight;
        if (attribute.equals("inf")) {
            return new DoubleProbability(Double.POSITIVE_INFINITY);
        }
        try {
            double weightAsDouble = Double.parseDouble(attribute);
            weight = new DoubleProbability(weightAsDouble);
        }
        catch (NumberFormatException e) {
            if (constants.containsConstantByName(attribute)) {
                weight = new ConstantProbability(constants.getConstantByName(attribute));
            }
            throw new RuntimeException("A constant which was not declared was used in a transition weight");
        }
        return weight;
    }
}

