/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.io.writeTACPN;
import dk.aau.cs.model.NTA.trace.TraceToken;
import dk.aau.cs.model.tapn.LocalTimedMarking;
import dk.aau.cs.model.tapn.LocalTimedPlace;
import dk.aau.cs.model.tapn.SharedPlace;
import dk.aau.cs.model.tapn.SharedTransition;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedMarking;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TimedToken;
import dk.aau.cs.model.tapn.TimedTransition;
import dk.aau.cs.model.tapn.simulation.FiringMode;
import dk.aau.cs.util.Require;
import dk.aau.cs.util.Tuple;
import dk.aau.cs.verification.TAPNComposer;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pipe.gui.TAPAALGUI;

public class NetworkMarking
implements TimedMarking {
    private final Map<TimedArcPetriNet, LocalTimedMarking> markings = new HashMap<TimedArcPetriNet, LocalTimedMarking>();
    private final Map<TimedPlace, List<TimedToken>> sharedPlacesTokens = new HashMap<TimedPlace, List<TimedToken>>();

    public void addMarking(TimedArcPetriNet tapn, LocalTimedMarking marking) {
        Require.that(tapn != null, "tapn must not be null");
        Require.that(!this.markings.containsKey(tapn), "There is already a marking for that tapn");
        marking.setNetworkMarking(this);
        this.markings.put(tapn, marking);
    }

    public void removeMarkingFor(TimedArcPetriNet tapn) {
        Require.that(tapn != null, "tapn must be non-null");
        if (this.markings.containsKey(tapn)) {
            for (TimedPlace place : tapn.places()) {
                place.resetNumberOfTokens();
            }
            LocalTimedMarking marking = this.markings.remove(tapn);
            marking.setNetworkMarking(null);
        }
    }

    public void updateMarking(LocalTimedMarking newMarking, Map<TimedPlace, List<TimedToken>> sharedPlacesToTokensMap) {
        for (TimedPlace place : newMarking.getPlacesToTokensMap().keySet()) {
            TimedArcPetriNet tapn = ((LocalTimedPlace)place).model();
            this.markings.put(tapn, newMarking);
        }
        this.sharedPlacesTokens.clear();
        for (TimedPlace place : sharedPlacesToTokensMap.keySet()) {
            this.sharedPlacesTokens.put(place, sharedPlacesToTokensMap.get(place));
        }
    }

    public LocalTimedMarking getMarkingFor(TimedArcPetriNet tapn) {
        return this.markings.get(tapn);
    }

    public Map<TimedArcPetriNet, LocalTimedMarking> getMarkingMap() {
        return this.markings;
    }

    public Map<TimedPlace, List<TimedToken>> getSharedPlacesTokens() {
        return this.sharedPlacesTokens;
    }

    @Override
    public NetworkMarking clone() {
        return this.delay(BigDecimal.ZERO);
    }

    @Override
    public boolean isDelayPossible(BigDecimal delay) {
        for (Map.Entry<TimedPlace, List<TimedToken>> entry : this.sharedPlacesTokens.entrySet()) {
            if (!TAPAALGUI.getCurrentTab().network().isSharedPlaceUsedInTemplates((SharedPlace)entry.getKey())) continue;
            for (TimedToken token : entry.getValue()) {
                TimeInvariant invariant = token.place().invariant();
                if (invariant.isSatisfied(token.age().add(delay))) continue;
                return false;
            }
        }
        for (Map.Entry<Object, Object> entry : this.markings.entrySet()) {
            if (!((TimedArcPetriNet)entry.getKey()).isActive() || ((LocalTimedMarking)entry.getValue()).isDelayPossible(delay)) continue;
            return false;
        }
        return true;
    }

    public List<TimedPlace> getBlockingPlaces(BigDecimal delay) {
        ArrayList<TimedPlace> result = new ArrayList<TimedPlace>();
        for (Map.Entry<TimedPlace, List<TimedToken>> entry : this.sharedPlacesTokens.entrySet()) {
            if (!TAPAALGUI.getCurrentTab().network().isSharedPlaceUsedInTemplates((SharedPlace)entry.getKey())) continue;
            for (TimedToken token : entry.getValue()) {
                TimeInvariant invariant = token.place().invariant();
                if (invariant.isSatisfied(token.age().add(delay)) || result.contains(token.place())) continue;
                result.add(token.place());
            }
        }
        for (Map.Entry<Object, Object> entry : this.markings.entrySet()) {
            if (!((TimedArcPetriNet)entry.getKey()).isActive()) continue;
            result.addAll(((LocalTimedMarking)entry.getValue()).getBlockingPlaces(delay));
        }
        return result;
    }

    @Override
    public NetworkMarking delay(BigDecimal amount) {
        Require.that(amount != null, "Delay must not be null");
        Require.that(this.isDelayPossible(amount), "Delay breaks invariant.");
        NetworkMarking newMarking = new NetworkMarking();
        for (Map.Entry<TimedPlace, List<TimedToken>> entry : this.sharedPlacesTokens.entrySet()) {
            ArrayList<TimedToken> newTokens = new ArrayList<TimedToken>(entry.getValue().size());
            for (TimedToken token : entry.getValue()) {
                newTokens.add(token.delay(amount));
            }
            newMarking.sharedPlacesTokens.put(entry.getKey(), newTokens);
        }
        for (Map.Entry<Object, Object> entry : this.markings.entrySet()) {
            if (!((TimedArcPetriNet)entry.getKey()).isActive()) continue;
            newMarking.addMarking((TimedArcPetriNet)entry.getKey(), ((LocalTimedMarking)entry.getValue()).delay(amount));
        }
        return newMarking;
    }

    public Tuple<NetworkMarking, List<TimedToken>> fireTransition(TimedTransition transition, FiringMode firingMode) {
        Require.that(transition != null, "transition cannot be null");
        Require.that(firingMode != null, "firingMode cannot be null");
        if (transition.isShared()) {
            return this.fireSharedTransition(transition.sharedTransition(), firingMode);
        }
        NetworkMarking clone = this.clone();
        Tuple<LocalTimedMarking, List<TimedToken>> newMarking = clone.getMarkingFor(transition.model()).fireTransition(transition, firingMode);
        clone.removeMarkingFor(transition.model());
        clone.addMarking(transition.model(), newMarking.value1());
        return new Tuple<NetworkMarking, List<TimedToken>>(clone, newMarking.value2());
    }

    private Tuple<NetworkMarking, List<TimedToken>> fireSharedTransition(SharedTransition sharedTransition, FiringMode firingMode) {
        NetworkMarking clone = this.clone();
        ArrayList consumedTokens = new ArrayList();
        for (TimedTransition transition : sharedTransition.transitions()) {
            if (!transition.model().isActive()) continue;
            Tuple<LocalTimedMarking, List<TimedToken>> ltm = clone.getMarkingFor(transition.model()).fireTransition(transition, firingMode);
            consumedTokens.addAll(ltm.value2());
            clone.removeMarkingFor(transition.model());
            clone.addMarking(transition.model(), ltm.value1());
        }
        return new Tuple<NetworkMarking, List<TimedToken>>(clone, consumedTokens);
    }

    private NetworkMarking fireSharedTransition(SharedTransition sharedTransition, List<TimedToken> tokensToConsume) {
        HashMap<TimedTransition, List<TimedToken>> tokensPerTransition = this.distributeTokensToIndividualTransitions(sharedTransition, tokensToConsume);
        NetworkMarking clone = this.clone();
        for (TimedTransition transition : sharedTransition.transitions()) {
            if (!transition.model().isActive()) continue;
            TimedMarking ltm = clone.getMarkingFor(transition.model()).fireTransition(transition, (List)tokensPerTransition.get(transition));
            clone.removeMarkingFor(transition.model());
            clone.addMarking(transition.model(), (LocalTimedMarking)ltm);
        }
        return clone;
    }

    private HashMap<TimedTransition, List<TimedToken>> distributeTokensToIndividualTransitions(SharedTransition sharedTransition, List<TimedToken> tokensToConsume) {
        HashMap<TimedTransition, List<TimedToken>> distributedTokens = new HashMap<TimedTransition, List<TimedToken>>();
        for (TimedTransition transition : sharedTransition.transitions()) {
            distributedTokens.put(transition, new ArrayList());
        }
        block1: for (TimedToken token : tokensToConsume) {
            for (TimedTransition transition : sharedTransition.transitions()) {
                if (!transition.model().isActive() || !transition.model().equals(((LocalTimedPlace)token.place()).model())) continue;
                distributedTokens.get(transition).add(token);
                continue block1;
            }
        }
        return distributedTokens;
    }

    @Override
    public NetworkMarking fireTransition(TimedTransition transition, List<TimedToken> tokensToConsume) {
        Require.that(transition != null, "transition cannot be null");
        Require.that(tokensToConsume != null, "Must specify a list of tokens");
        if (transition.isShared()) {
            return this.fireSharedTransition(transition.sharedTransition(), tokensToConsume);
        }
        NetworkMarking clone = this.clone();
        TimedMarking newMarking = clone.getMarkingFor(transition.model()).fireTransition(transition, (List)tokensToConsume);
        clone.removeMarkingFor(transition.model());
        clone.addMarking(transition.model(), (LocalTimedMarking)newMarking);
        return clone;
    }

    @Override
    public int size() {
        int size = 0;
        for (LocalTimedMarking localTimedMarking : this.markings.values()) {
            size += localTimedMarking.size();
        }
        for (List list : this.sharedPlacesTokens.values()) {
            size += list.size();
        }
        return size;
    }

    @Override
    public void add(TimedToken token) {
        if (token.place().isShared()) {
            this.addTokenToSharedPlace(token);
        } else {
            this.getMarkingFor(((LocalTimedPlace)token.place()).model()).add(token);
        }
    }

    private void addTokenToSharedPlace(TimedToken token) {
        Require.that(token.place().isShared(), "Token must be located in a shared place");
        if (!this.sharedPlacesTokens.containsKey(token.place())) {
            this.sharedPlacesTokens.put(token.place(), new ArrayList());
        }
        this.sharedPlacesTokens.get(token.place()).add(token);
    }

    @Override
    public List<TimedToken> getTokensFor(TimedPlace place) {
        if (place.isShared()) {
            if (!this.sharedPlacesTokens.containsKey(place)) {
                return new ArrayList<TimedToken>();
            }
            return this.sharedPlacesTokens.get(place);
        }
        LocalTimedPlace timedPlace = (LocalTimedPlace)place;
        return this.getMarkingFor(timedPlace.model()).getTokensFor((TimedPlace)timedPlace);
    }

    @Override
    public void remove(TimedToken token) {
        TimedPlace place = token.place();
        if (place.isShared()) {
            List<TimedToken> tokens;
            if (this.sharedPlacesTokens.containsKey(place) && !(tokens = this.sharedPlacesTokens.get(place)).remove(token) && token instanceof TraceToken) {
                for (TimedToken t : tokens) {
                    if (t.age().compareTo(token.age()) < 0) continue;
                    tokens.remove(t);
                    break;
                }
            }
        } else {
            this.getMarkingFor(((LocalTimedPlace)place).model()).remove(token);
        }
    }

    @Override
    public void removePlaceFromMarking(TimedPlace place) {
        if (place.isShared()) {
            this.sharedPlacesTokens.remove(place);
        } else {
            this.getMarkingFor(((LocalTimedPlace)place).model()).removePlaceFromMarking(place);
        }
    }

    public void clear() {
        this.sharedPlacesTokens.clear();
        for (TimedArcPetriNet key : this.markings.keySet()) {
            this.markings.get(key).clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NetworkMarking)) {
            return false;
        }
        NetworkMarking other = (NetworkMarking)obj;
        if (this.markings.size() != other.markings.size()) {
            return false;
        }
        for (TimedArcPetriNet timedArcPetriNet : this.markings.keySet()) {
            if (other.markings.get(timedArcPetriNet) != null && other.markings.get(timedArcPetriNet).equals(this.markings.get(timedArcPetriNet))) continue;
            return false;
        }
        if (this.sharedPlacesTokens.size() != other.sharedPlacesTokens.size()) {
            return false;
        }
        for (TimedPlace timedPlace : this.sharedPlacesTokens.keySet()) {
            if (other.sharedPlacesTokens.get(timedPlace) == null) {
                return false;
            }
            for (TimedToken t : other.sharedPlacesTokens.get(timedPlace)) {
                if (t.equals(this.sharedPlacesTokens.get(timedPlace))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<TimedArcPetriNet, LocalTimedMarking> entry : this.markings.entrySet()) {
            sb.append(entry.getKey().name()).append(": ").append(entry.getValue().toString()).append("\n");
        }
        if (this.sharedPlacesTokens.isEmpty()) {
            return sb.toString();
        }
        sb.append("Shared Places:\n");
        for (Map.Entry<Object, Object> entry : this.sharedPlacesTokens.entrySet()) {
            sb.append(((TimedPlace)entry.getKey()).name()).append(" -> ");
            for (TimedToken token : (List)entry.getValue()) {
                sb.append(token.toString()).append(" ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toXmlStr(TAPNComposer composer) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element markingElement = this.toXmlElement(document, composer);
            document.appendChild(markingElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.getBuffer().toString().trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Element toXmlElement(Document document, TAPNComposer composer) {
        HashMap<TimedPlace, List<TimedToken>> allPlaces = new HashMap<TimedPlace, List<TimedToken>>();
        for (Map.Entry<TimedArcPetriNet, LocalTimedMarking> entry : this.markings.entrySet()) {
            if (!entry.getKey().isActive()) continue;
            allPlaces.putAll(entry.getValue().getPlacesToTokensMap());
        }
        allPlaces.putAll(this.sharedPlacesTokens);
        Element markingElement = document.createElement("marking");
        writeTACPN writer = null;
        if (!allPlaces.isEmpty()) {
            TimedPlace firstPlace = (TimedPlace)allPlaces.keySet().iterator().next();
            TimedArcPetriNetNetwork network = null;
            if (firstPlace instanceof LocalTimedPlace) {
                network = ((LocalTimedPlace)firstPlace).model().parentNetwork();
            } else if (firstPlace instanceof SharedPlace) {
                network = ((SharedPlace)firstPlace).network();
            }
            if (network != null) {
                writer = new writeTACPN(network);
            }
        }
        for (Map.Entry entry : allPlaces.entrySet()) {
            TimedPlace place = (TimedPlace)entry.getKey();
            Element placeElement = document.createElement("place");
            placeElement.setAttribute("id", composer.composedPlaceName((TimedPlace)entry.getKey()));
            if (place.getTokensAsExpression() != null && writer != null) {
                writer.parseArcExpression(place.getTokensAsExpression(), document, placeElement);
            }
            markingElement.appendChild(placeElement);
        }
        return markingElement;
    }
}

