/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ColoredTimeInvariant;
import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.TimeInvariant;
import dk.aau.cs.model.tapn.TimedArcPetriNet;
import dk.aau.cs.model.tapn.TimedInputArc;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.model.tapn.TransportArc;
import dk.aau.cs.util.Tuple;
import java.util.ArrayList;
import java.util.List;

public class LocalTimedPlace
extends TimedPlace {
    private ColorType colorType;
    private List<ColoredTimeInvariant> ctiList = new ArrayList<ColoredTimeInvariant>();
    private TimedArcPetriNet model;

    public LocalTimedPlace(String name) {
        this(name, ColorType.COLORTYPE_DOT);
    }

    public LocalTimedPlace(String name, ColorType colorType) {
        this(name, TimeInvariant.LESS_THAN_INFINITY, colorType);
    }

    public LocalTimedPlace(String name, TimeInvariant invariant, ColorType ct) {
        this.setName(name);
        this.setInvariant(invariant);
        this.colorType = ct;
    }

    public TimedArcPetriNet model() {
        return this.model;
    }

    public void setModel(TimedArcPetriNet model) {
        this.model = model;
    }

    @Override
    public boolean isShared() {
        return false;
    }

    @Override
    public LocalTimedPlace copy() {
        LocalTimedPlace p = new LocalTimedPlace(this.name, this.colorType);
        if (this.tokensAsExpression != null) {
            p.setTokenExpression(this.tokensAsExpression.deepCopy());
        }
        p.setCtiList(this.ctiList);
        p.invariant = this.invariant.copy();
        return p;
    }

    public String toString() {
        if (this.model() != null) {
            return this.model().name() + "." + this.name;
        }
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.model() == null ? 0 : this.model().hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalTimedPlace)) {
            return false;
        }
        LocalTimedPlace other = (LocalTimedPlace)obj;
        if (this.model() == null ? other.model() != null : !this.model().equals(other.model())) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public Tuple<TimedPlace.PlaceType, Integer> extrapolate() {
        if ((Integer)this.extrapolation.value2() > -2) {
            return this.extrapolation;
        }
        TimedPlace.PlaceType type = TimedPlace.PlaceType.Dead;
        int cmax = -1;
        this.extrapolation = new Tuple<TimedPlace.PlaceType, Integer>(type, cmax);
        if (this.invariant != TimeInvariant.LESS_THAN_INFINITY) {
            cmax = Math.max(cmax, this.invariant.upperBound().value());
        }
        if (cmax > -1) {
            this.extrapolation = new Tuple<TimedPlace.PlaceType, Integer>(TimedPlace.PlaceType.Dead, -2);
            return new Tuple<TimedPlace.PlaceType, Integer>(TimedPlace.PlaceType.Invariant, cmax);
        }
        for (TimedInputArc timedInputArc : this.model.inputArcs()) {
            if (!timedInputArc.source().equals(this)) continue;
            if (!timedInputArc.interval().upperBound().equals(Bound.Infinity)) {
                cmax = Math.max(cmax, timedInputArc.interval().upperBound().value());
            } else if (timedInputArc.interval().lowerBound().value() > 0) {
                cmax = Math.max(cmax, timedInputArc.interval().lowerBound().value());
            }
            if (type == TimedPlace.PlaceType.Dead && timedInputArc.interval().upperBound().equals(Bound.Infinity)) {
                type = TimedPlace.PlaceType.Standard;
            }
            this.extrapolation = new Tuple<TimedPlace.PlaceType, Integer>(type, cmax);
        }
        for (TransportArc transportArc : this.model.transportArcs()) {
            Tuple<TimedPlace.PlaceType, Integer> other;
            if (!transportArc.source().equals(this)) continue;
            if (!transportArc.interval().upperBound().equals(Bound.Infinity)) {
                cmax = Math.max(cmax, transportArc.interval().upperBound().value());
            } else if (transportArc.interval().lowerBound().value() > 0) {
                cmax = Math.max(cmax, transportArc.interval().lowerBound().value());
            }
            if (type == TimedPlace.PlaceType.Dead && transportArc.interval().upperBound().equals(Bound.Infinity)) {
                type = TimedPlace.PlaceType.Standard;
            }
            if ((other = transportArc.source().extrapolate()).value2() > cmax) {
                cmax = other.value2();
            }
            if (type == TimedPlace.PlaceType.Dead && transportArc.interval().upperBound().equals(Bound.Infinity)) {
                type = TimedPlace.PlaceType.Standard;
            }
            this.extrapolation = new Tuple<TimedPlace.PlaceType, Integer>(type, cmax);
        }
        this.extrapolation = new Tuple<TimedPlace.PlaceType, Integer>(TimedPlace.PlaceType.Dead, -2);
        return new Tuple<TimedPlace.PlaceType, Integer>(type, cmax);
    }

    @Override
    public List<ColoredTimeInvariant> getCtiList() {
        return this.ctiList;
    }

    @Override
    public void setCtiList(List<ColoredTimeInvariant> ctiList) {
        ArrayList<ColoredTimeInvariant> found = new ArrayList<ColoredTimeInvariant>();
        for (ColoredTimeInvariant timeInvariant : ctiList) {
            if (timeInvariant != null) continue;
            found.add(timeInvariant);
        }
        ctiList.removeAll(found);
        this.ctiList = ctiList;
    }

    @Override
    public void setColorType(ColorType colorType) {
        if (!this.colorType.equals(colorType)) {
            this.currentMarking.getTokensFor(this).removeAll(this.currentMarking.getTokensFor(this));
            this.colorType = colorType;
            this.fireMarkingChanged();
        }
    }

    @Override
    public ColorType getColorType() {
        return this.colorType;
    }
}

