/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.model.tapn.Weight;
import dk.aau.cs.util.Require;

public class ConstantWeight
extends Weight {
    private Constant constant;

    public ConstantWeight(Constant constant) {
        Require.that(constant != null, "Argument must be a non-null constant");
        this.constant = constant;
    }

    @Override
    public int value() {
        return this.constant.value();
    }

    @Override
    public Weight copy() {
        return new ConstantWeight(this.constant.copy());
    }

    public Constant constant() {
        return this.constant;
    }

    public void setConstant(Constant newConstant) {
        Require.that(newConstant != null, "Constant cannot be null");
        this.constant = newConstant;
    }

    public String toString() {
        return this.constant.name();
    }

    @Override
    public String toString(boolean displayConstantNames) {
        if (displayConstantNames) {
            return this.constant.name() + " x";
        }
        if (this.constant.value() > 1) {
            return this.constant.value() + "x";
        }
        return "";
    }

    @Override
    public String nameForSaving(boolean writeConstantNames) {
        if (writeConstantNames) {
            return this.constant.name();
        }
        return Integer.toString(this.constant.value());
    }
}

