/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.tapn;

import dk.aau.cs.model.tapn.Bound;
import dk.aau.cs.model.tapn.Constant;
import dk.aau.cs.util.Require;

public class ConstantBound
implements Bound {
    private Constant constant;

    public ConstantBound(Constant constant) {
        Require.that(constant != null, "Argument must be a non-null constant");
        this.constant = constant;
    }

    @Override
    public int value() {
        return this.constant.value();
    }

    public String name() {
        return this.constant.name();
    }

    @Override
    public ConstantBound copy() {
        return new ConstantBound(this.constant.copy());
    }

    public Constant constant() {
        return this.constant;
    }

    public void setConstant(Constant newConstant) {
        Require.that(newConstant != null, "Constant cannot be null");
        this.constant = newConstant;
    }

    public String toString() {
        return this.constant.name();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constant == null ? 0 : this.constant.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConstantBound)) {
            return false;
        }
        ConstantBound other = (ConstantBound)obj;
        return !(this.constant == null ? other.constant != null : !this.constant.equals(other.constant));
    }
}

