/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.SMC;

import dk.aau.cs.model.SMC.ObservationParserConstants;
import dk.aau.cs.model.SMC.ObservationParserTokenManager;
import dk.aau.cs.model.SMC.ParseException;
import dk.aau.cs.model.SMC.SimpleCharStream;
import dk.aau.cs.model.SMC.Token;
import dk.aau.cs.model.SMC.TokenMgrError;
import dk.aau.cs.model.tapn.TimedArcPetriNetNetwork;
import dk.aau.cs.model.tapn.TimedPlace;
import dk.aau.cs.verification.observations.expressions.ObsAdd;
import dk.aau.cs.verification.observations.expressions.ObsConstant;
import dk.aau.cs.verification.observations.expressions.ObsExpression;
import dk.aau.cs.verification.observations.expressions.ObsMultiply;
import dk.aau.cs.verification.observations.expressions.ObsOperator;
import dk.aau.cs.verification.observations.expressions.ObsPlace;
import dk.aau.cs.verification.observations.expressions.ObsSubtract;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ObservationParser
implements ObservationParserConstants {
    private static TimedArcPetriNetNetwork network;
    public ObservationParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[5];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static ObsExpression parse(String observationExpressionStr, TimedArcPetriNetNetwork network) throws ParseException, TokenMgrError {
        ObservationParser.network = network;
        ObservationParser parser = new ObservationParser(new StringReader(observationExpressionStr));
        return parser.startParsing();
    }

    public final ObsExpression startParsing() throws ParseException {
        ObsExpression expr = this.expression();
        this.jj_consume_token(0);
        return expr;
    }

    public final ObsExpression expression() throws ParseException {
        ObsExpression left = this.term();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 1: {
                    op = this.jj_consume_token(1);
                    break;
                }
                case 2: {
                    op = this.jj_consume_token(2);
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ObsOperator root = op.kind == 1 ? new ObsAdd(left, null) : new ObsSubtract(left, null);
            left.setParent(root);
            ObsExpression right = this.term();
            root.setRight(right);
            right.setParent(root);
            left = root;
        }
        return left;
    }

    public final ObsExpression term() throws ParseException {
        ObsExpression left = this.factor();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 3: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(3);
            ObsMultiply root = new ObsMultiply(left, null);
            left.setParent(root);
            ObsExpression right = this.factor();
            root.setRight(right);
            right.setParent(root);
            left = root;
        }
        return left;
    }

    public final ObsExpression factor() throws ParseException {
        ObsExpression expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: 
            case 10: {
                expr = this.atom();
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                expr = this.expression();
                this.jj_consume_token(6);
                if (!expr.isOperator()) break;
                ((ObsOperator)expr).hadParentheses(true);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    public final ObsExpression atom() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7: {
                Token value = this.jj_consume_token(7);
                return new ObsConstant(Integer.parseInt(value.image));
            }
            case 10: {
                Token templateName = this.jj_consume_token(10);
                this.jj_consume_token(4);
                Token placeName = this.jj_consume_token(10);
                try {
                    boolean isShared = false;
                    for (TimedPlace timedPlace : network.sharedPlaces()) {
                        if (!timedPlace.name().equals(placeName.image)) continue;
                        isShared = true;
                        break;
                    }
                    if (!templateName.image.equals("Shared") && isShared) {
                        throw new ParseException("Place " + templateName.image + "." + placeName.image + " does not exist in the network");
                    }
                    if (isShared) {
                        return new ObsPlace("Shared", placeName.image, network);
                    }
                    return new ObsPlace(templateName.image, placeName.image, network);
                }
                catch (NullPointerException e) {
                    throw new ParseException("Place " + templateName.image + "." + placeName.image + " does not exist in the network");
                }
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{6, 6, 8, 1184, 1152};
    }

    public ObservationParser(InputStream stream) {
        this(stream, null);
    }

    public ObservationParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ObservationParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ObservationParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ObservationParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ObservationParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ObservationParser(ObservationParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ObservationParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 5; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[15];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 5; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 15; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ObservationParser.jj_la1_init_0();
    }
}

