/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.NTA.trace;

import dk.aau.cs.model.NTA.trace.Participant;
import dk.aau.cs.model.NTA.trace.SymbolicState;
import dk.aau.cs.model.NTA.trace.TAFiringAction;
import dk.aau.cs.model.NTA.trace.ValueRange;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TransitionFiring
implements TAFiringAction {
    private static final String AUTOMATA_LOCATION_PATTERN = "([\\w\\(\\)]+)\\.(\\w+)";
    private final String channel;
    private final SymbolicState previousState;
    private final Participant[] participants;
    private SymbolicState nextState;

    public TransitionFiring(SymbolicState state, String channel, Participant ... participants) {
        this.previousState = state;
        this.channel = channel;
        this.participants = participants;
    }

    public String channel() {
        return this.channel;
    }

    @Override
    public SymbolicState sourceState() {
        return this.previousState;
    }

    public Participant[] participants() {
        return this.participants;
    }

    public void setTargetState(SymbolicState state) {
        this.nextState = state;
    }

    public String toString() {
        return "Transition: channel = " + this.channel;
    }

    public static TransitionFiring parse(SymbolicState state, String element) {
        String[] split = element.split("\n");
        String channel = TransitionFiring.parseChannel(split[1]);
        Participant[] participants = TransitionFiring.parseParticipants(state, split);
        return new TransitionFiring(state, channel, participants);
    }

    private static Participant[] parseParticipants(SymbolicState state, String[] lines) {
        Participant[] participants = new Participant[lines.length - 1];
        for (int i = 1; i < lines.length; ++i) {
            Pattern pattern = Pattern.compile("([\\w\\(\\)]+)\\.(\\w+)->");
            String string = lines[i];
            Matcher matcher = pattern.matcher(string);
            matcher.find();
            String automata = matcher.group(1);
            String location = matcher.group(2);
            HashMap<String, ValueRange> localClocksAndVariables = state.getLocalClocksAndVariablesFor(automata);
            participants[i - 1] = new Participant(automata, location, localClocksAndVariables);
        }
        return participants;
    }

    private static String parseChannel(String string) {
        Pattern pattern = Pattern.compile("(\\w+)(?:\\?|!)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "tau";
    }
}

