/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.NTA.trace;

import dk.aau.cs.model.NTA.trace.SymbolicState;
import dk.aau.cs.model.NTA.trace.TAFiringAction;
import java.math.BigDecimal;
import java.math.MathContext;

public class TimeDelayFiringAction
implements TAFiringAction {
    private final SymbolicState state;
    private final BigDecimal timedelay;

    public TimeDelayFiringAction(SymbolicState state, BigDecimal delay) {
        this.state = state;
        this.timedelay = delay;
    }

    public BigDecimal getDelay() {
        return this.timedelay;
    }

    @Override
    public SymbolicState sourceState() {
        return this.state;
    }

    public String toString() {
        return "Delay: " + String.valueOf(this.timedelay);
    }

    public static TimeDelayFiringAction parse(SymbolicState previousState, String element) {
        String delayAsString = element.replace("Delay:", "").trim();
        double delay = Double.parseDouble(delayAsString);
        return new TimeDelayFiringAction(previousState, new BigDecimal(delay, new MathContext(5)));
    }
}

