/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.NTA.trace;

import dk.aau.cs.model.NTA.trace.ValueRange;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SymbolicState {
    private static final String AUTOMATA_LOCATION_PATTERN = "([\\w\\(\\)]+)\\.(\\w+)";
    private final HashMap<String, String> automataLocations;
    private final HashMap<String, HashMap<String, ValueRange>> localClocksAndVariables;
    private final HashMap<String, ValueRange> globalClocksAndVariables;

    public SymbolicState(HashMap<String, String> locations, HashMap<String, HashMap<String, ValueRange>> localClocksAndVariables, HashMap<String, ValueRange> globalClocksAndVariables) {
        this.automataLocations = locations;
        this.localClocksAndVariables = localClocksAndVariables;
        this.globalClocksAndVariables = globalClocksAndVariables;
    }

    public HashMap<String, ValueRange> getLocalClocksAndVariablesFor(String automata) {
        return this.localClocksAndVariables.get(automata);
    }

    public ValueRange getLocalClockOrVariable(String automata, String colorVariableName) {
        return this.localClocksAndVariables.get(automata).get(colorVariableName);
    }

    public ValueRange globalClockOrVariableValue(String name) {
        return this.globalClocksAndVariables.get(name);
    }

    public String locationFor(String automata) {
        return this.automataLocations.get(automata);
    }

    public boolean isConcreteState() {
        for (ValueRange valueRange : this.globalClocksAndVariables.values()) {
            if (valueRange.hasExactValue()) continue;
            return false;
        }
        for (HashMap hashMap : this.localClocksAndVariables.values()) {
            for (ValueRange range : hashMap.values()) {
                if (range.hasExactValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static SymbolicState parse(String state) {
        String[] stateLines = state.split("\n");
        HashMap<String, String> locations = SymbolicState.parseLocations(stateLines[1]);
        HashMap<String, HashMap<String, ValueRange>> localClocksAndVariables = SymbolicState.parseLocalClocksAndVariables(stateLines[2]);
        HashMap<String, ValueRange> globalClocksAndVariables = SymbolicState.parseGlobalClocksAndVariables(stateLines[2]);
        return new SymbolicState(locations, localClocksAndVariables, globalClocksAndVariables);
    }

    private static HashMap<String, String> parseLocations(String string) {
        String[] split = string.split(" ");
        HashMap<String, String> locations = new HashMap<String, String>(split.length - 2);
        Pattern pattern = Pattern.compile(AUTOMATA_LOCATION_PATTERN);
        for (int i = 1; i < split.length - 1; ++i) {
            Matcher matcher = pattern.matcher(split[i]);
            matcher.find();
            String automata = matcher.group(1);
            String location = matcher.group(2);
            locations.put(automata, location);
        }
        return locations;
    }

    private static HashMap<String, HashMap<String, ValueRange>> parseLocalClocksAndVariables(String string) {
        String[] split = string.split(" ");
        HashMap<String, HashMap<String, ValueRange>> clocksAndVariables = new HashMap<String, HashMap<String, ValueRange>>();
        Pattern pattern = Pattern.compile("([\\w\\(\\)]+)\\.(\\w+)(<|<=|=|>=|>)(\\d+(?:\\.\\d+)?)");
        for (int i = 0; i < split.length; ++i) {
            HashMap<String, ValueRange> locals;
            ValueRange range;
            boolean isUpper;
            Matcher matcher = pattern.matcher(split[i].replace(",", "").trim());
            if (!matcher.matches()) continue;
            String automata = matcher.group(1);
            String clockOrVariable = matcher.group(2);
            String operator = matcher.group(3);
            double value = Double.parseDouble(matcher.group(4));
            boolean isLower = operator.equals("<") || operator.equals("<=") || operator.equals("=");
            boolean bl = isUpper = operator.equals(">") || operator.equals(">=") || operator.equals("=");
            if (!clocksAndVariables.containsKey(automata)) {
                clocksAndVariables.put(automata, new HashMap());
            }
            ValueRange valueRange = range = (locals = clocksAndVariables.get(automata)).containsKey(clockOrVariable) ? locals.get(clockOrVariable) : new ValueRange();
            if (isLower) {
                range.setLower(new BigDecimal(value, new MathContext(5)));
                range.setLowerIncluded(operator.equals("<=") || operator.equals("="));
            }
            if (isUpper) {
                range.setUpper(new BigDecimal(value, new MathContext(5)));
                range.setUpperIncluded(operator.equals(">=") || operator.equals("="));
            }
            if (locals.containsKey(clockOrVariable)) continue;
            locals.put(clockOrVariable, range);
        }
        return clocksAndVariables;
    }

    private static HashMap<String, ValueRange> parseGlobalClocksAndVariables(String string) {
        String[] split = string.split(" ");
        HashMap<String, ValueRange> global = new HashMap<String, ValueRange>();
        Pattern pattern = Pattern.compile("(\\w+)(<|<=|=|>=|>)(\\d+(?:\\.\\d+)?)");
        for (String variable : split) {
            ValueRange range;
            Matcher matcher = pattern.matcher(variable.trim());
            if (!matcher.matches()) continue;
            String name = matcher.group(1);
            String operator = matcher.group(2);
            double valueAsDouble = Double.parseDouble(matcher.group(3));
            boolean isLower = operator.equals("<") || operator.equals("<=") || operator.equals("=");
            boolean isUpper = operator.equals(">") || operator.equals(">=") || operator.equals("=");
            ValueRange valueRange = range = global.containsKey(name) ? global.get(name) : new ValueRange();
            if (isLower) {
                range.setLower(new BigDecimal(valueAsDouble, new MathContext(5)));
                range.setLowerIncluded(operator.equals("<=") || operator.equals("="));
            }
            if (isUpper) {
                range.setUpper(new BigDecimal(valueAsDouble, new MathContext(5)));
                range.setUpperIncluded(operator.equals(">=") || operator.equals("="));
            }
            if (global.containsKey(name)) continue;
            global.put(name, range);
        }
        return global;
    }
}

