/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.NTA;

import dk.aau.cs.model.NTA.TimedAutomaton;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NTA {
    private List<TimedAutomaton> automata;
    private String globalDeclarations = "";
    private String systemDeclarations = "";

    public NTA() {
        this.automata = new ArrayList<TimedAutomaton>();
    }

    public NTA(List<TimedAutomaton> automata) {
        this.automata = automata;
    }

    public NTA(List<TimedAutomaton> automata, String systemDeclarations, String globalDeclarations) {
        this(automata);
        this.systemDeclarations = systemDeclarations;
        this.globalDeclarations = globalDeclarations;
    }

    public List<TimedAutomaton> getTimedAutomata() {
        return this.automata;
    }

    public void setTimedAutomata(ArrayList<TimedAutomaton> automata) {
        this.automata = automata;
    }

    public String getGlobalDeclarations() {
        return this.globalDeclarations;
    }

    public void setGlobalDeclarations(String globalDecl) {
        this.globalDeclarations = globalDecl;
    }

    public String getSystemDeclarations() {
        return this.systemDeclarations;
    }

    public void setSystemDeclarations(String systemDecl) {
        this.systemDeclarations = systemDecl;
    }

    public void addTimedAutomaton(TimedAutomaton ta) {
        this.automata.add(ta);
    }

    public void addTimedAutomata(Collection<TimedAutomaton> tas) {
        this.automata.addAll(tas);
    }

    public void outputToUPPAALXML(PrintStream xmlFile) {
        xmlFile.println("<nta>");
        xmlFile.append("<declaration>");
        xmlFile.append(this.globalDeclarations);
        xmlFile.append("</declaration>\n");
        StringBuffer a = new StringBuffer();
        for (TimedAutomaton ta : this.automata) {
            a = ta.toXML();
            xmlFile.append(a);
        }
        xmlFile.append("<system>");
        xmlFile.append(this.systemDeclarations);
        xmlFile.append("</system>\n");
        xmlFile.println("</nta>");
    }
}

