/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.NTA;

public class Location {
    private static int newid = 0;
    private final int id = newid++;
    private String name = "";
    private String invariant = "";
    private boolean isUrgent = false;
    private boolean isCommitted = false;

    public Location(String name, String invariant, int x, int y, boolean isUrgent, boolean isCommitted) {
        this(name, invariant);
        this.isUrgent = isUrgent;
        this.isCommitted = isCommitted;
    }

    public Location(String name, String invariant) {
        if (!name.equals("")) {
            this.name = name;
        }
        this.invariant = invariant.equals("") ? "<inf" : invariant;
    }

    public int getID() {
        return this.id;
    }

    public String getInvariant() {
        return this.invariant;
    }

    public boolean isUrgent() {
        return this.isUrgent;
    }

    public void setUrgent(boolean isUrgent) {
        this.isUrgent = isUrgent;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void setCommitted(boolean isCommitted) {
        this.isCommitted = isCommitted;
    }

    public StringBuffer toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<location id=\"a" + this.id + "\" >\n");
        res.append("<name>" + this.name + "</name>\n");
        if (!this.invariant.equals("<inf")) {
            res.append("<label kind=\"invariant\">" + this.invariant.replace("&&", "&amp;&amp;").replace("<", "&lt;") + "</label>\n");
        }
        if (this.isCommitted) {
            res.append("<committed/>\n");
        } else if (this.isUrgent) {
            res.append("<urgent/>\n");
        }
        res.append("</location>\n");
        return res;
    }

    public String toString() {
        return "Location " + this.name + ". Invariant: " + this.invariant + ", Committed: " + this.isCommitted + ", Urgent: " + this.isUrgent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

