/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.NTA;

import dk.aau.cs.model.NTA.Location;

public class Edge {
    private String guard = "";
    private String sync = "";
    private String update = "";
    private Location source;
    private Location dest;

    public Edge(Location source, Location dest, String guard, String sync, String update) {
        this.source = source;
        this.dest = dest;
        this.guard = guard;
        this.sync = sync;
        this.update = update;
    }

    public Location getSource() {
        return this.source;
    }

    public void setSource(Location source) {
        this.source = source;
    }

    public Location getDestination() {
        return this.dest;
    }

    public void setDestination(Location dest) {
        this.dest = dest;
    }

    public String getGuard() {
        return this.guard;
    }

    public void setGuard(String guard) {
        this.guard = guard;
    }

    public String getSync() {
        return this.sync;
    }

    public void setSync(String sync) {
        this.sync = sync;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public StringBuffer toXML() {
        StringBuffer res = new StringBuffer();
        res.append("<transition>\n");
        res.append("<source ref=\"a" + this.source.getID() + "\" />\n");
        res.append("<target ref=\"a" + this.dest.getID() + "\" />\n");
        String tmp = this.guard.replace("<", "&lt;").replace(">", "&gt;");
        tmp = tmp.replace("&&", "&amp;&amp;");
        res.append("<label kind=\"guard\">" + tmp + "</label>\n");
        res.append("<label kind=\"synchronisation\">" + this.sync + "</label>\n");
        res.append("<label kind=\"assignment\">" + this.update + "</label>\n");
        res.append("</transition>\n");
        return res;
    }

    public String toString() {
        return "Edge from " + this.source.getName() + " to " + this.dest.getName() + ". Guard: " + this.guard + ", Sync: " + this.sync + ", Update: " + this.update;
    }
}

