/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Expressions.TupleExpression;
import dk.aau.cs.model.CPN.Expressions.UserOperatorExpression;
import dk.aau.cs.model.CPN.Variable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class VariableExpression
extends ColorExpression {
    private final Variable variable;

    public Variable getVariable() {
        return this.variable;
    }

    public VariableExpression(Variable variable) {
        this(variable, variable.getColorType());
    }

    public VariableExpression(Variable variable, ColorType colorType) {
        super(colorType);
        this.variable = variable;
    }

    @Override
    public List<Color> eval(ExpressionContext context) {
        return Collections.singletonList(context.binding.get(this.variable.getName()));
    }

    @Override
    public boolean containsColor(Color color) {
        return false;
    }

    @Override
    public ColorExpression updateColor(Color color, ColorType newColorType) {
        return this;
    }

    @Override
    public boolean hasVariable(List<Variable> variables) {
        for (Variable var : variables) {
            if (!this.variable.getName().equals(var.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ColorExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (replaceAllInstances) {
            if (this.equals(object1) && object2 instanceof ColorExpression) {
                ColorExpression obj2 = (ColorExpression)object2;
                obj2.setParent(this.parent);
                return obj2;
            }
            return this;
        }
        if (this.strictEquals(object1) && object2 instanceof ColorExpression) {
            ColorExpression obj2 = (ColorExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        return this;
    }

    @Override
    public ColorExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public ColorExpression copy() {
        return new VariableExpression(this.variable);
    }

    @Override
    public VariableExpression deepCopy() {
        return new VariableExpression(this.variable);
    }

    @Override
    public boolean containsPlaceHolder() {
        return false;
    }

    @Override
    public ColorExpression findFirstPlaceHolder() {
        return null;
    }

    @Override
    public void getValues(ExprValues exprValues) {
        exprValues.addVariable(this.variable);
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        variables.add(this.variable);
    }

    public String toString() {
        return this.variable.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof VariableExpression) {
            VariableExpression expr = (VariableExpression)o;
            return this.variable.getName().equals(expr.variable.getName());
        }
        return false;
    }

    public boolean strictEquals(Object o) {
        if (o instanceof VariableExpression) {
            VariableExpression expr = (VariableExpression)o;
            return this.variable.getName().equals(expr.variable.getName()) && this == expr;
        }
        return false;
    }

    @Override
    public ExprStringPosition[] getChildren() {
        return new ExprStringPosition[0];
    }

    @Override
    public boolean isSimpleProperty() {
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.variable.hashCode();
        return result;
    }

    @Override
    public boolean isComparable(ColorExpression otherExpr) {
        if ((otherExpr = otherExpr.getBottomColorExpression()) instanceof TupleExpression) {
            return false;
        }
        if (otherExpr instanceof UserOperatorExpression) {
            UserOperatorExpression otherUserOpExpression = (UserOperatorExpression)otherExpr;
            return this.variable.getColorType().equals(otherUserOpExpression.getUserOperator().getColorType());
        }
        if (!(otherExpr instanceof VariableExpression)) {
            return false;
        }
        VariableExpression otherUserOpExpression = (VariableExpression)otherExpr;
        return this.variable.getColorType().equals(otherUserOpExpression.variable.getColorType());
    }

    @Override
    public ColorExpression getBottomColorExpression() {
        return this;
    }

    @Override
    public Vector<ColorType> getColorTypes() {
        return new Vector<ColorType>(Collections.singletonList(this.variable.getColorType()));
    }

    @Override
    public ColorExpression getExprWithNewColorType(ColorType ct) {
        return new VariableExpression(this.variable.getExprWithNewColorType(ct));
    }
}

