/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.ProductType;
import dk.aau.cs.model.CPN.Variable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class TupleExpression
extends ColorExpression {
    private Vector<ColorExpression> colors;

    public Vector<ColorExpression> getColors() {
        return this.colors;
    }

    public TupleExpression(Vector<ColorExpression> colors) {
        this(colors, null);
    }

    public TupleExpression(Vector<ColorExpression> colors, ColorType colorType) {
        super(colorType);
        this.colors = colors;
        int i = 0;
        for (ColorExpression color : colors) {
            color.setParent(this);
            color.setIndex(i);
            ++i;
        }
    }

    @Override
    public List<Color> eval(ExpressionContext context) {
        Vector<Color> colors = new Vector<Color>();
        Vector<ColorType> colorTypes = new Vector<ColorType>();
        for (ColorExpression ce : this.colors) {
            List<Color> color = ce.eval(context);
            colors.addAll(color);
            colorTypes.add(color.get(0).getColorType());
        }
        ProductType pt = context.findProductColorType(colorTypes);
        return Collections.singletonList(pt.getColor(colors));
    }

    @Override
    public boolean containsColor(Color color) {
        boolean containsColor = false;
        for (int i = 0; i < this.colors.size(); ++i) {
            if (!this.colors.get(i).containsColor(color)) continue;
            containsColor = true;
            break;
        }
        return containsColor;
    }

    @Override
    public ColorExpression updateColor(Color color, ColorType newColorType) {
        Vector<ColorExpression> newColors = new Vector<ColorExpression>();
        for (ColorExpression expr : this.colors) {
            ColorExpression newExpr = expr.updateColor(color, newColorType);
            if (newExpr != null) {
                newColors.add(newExpr);
                continue;
            }
            return null;
        }
        this.colors = newColors;
        return this;
    }

    @Override
    public boolean hasVariable(List<Variable> variables) {
        for (ColorExpression expr : this.colors) {
            if (!expr.hasVariable(variables)) continue;
            return true;
        }
        return false;
    }

    public ColorType getColorType(List<ColorType> colorTypes) {
        Vector<ColorType> expressionColorTypes = new Vector<ColorType>();
        for (ColorExpression ce : this.colors) {
            expressionColorTypes.add(ce.getColorType());
        }
        for (ColorType ct : colorTypes) {
            ProductType pt;
            if (!(ct instanceof ProductType) || !(pt = (ProductType)ct).containsTypes(expressionColorTypes)) continue;
            return pt;
        }
        return null;
    }

    @Override
    public boolean isComparable(ColorExpression otherExpr) {
        if (!((otherExpr = otherExpr.getBottomColorExpression()) instanceof TupleExpression)) {
            return false;
        }
        TupleExpression otherTupleExpression = (TupleExpression)otherExpr;
        if (otherTupleExpression.getColors().size() != this.getColors().size()) {
            return false;
        }
        for (int i = 0; i < this.getColors().size(); ++i) {
            if (this.getColors().get(i).isComparable(otherTupleExpression.getColors().get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSimpleProperty() {
        return false;
    }

    @Override
    public ColorExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (object1 == this && object2 instanceof ColorExpression) {
            ColorExpression obj2 = (ColorExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        for (int i = 0; i < this.colors.size(); ++i) {
            this.colors.set(i, this.colors.get(i).replace(object1, object2, replaceAllInstances));
        }
        return this;
    }

    @Override
    public ColorExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public ColorExpression copy() {
        return this.colorType == null ? new TupleExpression(new Vector<ColorExpression>(this.colors)) : new TupleExpression(new Vector<ColorExpression>(this.colors), this.colorType.copy());
    }

    @Override
    public TupleExpression deepCopy() {
        Vector<ColorExpression> colorsCopy = new Vector<ColorExpression>();
        for (ColorExpression expr : this.colors) {
            colorsCopy.add(expr.deepCopy());
        }
        return this.colorType == null ? new TupleExpression(colorsCopy) : new TupleExpression(colorsCopy, this.colorType.copy());
    }

    @Override
    public boolean containsPlaceHolder() {
        for (ColorExpression expr : this.colors) {
            if (!expr.containsPlaceHolder()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ColorExpression findFirstPlaceHolder() {
        for (ColorExpression expr : this.colors) {
            if (!expr.containsPlaceHolder()) continue;
            return expr.findFirstPlaceHolder();
        }
        return null;
    }

    @Override
    public void getValues(ExprValues exprValues) {
        for (ColorExpression color : this.colors) {
            color.getValues(exprValues);
        }
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        for (ColorExpression element : this.colors) {
            element.getVariables(variables);
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder("(" + String.valueOf(this.colors.get(0)));
        for (int i = 1; i < this.colors.size(); ++i) {
            res.append(", ").append(this.colors.get(i).toString());
        }
        res.append(")");
        return res.toString();
    }

    @Override
    public ExprStringPosition[] getChildren() {
        ExprStringPosition[] children = new ExprStringPosition[this.colors.size()];
        int i = 0;
        int endPrev = 0;
        for (ColorExpression p : this.colors) {
            ExprStringPosition pos;
            int start = 1;
            int end = 0;
            if (i == 0) {
                endPrev = end = start + p.toString().length();
            } else {
                start = endPrev + 2;
                endPrev = end = start + p.toString().length();
            }
            children[i] = pos = new ExprStringPosition(start, end, p);
            ++i;
        }
        return children;
    }

    @Override
    public ColorExpression getBottomColorExpression() {
        return this;
    }

    @Override
    public Vector<ColorType> getColorTypes() {
        Vector<ColorType> constituentColorTypes = new Vector<ColorType>();
        for (ColorExpression uexpr : this.getColors()) {
            constituentColorTypes.addAll(uexpr.getColorTypes());
        }
        return constituentColorTypes;
    }

    @Override
    public TupleExpression getExprWithNewColorType(ColorType ct) {
        Vector<ColorExpression> colorExpressions = new Vector<ColorExpression>();
        for (ColorExpression colorExpression : this.colors) {
            if (colorExpression.colorType.getName().equals(ct.getName())) {
                colorExpressions.add(colorExpression.getExprWithNewColorType(ct));
                continue;
            }
            colorExpressions.add(colorExpression);
        }
        return new TupleExpression(colorExpressions, ct);
    }
}

