/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Variable;
import java.util.Set;

public class SubtractExpression
extends ArcExpression {
    private ArcExpression left;
    private ArcExpression right;

    public SubtractExpression(ArcExpression left, ArcExpression right) {
        this.left = left;
        this.right = right;
    }

    public SubtractExpression(SubtractExpression otherExpr) {
        super(otherExpr);
        this.left = otherExpr.left.copy();
        this.right = otherExpr.right.copy();
    }

    public ArcExpression getLeftExpression() {
        return this.left;
    }

    public ArcExpression getRightExpression() {
        return this.right;
    }

    @Override
    public ColorMultiset eval(ExpressionContext context) {
        ColorMultiset result = this.left.eval(context);
        result.subAll(this.right.eval(context));
        return result;
    }

    @Override
    public Integer weight() {
        return null;
    }

    @Override
    public boolean containsColor(Color color) {
        return this.left.containsColor(color) || this.right.containsColor(color);
    }

    @Override
    public ArcExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public ArcExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (object1 == this && object2 instanceof ArcExpression) {
            ArcExpression obj2 = (ArcExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        ArcExpression newLeft = this.left.replace(object1, object2, replaceAllInstances);
        ArcExpression newRight = this.right.replace(object1, object2, replaceAllInstances);
        if (newLeft != this.left) {
            this.left = newLeft;
            this.left.setParent(this);
        }
        if (newRight != this.right) {
            this.right = newRight;
            this.right.setParent(this);
        }
        return this;
    }

    @Override
    public ArcExpression copy() {
        return new SubtractExpression(this.left, this.right);
    }

    @Override
    public ArcExpression deepCopy() {
        SubtractExpression copy = new SubtractExpression(this.left.deepCopy(), this.right.deepCopy());
        copy.setParent(this.parent);
        return copy;
    }

    @Override
    public boolean containsPlaceHolder() {
        return this.left.containsPlaceHolder() || this.right.containsPlaceHolder();
    }

    @Override
    public Expression findFirstPlaceHolder() {
        if (this.left.containsPlaceHolder()) {
            return this.left.findFirstPlaceHolder();
        }
        return this.right.findFirstPlaceHolder();
    }

    @Override
    public void getValues(ExprValues exprValues) {
        this.left.getValues(exprValues);
        this.right.getValues(exprValues);
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        this.left.getVariables(variables);
        this.right.getVariables(variables);
    }

    @Override
    public boolean addParentheses() {
        return this.parent != null;
    }

    public String toString() {
        if (this.addParentheses()) {
            return "(" + this.left.toString() + " - " + this.right.toString() + ")";
        }
        return this.left.toString() + " - " + this.right.toString();
    }

    @Override
    public boolean isSimpleProperty() {
        return false;
    }

    @Override
    public ExprStringPosition[] getChildren() {
        ExprStringPosition[] children = new ExprStringPosition[2];
        int leftStart = this.addParentheses() ? 1 : 0;
        int leftEnd = leftStart + this.left.toString().length();
        children[0] = new ExprStringPosition(leftStart, leftEnd, this.left);
        int rightStart = leftEnd + 3;
        int rightEnd = rightStart + this.right.toString().length();
        children[1] = new ExprStringPosition(rightStart, rightEnd, this.right);
        return children;
    }

    public boolean equals(Object o) {
        if (o instanceof SubtractExpression) {
            SubtractExpression expr = (SubtractExpression)o;
            return this.left.equals(expr.left) && this.right.equals(expr.right);
        }
        return false;
    }

    @Override
    public ArcExpression getExprWithNewColorType(ColorType ct) {
        return new SubtractExpression(this.left.getExprWithNewColorType(ct), this.right.getExprWithNewColorType(ct));
    }

    @Override
    public ArcExpression getExprConverted(ColorType oldCt, ColorType newCt) {
        return new SubtractExpression(this.left.getExprConverted(oldCt, newCt), this.right.getExprConverted(oldCt, newCt));
    }
}

