/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Variable;
import java.util.Set;

public class ScalarProductExpression
extends ArcExpression {
    private final Integer scalar;
    private ArcExpression expr;

    public ScalarProductExpression(Integer scalar, ArcExpression expr) {
        this.scalar = scalar;
        this.expr = expr;
    }

    @Override
    public ColorMultiset eval(ExpressionContext context) {
        ColorMultiset result = this.expr.eval(context);
        result.scale(this.scalar);
        return result;
    }

    public Integer getScalar() {
        return this.scalar;
    }

    public ArcExpression getExpr() {
        return this.expr;
    }

    @Override
    public Integer weight() {
        return this.scalar * this.expr.weight();
    }

    @Override
    public boolean containsColor(Color color) {
        return this.expr.containsColor(color);
    }

    @Override
    public ArcExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (this == object1 && object2 instanceof ArcExpression) {
            ArcExpression obj2 = (ArcExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        this.expr = this.expr.replace(object1, object2, replaceAllInstances);
        return this;
    }

    @Override
    public ArcExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public ArcExpression copy() {
        return new ScalarProductExpression(this.scalar, this.expr);
    }

    @Override
    public ArcExpression deepCopy() {
        ScalarProductExpression copy = new ScalarProductExpression(this.scalar, this.expr.deepCopy());
        copy.setParent(this.parent);
        return copy;
    }

    @Override
    public boolean containsPlaceHolder() {
        return this.expr.containsPlaceHolder();
    }

    @Override
    public Expression findFirstPlaceHolder() {
        return this.expr.findFirstPlaceHolder();
    }

    @Override
    public void getValues(ExprValues exprValues) {
        this.expr.getValues(exprValues);
    }

    @Override
    public boolean isSimpleProperty() {
        return false;
    }

    @Override
    public ExprStringPosition[] getChildren() {
        int start = 4;
        int end = start + this.expr.toString().length();
        ExprStringPosition pos = new ExprStringPosition(start, end, this.expr);
        return new ExprStringPosition[]{pos};
    }

    public boolean equals(Object o) {
        if (o instanceof ScalarProductExpression) {
            ScalarProductExpression expr = (ScalarProductExpression)o;
            return this.expr.equals(expr.expr);
        }
        return false;
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        this.expr.getVariables(variables);
    }

    public String toString() {
        return this.scalar.toString() + " * " + this.expr.toString();
    }

    @Override
    public ArcExpression getExprWithNewColorType(ColorType ct) {
        return new ScalarProductExpression(this.scalar, this.expr.getExprWithNewColorType(ct));
    }

    @Override
    public ArcExpression getExprConverted(ColorType oldCt, ColorType newCt) {
        return new ScalarProductExpression(this.scalar, this.expr.getExprConverted(oldCt, newCt));
    }
}

