/*
 * Decompiled with CFR 0.152.
 */
package dk.aau.cs.model.CPN.Expressions;

import dk.aau.cs.model.CPN.Color;
import dk.aau.cs.model.CPN.ColorMultiset;
import dk.aau.cs.model.CPN.ColorType;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprStringPosition;
import dk.aau.cs.model.CPN.ExpressionSupport.ExprValues;
import dk.aau.cs.model.CPN.Expressions.AllExpression;
import dk.aau.cs.model.CPN.Expressions.ArcExpression;
import dk.aau.cs.model.CPN.Expressions.ColorExpression;
import dk.aau.cs.model.CPN.Expressions.Expression;
import dk.aau.cs.model.CPN.Expressions.ExpressionContext;
import dk.aau.cs.model.CPN.Variable;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class NumberOfExpression
extends ArcExpression {
    private Integer number;
    private final Vector<ColorExpression> color;

    public Vector<ColorExpression> getNumberOfExpression() {
        return this.color;
    }

    public NumberOfExpression(Integer number, Vector<ColorExpression> color) {
        this.number = number;
        this.color = color;
    }

    public Integer getNumber() {
        return this.number;
    }

    public Vector<ColorExpression> getColor() {
        return this.color;
    }

    public boolean equalsColor(NumberOfExpression otherExpr) {
        for (int i = 0; i < this.color.size(); ++i) {
            if (this.color.get(i).toString().equals(otherExpr.color.get(i).toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ArcExpression replace(Expression object1, Expression object2, boolean replaceAllInstances) {
        if (object1 == this && object2 instanceof ArcExpression) {
            ArcExpression obj2 = (ArcExpression)object2;
            obj2.setParent(this.parent);
            return obj2;
        }
        for (int i = 0; i < this.color.size(); ++i) {
            this.color.set(i, this.color.get(i).replace(object1, object2, replaceAllInstances));
        }
        return this;
    }

    @Override
    public ArcExpression replace(Expression object1, Expression object2) {
        return this.replace(object1, object2, false);
    }

    @Override
    public ColorMultiset eval(ExpressionContext context) {
        assert (!this.color.isEmpty());
        Vector<Color> colors = new Vector<Color>();
        ColorType ct = null;
        for (ColorExpression ce : this.color) {
            if (ce instanceof AllExpression) {
                if (ct == null) {
                    ct = ((AllExpression)ce).getSort();
                } else assert (ct == ((AllExpression)ce).getSort());
            }
            List<Color> c = ce.eval(context);
            if (ct == null) {
                ct = c.get(0).getColorType();
            } else assert (ct == c.get(0).getColorType());
            colors.addAll(c);
        }
        return new ColorMultiset(ct, this.number, colors, this.color);
    }

    @Override
    public Integer weight() {
        return this.number * this.color.size();
    }

    @Override
    public boolean containsColor(Color color) {
        for (ColorExpression c : this.color) {
            if (!c.containsColor(color)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArcExpression copy() {
        return new NumberOfExpression(this.number, new Vector<ColorExpression>((Vector)this.color.clone()));
    }

    @Override
    public ArcExpression deepCopy() {
        Vector<ColorExpression> colorsCopy = new Vector<ColorExpression>();
        for (ColorExpression colorExpr : this.color) {
            colorsCopy.add(colorExpr.deepCopy());
        }
        return new NumberOfExpression(this.number, colorsCopy);
    }

    @Override
    public boolean containsPlaceHolder() {
        for (ColorExpression expr : this.color) {
            if (!expr.containsPlaceHolder()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression findFirstPlaceHolder() {
        for (ColorExpression expr : this.color) {
            if (!expr.containsPlaceHolder()) continue;
            return expr.findFirstPlaceHolder();
        }
        return null;
    }

    @Override
    public void getValues(ExprValues exprValues) {
        for (ColorExpression colorExpression : this.color) {
            colorExpression.getValues(exprValues);
        }
    }

    @Override
    public void getVariables(Set<Variable> variables) {
        for (ColorExpression element : this.color) {
            element.getVariables(variables);
        }
    }

    public String toString() {
        StringBuilder res = new StringBuilder(this.number.toString() + "'" + this.color.get(0).toString());
        for (int i = 1; i < this.color.size(); ++i) {
            res.append(" + ");
            res.append(this.number.toString()).append("'(").append(this.color.get(i).toString()).append(")");
        }
        return res.toString();
    }

    @Override
    public ExprStringPosition[] getChildren() {
        ExprStringPosition[] children = new ExprStringPosition[this.color.size()];
        int i = 0;
        int endPrev = 0;
        int start = 2;
        int end = 0;
        for (ColorExpression p : this.color) {
            ExprStringPosition pos;
            if (i == 0) {
                endPrev = end = start + p.toString().length();
            } else {
                start = endPrev;
                endPrev = end = start + p.toString().length();
            }
            children[i] = pos = new ExprStringPosition(start, end, p);
            ++i;
        }
        return children;
    }

    public void setNumber(int newNumber) {
        this.number = newNumber;
    }

    @Override
    public ArcExpression getExprWithNewColorType(ColorType ct) {
        Vector<ColorExpression> colorExpressions = new Vector<ColorExpression>();
        ColorExpression colorExpression = this.color.get(0);
        if (colorExpression.colorType == null || colorExpression.colorType.getName().equals(ct.getName()) || this.colorInColorType(colorExpression, ct)) {
            colorExpressions.add(colorExpression.getExprWithNewColorType(ct));
        } else {
            colorExpressions.add(colorExpression);
        }
        return new NumberOfExpression(this.number, colorExpressions);
    }

    @Override
    public ArcExpression getExprConverted(ColorType oldCt, ColorType newCt) {
        Vector<ColorExpression> colorExpressions = new Vector<ColorExpression>();
        ColorExpression colorExpression = this.color.get(0);
        if (colorExpression.colorType == null || colorExpression.colorType.getName().equals(oldCt.getName()) || this.colorInColorType(colorExpression, oldCt)) {
            colorExpressions.add(colorExpression.getExprWithNewColorType(newCt));
        } else {
            colorExpressions.add(colorExpression);
        }
        return new NumberOfExpression(this.number, colorExpressions);
    }

    private boolean colorInColorType(ColorExpression colorExpression, ColorType colorType) {
        for (Color c : colorType.getColors()) {
            if (!colorExpression.containsColor(c)) continue;
            return true;
        }
        return false;
    }
}

